/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the details of the flow run, including the timestamp, status, and message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionDetails.Builder, ExecutionDetails> {
    private static final SdkField<String> MOST_RECENT_EXECUTION_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("mostRecentExecutionMessage")
            .getter(getter(ExecutionDetails::mostRecentExecutionMessage))
            .setter(setter(Builder::mostRecentExecutionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionMessage").build())
            .build();

    private static final SdkField<Instant> MOST_RECENT_EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("mostRecentExecutionTime").getter(getter(ExecutionDetails::mostRecentExecutionTime))
            .setter(setter(Builder::mostRecentExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionTime").build())
            .build();

    private static final SdkField<String> MOST_RECENT_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mostRecentExecutionStatus").getter(getter(ExecutionDetails::mostRecentExecutionStatusAsString))
            .setter(setter(Builder::mostRecentExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MOST_RECENT_EXECUTION_MESSAGE_FIELD, MOST_RECENT_EXECUTION_TIME_FIELD, MOST_RECENT_EXECUTION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mostRecentExecutionMessage;

    private final Instant mostRecentExecutionTime;

    private final String mostRecentExecutionStatus;

    private ExecutionDetails(BuilderImpl builder) {
        this.mostRecentExecutionMessage = builder.mostRecentExecutionMessage;
        this.mostRecentExecutionTime = builder.mostRecentExecutionTime;
        this.mostRecentExecutionStatus = builder.mostRecentExecutionStatus;
    }

    /**
     * <p>
     * Describes the details of the most recent flow run.
     * </p>
     * 
     * @return Describes the details of the most recent flow run.
     */
    public final String mostRecentExecutionMessage() {
        return mostRecentExecutionMessage;
    }

    /**
     * <p>
     * Specifies the time of the most recent flow run.
     * </p>
     * 
     * @return Specifies the time of the most recent flow run.
     */
    public final Instant mostRecentExecutionTime() {
        return mostRecentExecutionTime;
    }

    /**
     * <p>
     * Specifies the status of the most recent flow run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mostRecentExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mostRecentExecutionStatusAsString}.
     * </p>
     * 
     * @return Specifies the status of the most recent flow run.
     * @see ExecutionStatus
     */
    public final ExecutionStatus mostRecentExecutionStatus() {
        return ExecutionStatus.fromValue(mostRecentExecutionStatus);
    }

    /**
     * <p>
     * Specifies the status of the most recent flow run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mostRecentExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mostRecentExecutionStatusAsString}.
     * </p>
     * 
     * @return Specifies the status of the most recent flow run.
     * @see ExecutionStatus
     */
    public final String mostRecentExecutionStatusAsString() {
        return mostRecentExecutionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mostRecentExecutionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(mostRecentExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(mostRecentExecutionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails) obj;
        return Objects.equals(mostRecentExecutionMessage(), other.mostRecentExecutionMessage())
                && Objects.equals(mostRecentExecutionTime(), other.mostRecentExecutionTime())
                && Objects.equals(mostRecentExecutionStatusAsString(), other.mostRecentExecutionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionDetails").add("MostRecentExecutionMessage", mostRecentExecutionMessage())
                .add("MostRecentExecutionTime", mostRecentExecutionTime())
                .add("MostRecentExecutionStatus", mostRecentExecutionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mostRecentExecutionMessage":
            return Optional.ofNullable(clazz.cast(mostRecentExecutionMessage()));
        case "mostRecentExecutionTime":
            return Optional.ofNullable(clazz.cast(mostRecentExecutionTime()));
        case "mostRecentExecutionStatus":
            return Optional.ofNullable(clazz.cast(mostRecentExecutionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionDetails, T> g) {
        return obj -> g.apply((ExecutionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionDetails> {
        /**
         * <p>
         * Describes the details of the most recent flow run.
         * </p>
         * 
         * @param mostRecentExecutionMessage
         *        Describes the details of the most recent flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mostRecentExecutionMessage(String mostRecentExecutionMessage);

        /**
         * <p>
         * Specifies the time of the most recent flow run.
         * </p>
         * 
         * @param mostRecentExecutionTime
         *        Specifies the time of the most recent flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mostRecentExecutionTime(Instant mostRecentExecutionTime);

        /**
         * <p>
         * Specifies the status of the most recent flow run.
         * </p>
         * 
         * @param mostRecentExecutionStatus
         *        Specifies the status of the most recent flow run.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder mostRecentExecutionStatus(String mostRecentExecutionStatus);

        /**
         * <p>
         * Specifies the status of the most recent flow run.
         * </p>
         * 
         * @param mostRecentExecutionStatus
         *        Specifies the status of the most recent flow run.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder mostRecentExecutionStatus(ExecutionStatus mostRecentExecutionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String mostRecentExecutionMessage;

        private Instant mostRecentExecutionTime;

        private String mostRecentExecutionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            mostRecentExecutionMessage(model.mostRecentExecutionMessage);
            mostRecentExecutionTime(model.mostRecentExecutionTime);
            mostRecentExecutionStatus(model.mostRecentExecutionStatus);
        }

        public final String getMostRecentExecutionMessage() {
            return mostRecentExecutionMessage;
        }

        public final void setMostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
        }

        @Override
        public final Builder mostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
            return this;
        }

        public final Instant getMostRecentExecutionTime() {
            return mostRecentExecutionTime;
        }

        public final void setMostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
        }

        @Override
        public final Builder mostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
            return this;
        }

        public final String getMostRecentExecutionStatus() {
            return mostRecentExecutionStatus;
        }

        public final void setMostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
        }

        @Override
        public final Builder mostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
            return this;
        }

        @Override
        public final Builder mostRecentExecutionStatus(ExecutionStatus mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus(mostRecentExecutionStatus == null ? null : mostRecentExecutionStatus.toString());
            return this;
        }

        @Override
        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
