/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the flow, such as its source, destination, trigger type, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowDefinition implements SdkPojo, Serializable, ToCopyableBuilder<FlowDefinition.Builder, FlowDefinition> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowArn").getter(getter(FlowDefinition::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FlowDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(FlowDefinition::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowStatus").getter(getter(FlowDefinition::flowStatusAsString)).setter(setter(Builder::flowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()).build();

    private static final SdkField<String> SOURCE_CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceConnectorType").getter(getter(FlowDefinition::sourceConnectorTypeAsString))
            .setter(setter(Builder::sourceConnectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorType").build())
            .build();

    private static final SdkField<String> SOURCE_CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceConnectorLabel").getter(getter(FlowDefinition::sourceConnectorLabel))
            .setter(setter(Builder::sourceConnectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorLabel").build())
            .build();

    private static final SdkField<String> DESTINATION_CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationConnectorType").getter(getter(FlowDefinition::destinationConnectorTypeAsString))
            .setter(setter(Builder::destinationConnectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorType").build())
            .build();

    private static final SdkField<String> DESTINATION_CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationConnectorLabel").getter(getter(FlowDefinition::destinationConnectorLabel))
            .setter(setter(Builder::destinationConnectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorLabel").build())
            .build();

    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerType").getter(getter(FlowDefinition::triggerTypeAsString)).setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(FlowDefinition::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(FlowDefinition::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(FlowDefinition::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(FlowDefinition::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(FlowDefinition::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ExecutionDetails> LAST_RUN_EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("lastRunExecutionDetails")
            .getter(getter(FlowDefinition::lastRunExecutionDetails)).setter(setter(Builder::lastRunExecutionDetails))
            .constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunExecutionDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            DESCRIPTION_FIELD, FLOW_NAME_FIELD, FLOW_STATUS_FIELD, SOURCE_CONNECTOR_TYPE_FIELD, SOURCE_CONNECTOR_LABEL_FIELD,
            DESTINATION_CONNECTOR_TYPE_FIELD, DESTINATION_CONNECTOR_LABEL_FIELD, TRIGGER_TYPE_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD, LAST_RUN_EXECUTION_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String description;

    private final String flowName;

    private final String flowStatus;

    private final String sourceConnectorType;

    private final String sourceConnectorLabel;

    private final String destinationConnectorType;

    private final String destinationConnectorLabel;

    private final String triggerType;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String createdBy;

    private final String lastUpdatedBy;

    private final Map<String, String> tags;

    private final ExecutionDetails lastRunExecutionDetails;

    private FlowDefinition(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.flowStatus = builder.flowStatus;
        this.sourceConnectorType = builder.sourceConnectorType;
        this.sourceConnectorLabel = builder.sourceConnectorLabel;
        this.destinationConnectorType = builder.destinationConnectorType;
        this.destinationConnectorLabel = builder.destinationConnectorLabel;
        this.triggerType = builder.triggerType;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
        this.lastRunExecutionDetails = builder.lastRunExecutionDetails;
    }

    /**
     * <p>
     * The flow's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The flow's Amazon Resource Name (ARN).
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * A user-entered description of the flow.
     * </p>
     * 
     * @return A user-entered description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * </p>
     * 
     * @return The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(flowStatus);
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final String flowStatusAsString() {
        return flowStatus;
    }

    /**
     * <p>
     * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceConnectorType} will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sourceConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType sourceConnectorType() {
        return ConnectorType.fromValue(sourceConnectorType);
    }

    /**
     * <p>
     * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceConnectorType} will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sourceConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String sourceConnectorTypeAsString() {
        return sourceConnectorType;
    }

    /**
     * <p>
     * The label of the source connector in the flow.
     * </p>
     * 
     * @return The label of the source connector in the flow.
     */
    public final String sourceConnectorLabel() {
        return sourceConnectorLabel;
    }

    /**
     * <p>
     * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationConnectorType} will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType destinationConnectorType() {
        return ConnectorType.fromValue(destinationConnectorType);
    }

    /**
     * <p>
     * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationConnectorType} will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String destinationConnectorTypeAsString() {
        return destinationConnectorType;
    }

    /**
     * <p>
     * The label of the destination connector in the flow.
     * </p>
     * 
     * @return The label of the destination connector in the flow.
     */
    public final String destinationConnectorLabel() {
        return destinationConnectorLabel;
    }

    /**
     * <p>
     * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     * <code>Event</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     *         <code>Event</code>.
     * @see TriggerType
     */
    public final TriggerType triggerType() {
        return TriggerType.fromValue(triggerType);
    }

    /**
     * <p>
     * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     * <code>Event</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     *         <code>Event</code>.
     * @see TriggerType
     */
    public final String triggerTypeAsString() {
        return triggerType;
    }

    /**
     * <p>
     * Specifies when the flow was created.
     * </p>
     * 
     * @return Specifies when the flow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the flow was last updated.
     * </p>
     * 
     * @return Specifies when the flow was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The ARN of the user who created the flow.
     * </p>
     * 
     * @return The ARN of the user who created the flow.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies the account user name that most recently updated the flow.
     * </p>
     * 
     * @return Specifies the account user name that most recently updated the flow.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for your flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for your flow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Describes the details of the most recent flow run.
     * </p>
     * 
     * @return Describes the details of the most recent flow run.
     */
    public final ExecutionDetails lastRunExecutionDetails() {
        return lastRunExecutionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConnectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastRunExecutionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(description(), other.description())
                && Objects.equals(flowName(), other.flowName())
                && Objects.equals(flowStatusAsString(), other.flowStatusAsString())
                && Objects.equals(sourceConnectorTypeAsString(), other.sourceConnectorTypeAsString())
                && Objects.equals(sourceConnectorLabel(), other.sourceConnectorLabel())
                && Objects.equals(destinationConnectorTypeAsString(), other.destinationConnectorTypeAsString())
                && Objects.equals(destinationConnectorLabel(), other.destinationConnectorLabel())
                && Objects.equals(triggerTypeAsString(), other.triggerTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(lastRunExecutionDetails(), other.lastRunExecutionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowDefinition").add("FlowArn", flowArn()).add("Description", description())
                .add("FlowName", flowName()).add("FlowStatus", flowStatusAsString())
                .add("SourceConnectorType", sourceConnectorTypeAsString()).add("SourceConnectorLabel", sourceConnectorLabel())
                .add("DestinationConnectorType", destinationConnectorTypeAsString())
                .add("DestinationConnectorLabel", destinationConnectorLabel()).add("TriggerType", triggerTypeAsString())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("CreatedBy", createdBy())
                .add("LastUpdatedBy", lastUpdatedBy()).add("Tags", hasTags() ? tags() : null)
                .add("LastRunExecutionDetails", lastRunExecutionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "flowStatus":
            return Optional.ofNullable(clazz.cast(flowStatusAsString()));
        case "sourceConnectorType":
            return Optional.ofNullable(clazz.cast(sourceConnectorTypeAsString()));
        case "sourceConnectorLabel":
            return Optional.ofNullable(clazz.cast(sourceConnectorLabel()));
        case "destinationConnectorType":
            return Optional.ofNullable(clazz.cast(destinationConnectorTypeAsString()));
        case "destinationConnectorLabel":
            return Optional.ofNullable(clazz.cast(destinationConnectorLabel()));
        case "triggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "lastRunExecutionDetails":
            return Optional.ofNullable(clazz.cast(lastRunExecutionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowDefinition> {
        /**
         * <p>
         * The flow's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param flowArn
         *        The flow's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * A user-entered description of the flow.
         * </p>
         * 
         * @param description
         *        A user-entered description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(String flowStatus);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(FlowStatus flowStatus);

        /**
         * <p>
         * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * </p>
         * 
         * @param sourceConnectorType
         *        Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder sourceConnectorType(String sourceConnectorType);

        /**
         * <p>
         * Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * </p>
         * 
         * @param sourceConnectorType
         *        Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder sourceConnectorType(ConnectorType sourceConnectorType);

        /**
         * <p>
         * The label of the source connector in the flow.
         * </p>
         * 
         * @param sourceConnectorLabel
         *        The label of the source connector in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConnectorLabel(String sourceConnectorLabel);

        /**
         * <p>
         * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * </p>
         * 
         * @param destinationConnectorType
         *        Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder destinationConnectorType(String destinationConnectorType);

        /**
         * <p>
         * Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * </p>
         * 
         * @param destinationConnectorType
         *        Specifies the destination connector type, such as Salesforce, Amazon S3, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder destinationConnectorType(ConnectorType destinationConnectorType);

        /**
         * <p>
         * The label of the destination connector in the flow.
         * </p>
         * 
         * @param destinationConnectorLabel
         *        The label of the destination connector in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConnectorLabel(String destinationConnectorLabel);

        /**
         * <p>
         * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         * <code>Event</code>.
         * </p>
         * 
         * @param triggerType
         *        Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         *        <code>Event</code>.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * <p>
         * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         * <code>Event</code>.
         * </p>
         * 
         * @param triggerType
         *        Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         *        <code>Event</code>.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(TriggerType triggerType);

        /**
         * <p>
         * Specifies when the flow was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the flow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the flow was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the flow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The ARN of the user who created the flow.
         * </p>
         * 
         * @param createdBy
         *        The ARN of the user who created the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Specifies the account user name that most recently updated the flow.
         * </p>
         * 
         * @param lastUpdatedBy
         *        Specifies the account user name that most recently updated the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The tags used to organize, track, or control access for your flow.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for your flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Describes the details of the most recent flow run.
         * </p>
         * 
         * @param lastRunExecutionDetails
         *        Describes the details of the most recent flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails);

        /**
         * <p>
         * Describes the details of the most recent flow run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionDetails.Builder} avoiding the
         * need to create one manually via {@link ExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRunExecutionDetails(ExecutionDetails)}.
         * 
         * @param lastRunExecutionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunExecutionDetails(ExecutionDetails)
         */
        default Builder lastRunExecutionDetails(Consumer<ExecutionDetails.Builder> lastRunExecutionDetails) {
            return lastRunExecutionDetails(ExecutionDetails.builder().applyMutation(lastRunExecutionDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String description;

        private String flowName;

        private String flowStatus;

        private String sourceConnectorType;

        private String sourceConnectorLabel;

        private String destinationConnectorType;

        private String destinationConnectorLabel;

        private String triggerType;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String createdBy;

        private String lastUpdatedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ExecutionDetails lastRunExecutionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            flowArn(model.flowArn);
            description(model.description);
            flowName(model.flowName);
            flowStatus(model.flowStatus);
            sourceConnectorType(model.sourceConnectorType);
            sourceConnectorLabel(model.sourceConnectorLabel);
            destinationConnectorType(model.destinationConnectorType);
            destinationConnectorLabel(model.destinationConnectorLabel);
            triggerType(model.triggerType);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            createdBy(model.createdBy);
            lastUpdatedBy(model.lastUpdatedBy);
            tags(model.tags);
            lastRunExecutionDetails(model.lastRunExecutionDetails);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getFlowStatus() {
            return flowStatus;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final String getSourceConnectorType() {
            return sourceConnectorType;
        }

        public final void setSourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
        }

        @Override
        public final Builder sourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
            return this;
        }

        @Override
        public final Builder sourceConnectorType(ConnectorType sourceConnectorType) {
            this.sourceConnectorType(sourceConnectorType == null ? null : sourceConnectorType.toString());
            return this;
        }

        public final String getSourceConnectorLabel() {
            return sourceConnectorLabel;
        }

        public final void setSourceConnectorLabel(String sourceConnectorLabel) {
            this.sourceConnectorLabel = sourceConnectorLabel;
        }

        @Override
        public final Builder sourceConnectorLabel(String sourceConnectorLabel) {
            this.sourceConnectorLabel = sourceConnectorLabel;
            return this;
        }

        public final String getDestinationConnectorType() {
            return destinationConnectorType;
        }

        public final void setDestinationConnectorType(String destinationConnectorType) {
            this.destinationConnectorType = destinationConnectorType;
        }

        @Override
        public final Builder destinationConnectorType(String destinationConnectorType) {
            this.destinationConnectorType = destinationConnectorType;
            return this;
        }

        @Override
        public final Builder destinationConnectorType(ConnectorType destinationConnectorType) {
            this.destinationConnectorType(destinationConnectorType == null ? null : destinationConnectorType.toString());
            return this;
        }

        public final String getDestinationConnectorLabel() {
            return destinationConnectorLabel;
        }

        public final void setDestinationConnectorLabel(String destinationConnectorLabel) {
            this.destinationConnectorLabel = destinationConnectorLabel;
        }

        @Override
        public final Builder destinationConnectorLabel(String destinationConnectorLabel) {
            this.destinationConnectorLabel = destinationConnectorLabel;
            return this;
        }

        public final String getTriggerType() {
            return triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExecutionDetails.Builder getLastRunExecutionDetails() {
            return lastRunExecutionDetails != null ? lastRunExecutionDetails.toBuilder() : null;
        }

        public final void setLastRunExecutionDetails(ExecutionDetails.BuilderImpl lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails != null ? lastRunExecutionDetails.build() : null;
        }

        @Override
        public final Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails;
            return this;
        }

        @Override
        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
