/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAutoScalingConfigurationRequest extends AppRunnerRequest implements
        ToCopyableBuilder<DeleteAutoScalingConfigurationRequest.Builder, DeleteAutoScalingConfigurationRequest> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationArn")
            .getter(getter(DeleteAutoScalingConfigurationRequest::autoScalingConfigurationArn))
            .setter(setter(Builder::autoScalingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn")
                    .build()).build();

    private static final SdkField<Boolean> DELETE_ALL_REVISIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAllRevisions").getter(getter(DeleteAutoScalingConfigurationRequest::deleteAllRevisions))
            .setter(setter(Builder::deleteAllRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAllRevisions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_CONFIGURATION_ARN_FIELD, DELETE_ALL_REVISIONS_FIELD));

    private final String autoScalingConfigurationArn;

    private final Boolean deleteAllRevisions;

    private DeleteAutoScalingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.deleteAllRevisions = builder.deleteAllRevisions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.
     * </p>
     * <p>
     * The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either
     * <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn't specified,
     * the latest active revision is deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.</p>
     *         <p>
     *         The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either
     *         <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn't
     *         specified, the latest active revision is deleted.
     */
    public final String autoScalingConfigurationArn() {
        return autoScalingConfigurationArn;
    }

    /**
     * <p>
     * Set to <code>true</code> to delete all of the revisions associated with the
     * <code>AutoScalingConfigurationArn</code> parameter value.
     * </p>
     * <p>
     * When <code>DeleteAllRevisions</code> is set to <code>true</code>, the only valid value for the Amazon Resource
     * Name (ARN) is a partial ARN ending with: <code>.../name</code>.
     * </p>
     * 
     * @return Set to <code>true</code> to delete all of the revisions associated with the
     *         <code>AutoScalingConfigurationArn</code> parameter value.</p>
     *         <p>
     *         When <code>DeleteAllRevisions</code> is set to <code>true</code>, the only valid value for the Amazon
     *         Resource Name (ARN) is a partial ARN ending with: <code>.../name</code>.
     */
    public final Boolean deleteAllRevisions() {
        return deleteAllRevisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAllRevisions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutoScalingConfigurationRequest)) {
            return false;
        }
        DeleteAutoScalingConfigurationRequest other = (DeleteAutoScalingConfigurationRequest) obj;
        return Objects.equals(autoScalingConfigurationArn(), other.autoScalingConfigurationArn())
                && Objects.equals(deleteAllRevisions(), other.deleteAllRevisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAutoScalingConfigurationRequest")
                .add("AutoScalingConfigurationArn", autoScalingConfigurationArn())
                .add("DeleteAllRevisions", deleteAllRevisions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfigurationArn":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationArn()));
        case "DeleteAllRevisions":
            return Optional.ofNullable(clazz.cast(deleteAllRevisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAutoScalingConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteAutoScalingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAutoScalingConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.
         * </p>
         * <p>
         * The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either
         * <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn't
         * specified, the latest active revision is deleted.
         * </p>
         * 
         * @param autoScalingConfigurationArn
         *        The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to
         *        delete.</p>
         *        <p>
         *        The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either
         *        <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn't
         *        specified, the latest active revision is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationArn(String autoScalingConfigurationArn);

        /**
         * <p>
         * Set to <code>true</code> to delete all of the revisions associated with the
         * <code>AutoScalingConfigurationArn</code> parameter value.
         * </p>
         * <p>
         * When <code>DeleteAllRevisions</code> is set to <code>true</code>, the only valid value for the Amazon
         * Resource Name (ARN) is a partial ARN ending with: <code>.../name</code>.
         * </p>
         * 
         * @param deleteAllRevisions
         *        Set to <code>true</code> to delete all of the revisions associated with the
         *        <code>AutoScalingConfigurationArn</code> parameter value.</p>
         *        <p>
         *        When <code>DeleteAllRevisions</code> is set to <code>true</code>, the only valid value for the Amazon
         *        Resource Name (ARN) is a partial ARN ending with: <code>.../name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAllRevisions(Boolean deleteAllRevisions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String autoScalingConfigurationArn;

        private Boolean deleteAllRevisions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutoScalingConfigurationRequest model) {
            super(model);
            autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            deleteAllRevisions(model.deleteAllRevisions);
        }

        public final String getAutoScalingConfigurationArn() {
            return autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final Boolean getDeleteAllRevisions() {
            return deleteAllRevisions;
        }

        public final void setDeleteAllRevisions(Boolean deleteAllRevisions) {
            this.deleteAllRevisions = deleteAllRevisions;
        }

        @Override
        public final Builder deleteAllRevisions(Boolean deleteAllRevisions) {
            this.deleteAllRevisions = deleteAllRevisions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutoScalingConfigurationRequest build() {
            return new DeleteAutoScalingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
