/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an AppSync error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeError implements SdkPojo, Serializable, ToCopyableBuilder<CodeError.Builder, CodeError> {
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(CodeError::errorType)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(CodeError::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<CodeErrorLocation> LOCATION_FIELD = SdkField
            .<CodeErrorLocation> builder(MarshallingType.SDK_POJO).memberName("location").getter(getter(CodeError::location))
            .setter(setter(Builder::location)).constructor(CodeErrorLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_TYPE_FIELD, VALUE_FIELD,
            LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorType;

    private final String value;

    private final CodeErrorLocation location;

    private CodeError(BuilderImpl builder) {
        this.errorType = builder.errorType;
        this.value = builder.value;
        this.location = builder.location;
    }

    /**
     * <p>
     * The type of code error.
     * </p>
     * <p>
     * Examples include, but aren't limited to: <code>LINT_ERROR</code>, <code>PARSER_ERROR</code>.
     * </p>
     * 
     * @return The type of code error. </p>
     *         <p>
     *         Examples include, but aren't limited to: <code>LINT_ERROR</code>, <code>PARSER_ERROR</code>.
     */
    public final String errorType() {
        return errorType;
    }

    /**
     * <p>
     * A user presentable error.
     * </p>
     * <p>
     * Examples include, but aren't limited to: <code>Parsing error: Unterminated string literal</code>.
     * </p>
     * 
     * @return A user presentable error.</p>
     *         <p>
     *         Examples include, but aren't limited to: <code>Parsing error: Unterminated string literal</code>.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The line, column, and span location of the error in the code.
     * </p>
     * 
     * @return The line, column, and span location of the error in the code.
     */
    public final CodeErrorLocation location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorType());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeError)) {
            return false;
        }
        CodeError other = (CodeError) obj;
        return Objects.equals(errorType(), other.errorType()) && Objects.equals(value(), other.value())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeError").add("ErrorType", errorType()).add("Value", value()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorType()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeError, T> g) {
        return obj -> g.apply((CodeError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeError> {
        /**
         * <p>
         * The type of code error.
         * </p>
         * <p>
         * Examples include, but aren't limited to: <code>LINT_ERROR</code>, <code>PARSER_ERROR</code>.
         * </p>
         * 
         * @param errorType
         *        The type of code error. </p>
         *        <p>
         *        Examples include, but aren't limited to: <code>LINT_ERROR</code>, <code>PARSER_ERROR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * A user presentable error.
         * </p>
         * <p>
         * Examples include, but aren't limited to: <code>Parsing error: Unterminated string literal</code>.
         * </p>
         * 
         * @param value
         *        A user presentable error.</p>
         *        <p>
         *        Examples include, but aren't limited to: <code>Parsing error: Unterminated string literal</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The line, column, and span location of the error in the code.
         * </p>
         * 
         * @param location
         *        The line, column, and span location of the error in the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(CodeErrorLocation location);

        /**
         * <p>
         * The line, column, and span location of the error in the code.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeErrorLocation.Builder} avoiding the
         * need to create one manually via {@link CodeErrorLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeErrorLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(CodeErrorLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link CodeErrorLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(CodeErrorLocation)
         */
        default Builder location(Consumer<CodeErrorLocation.Builder> location) {
            return location(CodeErrorLocation.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String errorType;

        private String value;

        private CodeErrorLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeError model) {
            errorType(model.errorType);
            value(model.value);
            location(model.location);
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final CodeErrorLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(CodeErrorLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(CodeErrorLocation location) {
            this.location = location;
            return this;
        }

        @Override
        public CodeError build() {
            return new CodeError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
