/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DataSourceIntrospectionResult</code>. This is the populated result of a
 * <code>GetDataSourceIntrospection</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceIntrospectionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceIntrospectionResult.Builder, DataSourceIntrospectionResult> {
    private static final SdkField<List<DataSourceIntrospectionModel>> MODELS_FIELD = SdkField
            .<List<DataSourceIntrospectionModel>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(DataSourceIntrospectionResult::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceIntrospectionModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceIntrospectionModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DataSourceIntrospectionResult::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MODELS_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataSourceIntrospectionModel> models;

    private final String nextToken;

    private DataSourceIntrospectionResult(BuilderImpl builder) {
        this.models = builder.models;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <code>DataSourceIntrospectionModel</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return The array of <code>DataSourceIntrospectionModel</code> objects.
     */
    public final List<DataSourceIntrospectionModel> models() {
        return models;
    }

    /**
     * <p>
     * Determines the number of types to be returned in a single response before paginating. This value is typically
     * taken from <code>nextToken</code> value from the previous response.
     * </p>
     * 
     * @return Determines the number of types to be returned in a single response before paginating. This value is
     *         typically taken from <code>nextToken</code> value from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionResult)) {
            return false;
        }
        DataSourceIntrospectionResult other = (DataSourceIntrospectionResult) obj;
        return hasModels() == other.hasModels() && Objects.equals(models(), other.models())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceIntrospectionResult").add("Models", hasModels() ? models() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionResult, T> g) {
        return obj -> g.apply((DataSourceIntrospectionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceIntrospectionResult> {
        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModel</code> objects.
         * </p>
         * 
         * @param models
         *        The array of <code>DataSourceIntrospectionModel</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<DataSourceIntrospectionModel> models);

        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModel</code> objects.
         * </p>
         * 
         * @param models
         *        The array of <code>DataSourceIntrospectionModel</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(DataSourceIntrospectionModel... models);

        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModel</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModel.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<DataSourceIntrospectionModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<DataSourceIntrospectionModel>)
         */
        Builder models(Consumer<DataSourceIntrospectionModel.Builder>... models);

        /**
         * <p>
         * Determines the number of types to be returned in a single response before paginating. This value is typically
         * taken from <code>nextToken</code> value from the previous response.
         * </p>
         * 
         * @param nextToken
         *        Determines the number of types to be returned in a single response before paginating. This value is
         *        typically taken from <code>nextToken</code> value from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<DataSourceIntrospectionModel> models = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionResult model) {
            models(model.models);
            nextToken(model.nextToken);
        }

        public final List<DataSourceIntrospectionModel.Builder> getModels() {
            List<DataSourceIntrospectionModel.Builder> result = DataSourceIntrospectionModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<DataSourceIntrospectionModel.BuilderImpl> models) {
            this.models = DataSourceIntrospectionModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<DataSourceIntrospectionModel> models) {
            this.models = DataSourceIntrospectionModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(DataSourceIntrospectionModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<DataSourceIntrospectionModel.Builder>... models) {
            models(Stream.of(models).map(c -> DataSourceIntrospectionModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DataSourceIntrospectionResult build() {
            return new DataSourceIntrospectionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
