/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.Step;
import software.amazon.awssdk.services.apptest.model.StepListCopier;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTestCaseRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, CreateTestCaseRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTestCaseRequest.getter(CreateTestCaseRequest::name)).setter(CreateTestCaseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateTestCaseRequest.getter(CreateTestCaseRequest::description)).setter(CreateTestCaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(CreateTestCaseRequest.getter(CreateTestCaseRequest::steps)).setter(CreateTestCaseRequest.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTestCaseRequest.getter(CreateTestCaseRequest::clientToken)).setter(CreateTestCaseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateTestCaseRequest.getter(CreateTestCaseRequest::tags)).setter(CreateTestCaseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, STEPS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final List<Step> steps;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.steps = builder.steps;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<Step> steps() {
        return this.steps;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestCaseRequest)) {
            return false;
        }
        CreateTestCaseRequest other = (CreateTestCaseRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTestCaseRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Steps", this.hasSteps() ? this.steps() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTestCaseRequest, T> g) {
        return obj -> g.apply((CreateTestCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestCaseRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.steps(model.steps);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTestCaseRequest build() {
            return new CreateTestCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTestCaseRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

