/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A breakdown of the latest compliance check status for the evidence in your Audit Manager assessments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvidenceInsights implements SdkPojo, Serializable,
        ToCopyableBuilder<EvidenceInsights.Builder, EvidenceInsights> {
    private static final SdkField<Integer> NONCOMPLIANT_EVIDENCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("noncompliantEvidenceCount")
            .getter(getter(EvidenceInsights::noncompliantEvidenceCount)).setter(setter(Builder::noncompliantEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noncompliantEvidenceCount").build())
            .build();

    private static final SdkField<Integer> COMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("compliantEvidenceCount").getter(getter(EvidenceInsights::compliantEvidenceCount))
            .setter(setter(Builder::compliantEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantEvidenceCount").build())
            .build();

    private static final SdkField<Integer> INCONCLUSIVE_EVIDENCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("inconclusiveEvidenceCount")
            .getter(getter(EvidenceInsights::inconclusiveEvidenceCount)).setter(setter(Builder::inconclusiveEvidenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inconclusiveEvidenceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NONCOMPLIANT_EVIDENCE_COUNT_FIELD, COMPLIANT_EVIDENCE_COUNT_FIELD, INCONCLUSIVE_EVIDENCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer noncompliantEvidenceCount;

    private final Integer compliantEvidenceCount;

    private final Integer inconclusiveEvidenceCount;

    private EvidenceInsights(BuilderImpl builder) {
        this.noncompliantEvidenceCount = builder.noncompliantEvidenceCount;
        this.compliantEvidenceCount = builder.compliantEvidenceCount;
        this.inconclusiveEvidenceCount = builder.inconclusiveEvidenceCount;
    }

    /**
     * <p>
     * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes evidence
     * that was collected from Security Hub with a <i>Fail</i> ruling, or collected from Config with a
     * <i>Non-compliant</i> ruling.
     * </p>
     * 
     * @return The number of compliance check evidence that Audit Manager classified as non-compliant. This includes
     *         evidence that was collected from Security Hub with a <i>Fail</i> ruling, or collected from Config with a
     *         <i>Non-compliant</i> ruling.
     */
    public final Integer noncompliantEvidenceCount() {
        return noncompliantEvidenceCount;
    }

    /**
     * <p>
     * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence that
     * was collected from Security Hub with a <i>Pass</i> ruling, or collected from Config with a <i>Compliant</i>
     * ruling.
     * </p>
     * 
     * @return The number of compliance check evidence that Audit Manager classified as compliant. This includes
     *         evidence that was collected from Security Hub with a <i>Pass</i> ruling, or collected from Config with a
     *         <i>Compliant</i> ruling.
     */
    public final Integer compliantEvidenceCount() {
        return compliantEvidenceCount;
    }

    /**
     * <p>
     * The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive when the
     * associated control uses Security Hub or Config as a data source but you didn't enable those services. This is
     * also the case when a control uses a data source that doesn’t support compliance checks (for example, manual
     * evidence, API calls, or CloudTrail).
     * </p>
     * <note>
     * <p>
     * If evidence has a compliance check status of <i>not applicable</i> in the console, it's classified as
     * <i>inconclusive</i> in <code>EvidenceInsights</code> data.
     * </p>
     * </note>
     * 
     * @return The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive when
     *         the associated control uses Security Hub or Config as a data source but you didn't enable those services.
     *         This is also the case when a control uses a data source that doesn’t support compliance checks (for
     *         example, manual evidence, API calls, or CloudTrail). </p> <note>
     *         <p>
     *         If evidence has a compliance check status of <i>not applicable</i> in the console, it's classified as
     *         <i>inconclusive</i> in <code>EvidenceInsights</code> data.
     *         </p>
     */
    public final Integer inconclusiveEvidenceCount() {
        return inconclusiveEvidenceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noncompliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(compliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(inconclusiveEvidenceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvidenceInsights)) {
            return false;
        }
        EvidenceInsights other = (EvidenceInsights) obj;
        return Objects.equals(noncompliantEvidenceCount(), other.noncompliantEvidenceCount())
                && Objects.equals(compliantEvidenceCount(), other.compliantEvidenceCount())
                && Objects.equals(inconclusiveEvidenceCount(), other.inconclusiveEvidenceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvidenceInsights").add("NoncompliantEvidenceCount", noncompliantEvidenceCount())
                .add("CompliantEvidenceCount", compliantEvidenceCount())
                .add("InconclusiveEvidenceCount", inconclusiveEvidenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noncompliantEvidenceCount":
            return Optional.ofNullable(clazz.cast(noncompliantEvidenceCount()));
        case "compliantEvidenceCount":
            return Optional.ofNullable(clazz.cast(compliantEvidenceCount()));
        case "inconclusiveEvidenceCount":
            return Optional.ofNullable(clazz.cast(inconclusiveEvidenceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvidenceInsights, T> g) {
        return obj -> g.apply((EvidenceInsights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvidenceInsights> {
        /**
         * <p>
         * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes
         * evidence that was collected from Security Hub with a <i>Fail</i> ruling, or collected from Config with a
         * <i>Non-compliant</i> ruling.
         * </p>
         * 
         * @param noncompliantEvidenceCount
         *        The number of compliance check evidence that Audit Manager classified as non-compliant. This includes
         *        evidence that was collected from Security Hub with a <i>Fail</i> ruling, or collected from Config with
         *        a <i>Non-compliant</i> ruling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount);

        /**
         * <p>
         * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence
         * that was collected from Security Hub with a <i>Pass</i> ruling, or collected from Config with a
         * <i>Compliant</i> ruling.
         * </p>
         * 
         * @param compliantEvidenceCount
         *        The number of compliance check evidence that Audit Manager classified as compliant. This includes
         *        evidence that was collected from Security Hub with a <i>Pass</i> ruling, or collected from Config with
         *        a <i>Compliant</i> ruling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantEvidenceCount(Integer compliantEvidenceCount);

        /**
         * <p>
         * The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive when the
         * associated control uses Security Hub or Config as a data source but you didn't enable those services. This is
         * also the case when a control uses a data source that doesn’t support compliance checks (for example, manual
         * evidence, API calls, or CloudTrail).
         * </p>
         * <note>
         * <p>
         * If evidence has a compliance check status of <i>not applicable</i> in the console, it's classified as
         * <i>inconclusive</i> in <code>EvidenceInsights</code> data.
         * </p>
         * </note>
         * 
         * @param inconclusiveEvidenceCount
         *        The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive
         *        when the associated control uses Security Hub or Config as a data source but you didn't enable those
         *        services. This is also the case when a control uses a data source that doesn’t support compliance
         *        checks (for example, manual evidence, API calls, or CloudTrail). </p> <note>
         *        <p>
         *        If evidence has a compliance check status of <i>not applicable</i> in the console, it's classified as
         *        <i>inconclusive</i> in <code>EvidenceInsights</code> data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer noncompliantEvidenceCount;

        private Integer compliantEvidenceCount;

        private Integer inconclusiveEvidenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EvidenceInsights model) {
            noncompliantEvidenceCount(model.noncompliantEvidenceCount);
            compliantEvidenceCount(model.compliantEvidenceCount);
            inconclusiveEvidenceCount(model.inconclusiveEvidenceCount);
        }

        public final Integer getNoncompliantEvidenceCount() {
            return noncompliantEvidenceCount;
        }

        public final void setNoncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
        }

        @Override
        public final Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
            return this;
        }

        public final Integer getCompliantEvidenceCount() {
            return compliantEvidenceCount;
        }

        public final void setCompliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
        }

        @Override
        public final Builder compliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
            return this;
        }

        public final Integer getInconclusiveEvidenceCount() {
            return inconclusiveEvidenceCount;
        }

        public final void setInconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
        }

        @Override
        public final Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
            return this;
        }

        @Override
        public EvidenceInsights build() {
            return new EvidenceInsights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
