/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssessmentReportUrlResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetAssessmentReportUrlResponse.Builder, GetAssessmentReportUrlResponse> {
    private static final SdkField<URL> PRE_SIGNED_URL_FIELD = SdkField.<URL> builder(MarshallingType.SDK_POJO)
            .memberName("preSignedUrl").getter(getter(GetAssessmentReportUrlResponse::preSignedUrl))
            .setter(setter(Builder::preSignedUrl)).constructor(URL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preSignedUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_SIGNED_URL_FIELD));

    private final URL preSignedUrl;

    private GetAssessmentReportUrlResponse(BuilderImpl builder) {
        super(builder);
        this.preSignedUrl = builder.preSignedUrl;
    }

    /**
     * Returns the value of the PreSignedUrl property for this object.
     * 
     * @return The value of the PreSignedUrl property for this object.
     */
    public final URL preSignedUrl() {
        return preSignedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentReportUrlResponse)) {
            return false;
        }
        GetAssessmentReportUrlResponse other = (GetAssessmentReportUrlResponse) obj;
        return Objects.equals(preSignedUrl(), other.preSignedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssessmentReportUrlResponse").add("PreSignedUrl", preSignedUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "preSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentReportUrlResponse, T> g) {
        return obj -> g.apply((GetAssessmentReportUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssessmentReportUrlResponse> {
        /**
         * Sets the value of the PreSignedUrl property for this object.
         *
         * @param preSignedUrl
         *        The new value for the PreSignedUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(URL preSignedUrl);

        /**
         * Sets the value of the PreSignedUrl property for this object.
         *
         * This is a convenience method that creates an instance of the {@link URL.Builder} avoiding the need to create
         * one manually via {@link URL#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link URL.Builder#build()} is called immediately and its result is
         * passed to {@link #preSignedUrl(URL)}.
         * 
         * @param preSignedUrl
         *        a consumer that will call methods on {@link URL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preSignedUrl(URL)
         */
        default Builder preSignedUrl(Consumer<URL.Builder> preSignedUrl) {
            return preSignedUrl(URL.builder().applyMutation(preSignedUrl).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private URL preSignedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentReportUrlResponse model) {
            super(model);
            preSignedUrl(model.preSignedUrl);
        }

        public final URL.Builder getPreSignedUrl() {
            return preSignedUrl != null ? preSignedUrl.toBuilder() : null;
        }

        public final void setPreSignedUrl(URL.BuilderImpl preSignedUrl) {
            this.preSignedUrl = preSignedUrl != null ? preSignedUrl.build() : null;
        }

        @Override
        public final Builder preSignedUrl(URL preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        @Override
        public GetAssessmentReportUrlResponse build() {
            return new GetAssessmentReportUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
