/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceErrorsCopier;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.EvidenceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateAssessmentReportEvidenceResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, BatchAssociateAssessmentReportEvidenceResponse> {
    private static final SdkField<List<String>> EVIDENCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidenceIds").getter(BatchAssociateAssessmentReportEvidenceResponse.getter(BatchAssociateAssessmentReportEvidenceResponse::evidenceIds)).setter(BatchAssociateAssessmentReportEvidenceResponse.setter(Builder::evidenceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssessmentReportEvidenceError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchAssociateAssessmentReportEvidenceResponse.getter(BatchAssociateAssessmentReportEvidenceResponse::errors)).setter(BatchAssociateAssessmentReportEvidenceResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentReportEvidenceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_IDS_FIELD, ERRORS_FIELD));
    private final List<String> evidenceIds;
    private final List<AssessmentReportEvidenceError> errors;

    private BatchAssociateAssessmentReportEvidenceResponse(BuilderImpl builder) {
        super(builder);
        this.evidenceIds = builder.evidenceIds;
        this.errors = builder.errors;
    }

    public final boolean hasEvidenceIds() {
        return this.evidenceIds != null && !(this.evidenceIds instanceof SdkAutoConstructList);
    }

    public final List<String> evidenceIds() {
        return this.evidenceIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AssessmentReportEvidenceError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidenceIds() ? this.evidenceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAssessmentReportEvidenceResponse)) {
            return false;
        }
        BatchAssociateAssessmentReportEvidenceResponse other = (BatchAssociateAssessmentReportEvidenceResponse)((Object)obj);
        return this.hasEvidenceIds() == other.hasEvidenceIds() && Objects.equals(this.evidenceIds(), other.evidenceIds()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateAssessmentReportEvidenceResponse").add("EvidenceIds", this.hasEvidenceIds() ? this.evidenceIds() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evidenceIds": {
                return Optional.ofNullable(clazz.cast(this.evidenceIds()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAssessmentReportEvidenceResponse, T> g) {
        return obj -> g.apply((BatchAssociateAssessmentReportEvidenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<String> evidenceIds = DefaultSdkAutoConstructList.getInstance();
        private List<AssessmentReportEvidenceError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAssessmentReportEvidenceResponse model) {
            super(model);
            this.evidenceIds(model.evidenceIds);
            this.errors(model.errors);
        }

        public final Collection<String> getEvidenceIds() {
            if (this.evidenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evidenceIds;
        }

        public final void setEvidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
        }

        @Override
        public final Builder evidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceIds(String ... evidenceIds) {
            this.evidenceIds(Arrays.asList(evidenceIds));
            return this;
        }

        public final List<AssessmentReportEvidenceError.Builder> getErrors() {
            List<AssessmentReportEvidenceError.Builder> result = AssessmentReportEvidenceErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AssessmentReportEvidenceError.BuilderImpl> errors) {
            this.errors = AssessmentReportEvidenceErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AssessmentReportEvidenceError> errors) {
            this.errors = AssessmentReportEvidenceErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssessmentReportEvidenceError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssessmentReportEvidenceError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AssessmentReportEvidenceError)((AssessmentReportEvidenceError.Builder)AssessmentReportEvidenceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateAssessmentReportEvidenceResponse build() {
            return new BatchAssociateAssessmentReportEvidenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateAssessmentReportEvidenceResponse> {
        public Builder evidenceIds(Collection<String> var1);

        public Builder evidenceIds(String ... var1);

        public Builder errors(Collection<AssessmentReportEvidenceError> var1);

        public Builder errors(AssessmentReportEvidenceError ... var1);

        public Builder errors(Consumer<AssessmentReportEvidenceError.Builder> ... var1);
    }
}

