/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.SourceFrequency;
import software.amazon.awssdk.services.auditmanager.model.SourceKeyword;
import software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption;
import software.amazon.awssdk.services.auditmanager.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateControlMappingSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateControlMappingSource> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceName)).setter(CreateControlMappingSource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<String> SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceDescription").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceDescription)).setter(CreateControlMappingSource.setter(Builder::sourceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDescription").build()}).build();
    private static final SdkField<String> SOURCE_SET_UP_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSetUpOption").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceSetUpOptionAsString)).setter(CreateControlMappingSource.setter(Builder::sourceSetUpOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSetUpOption").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceTypeAsString)).setter(CreateControlMappingSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<SourceKeyword> SOURCE_KEYWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceKeyword").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceKeyword)).setter(CreateControlMappingSource.setter(Builder::sourceKeyword)).constructor(SourceKeyword::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKeyword").build()}).build();
    private static final SdkField<String> SOURCE_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFrequency").getter(CreateControlMappingSource.getter(CreateControlMappingSource::sourceFrequencyAsString)).setter(CreateControlMappingSource.setter(Builder::sourceFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFrequency").build()}).build();
    private static final SdkField<String> TROUBLESHOOTING_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("troubleshootingText").getter(CreateControlMappingSource.getter(CreateControlMappingSource::troubleshootingText)).setter(CreateControlMappingSource.setter(Builder::troubleshootingText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("troubleshootingText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD, SOURCE_DESCRIPTION_FIELD, SOURCE_SET_UP_OPTION_FIELD, SOURCE_TYPE_FIELD, SOURCE_KEYWORD_FIELD, SOURCE_FREQUENCY_FIELD, TROUBLESHOOTING_TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceName;
    private final String sourceDescription;
    private final String sourceSetUpOption;
    private final String sourceType;
    private final SourceKeyword sourceKeyword;
    private final String sourceFrequency;
    private final String troubleshootingText;

    private CreateControlMappingSource(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceDescription = builder.sourceDescription;
        this.sourceSetUpOption = builder.sourceSetUpOption;
        this.sourceType = builder.sourceType;
        this.sourceKeyword = builder.sourceKeyword;
        this.sourceFrequency = builder.sourceFrequency;
        this.troubleshootingText = builder.troubleshootingText;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final String sourceDescription() {
        return this.sourceDescription;
    }

    public final SourceSetUpOption sourceSetUpOption() {
        return SourceSetUpOption.fromValue(this.sourceSetUpOption);
    }

    public final String sourceSetUpOptionAsString() {
        return this.sourceSetUpOption;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final SourceKeyword sourceKeyword() {
        return this.sourceKeyword;
    }

    public final SourceFrequency sourceFrequency() {
        return SourceFrequency.fromValue(this.sourceFrequency);
    }

    public final String sourceFrequencyAsString() {
        return this.sourceFrequency;
    }

    public final String troubleshootingText() {
        return this.troubleshootingText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSetUpOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyword());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.troubleshootingText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlMappingSource)) {
            return false;
        }
        CreateControlMappingSource other = (CreateControlMappingSource)obj;
        return Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceDescription(), other.sourceDescription()) && Objects.equals(this.sourceSetUpOptionAsString(), other.sourceSetUpOptionAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceKeyword(), other.sourceKeyword()) && Objects.equals(this.sourceFrequencyAsString(), other.sourceFrequencyAsString()) && Objects.equals(this.troubleshootingText(), other.troubleshootingText());
    }

    public final String toString() {
        return ToString.builder((String)"CreateControlMappingSource").add("SourceName", (Object)this.sourceName()).add("SourceDescription", (Object)this.sourceDescription()).add("SourceSetUpOption", (Object)this.sourceSetUpOptionAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("SourceKeyword", (Object)this.sourceKeyword()).add("SourceFrequency", (Object)this.sourceFrequencyAsString()).add("TroubleshootingText", (Object)(this.troubleshootingText() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "sourceDescription": {
                return Optional.ofNullable(clazz.cast(this.sourceDescription()));
            }
            case "sourceSetUpOption": {
                return Optional.ofNullable(clazz.cast(this.sourceSetUpOptionAsString()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceKeyword": {
                return Optional.ofNullable(clazz.cast(this.sourceKeyword()));
            }
            case "sourceFrequency": {
                return Optional.ofNullable(clazz.cast(this.sourceFrequencyAsString()));
            }
            case "troubleshootingText": {
                return Optional.ofNullable(clazz.cast(this.troubleshootingText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlMappingSource, T> g) {
        return obj -> g.apply((CreateControlMappingSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceName;
        private String sourceDescription;
        private String sourceSetUpOption;
        private String sourceType;
        private SourceKeyword sourceKeyword;
        private String sourceFrequency;
        private String troubleshootingText;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlMappingSource model) {
            this.sourceName(model.sourceName);
            this.sourceDescription(model.sourceDescription);
            this.sourceSetUpOption(model.sourceSetUpOption);
            this.sourceType(model.sourceType);
            this.sourceKeyword(model.sourceKeyword);
            this.sourceFrequency(model.sourceFrequency);
            this.troubleshootingText(model.troubleshootingText);
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceDescription() {
            return this.sourceDescription;
        }

        public final void setSourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
        }

        @Override
        public final Builder sourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
            return this;
        }

        public final String getSourceSetUpOption() {
            return this.sourceSetUpOption;
        }

        public final void setSourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
        }

        @Override
        public final Builder sourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
            return this;
        }

        @Override
        public final Builder sourceSetUpOption(SourceSetUpOption sourceSetUpOption) {
            this.sourceSetUpOption(sourceSetUpOption == null ? null : sourceSetUpOption.toString());
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final SourceKeyword.Builder getSourceKeyword() {
            return this.sourceKeyword != null ? this.sourceKeyword.toBuilder() : null;
        }

        public final void setSourceKeyword(SourceKeyword.BuilderImpl sourceKeyword) {
            this.sourceKeyword = sourceKeyword != null ? sourceKeyword.build() : null;
        }

        @Override
        public final Builder sourceKeyword(SourceKeyword sourceKeyword) {
            this.sourceKeyword = sourceKeyword;
            return this;
        }

        public final String getSourceFrequency() {
            return this.sourceFrequency;
        }

        public final void setSourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
        }

        @Override
        public final Builder sourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
            return this;
        }

        @Override
        public final Builder sourceFrequency(SourceFrequency sourceFrequency) {
            this.sourceFrequency(sourceFrequency == null ? null : sourceFrequency.toString());
            return this;
        }

        public final String getTroubleshootingText() {
            return this.troubleshootingText;
        }

        public final void setTroubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
        }

        @Override
        public final Builder troubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
            return this;
        }

        public CreateControlMappingSource build() {
            return new CreateControlMappingSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateControlMappingSource> {
        public Builder sourceName(String var1);

        public Builder sourceDescription(String var1);

        public Builder sourceSetUpOption(String var1);

        public Builder sourceSetUpOption(SourceSetUpOption var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceKeyword(SourceKeyword var1);

        default public Builder sourceKeyword(Consumer<SourceKeyword.Builder> sourceKeyword) {
            return this.sourceKeyword((SourceKeyword)((SourceKeyword.Builder)SourceKeyword.builder().applyMutation(sourceKeyword)).build());
        }

        public Builder sourceFrequency(String var1);

        public Builder sourceFrequency(SourceFrequency var1);

        public Builder troubleshootingText(String var1);
    }
}

