/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.DeploymentCreator;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOverview;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatusMessageListCopier;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.ErrorInformation;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.RelatedDeployments;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RollbackInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentInfo> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(DeploymentInfo.getter(DeploymentInfo::applicationName)).setter(DeploymentInfo.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentGroupName").getter(DeploymentInfo.getter(DeploymentInfo::deploymentGroupName)).setter(DeploymentInfo.setter(Builder::deploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigName").getter(DeploymentInfo.getter(DeploymentInfo::deploymentConfigName)).setter(DeploymentInfo.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(DeploymentInfo.getter(DeploymentInfo::deploymentId)).setter(DeploymentInfo.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<RevisionLocation> PREVIOUS_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("previousRevision").getter(DeploymentInfo.getter(DeploymentInfo::previousRevision)).setter(DeploymentInfo.setter(Builder::previousRevision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousRevision").build()}).build();
    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("revision").getter(DeploymentInfo.getter(DeploymentInfo::revision)).setter(DeploymentInfo.setter(Builder::revision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeploymentInfo.getter(DeploymentInfo::statusAsString)).setter(DeploymentInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorInformation> ERROR_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInformation").getter(DeploymentInfo.getter(DeploymentInfo::errorInformation)).setter(DeploymentInfo.setter(Builder::errorInformation)).constructor(ErrorInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInformation").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(DeploymentInfo.getter(DeploymentInfo::createTime)).setter(DeploymentInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DeploymentInfo.getter(DeploymentInfo::startTime)).setter(DeploymentInfo.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completeTime").getter(DeploymentInfo.getter(DeploymentInfo::completeTime)).setter(DeploymentInfo.setter(Builder::completeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completeTime").build()}).build();
    private static final SdkField<DeploymentOverview> DEPLOYMENT_OVERVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentOverview").getter(DeploymentInfo.getter(DeploymentInfo::deploymentOverview)).setter(DeploymentInfo.setter(Builder::deploymentOverview)).constructor(DeploymentOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOverview").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DeploymentInfo.getter(DeploymentInfo::description)).setter(DeploymentInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CREATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creator").getter(DeploymentInfo.getter(DeploymentInfo::creatorAsString)).setter(DeploymentInfo.setter(Builder::creator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creator").build()}).build();
    private static final SdkField<Boolean> IGNORE_APPLICATION_STOP_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ignoreApplicationStopFailures").getter(DeploymentInfo.getter(DeploymentInfo::ignoreApplicationStopFailures)).setter(DeploymentInfo.setter(Builder::ignoreApplicationStopFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreApplicationStopFailures").build()}).build();
    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration").getter(DeploymentInfo.getter(DeploymentInfo::autoRollbackConfiguration)).setter(DeploymentInfo.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build()}).build();
    private static final SdkField<Boolean> UPDATE_OUTDATED_INSTANCES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("updateOutdatedInstancesOnly").getter(DeploymentInfo.getter(DeploymentInfo::updateOutdatedInstancesOnly)).setter(DeploymentInfo.setter(Builder::updateOutdatedInstancesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateOutdatedInstancesOnly").build()}).build();
    private static final SdkField<RollbackInfo> ROLLBACK_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rollbackInfo").getter(DeploymentInfo.getter(DeploymentInfo::rollbackInfo)).setter(DeploymentInfo.setter(Builder::rollbackInfo)).constructor(RollbackInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackInfo").build()}).build();
    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentStyle").getter(DeploymentInfo.getter(DeploymentInfo::deploymentStyle)).setter(DeploymentInfo.setter(Builder::deploymentStyle)).constructor(DeploymentStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()}).build();
    private static final SdkField<TargetInstances> TARGET_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetInstances").getter(DeploymentInfo.getter(DeploymentInfo::targetInstances)).setter(DeploymentInfo.setter(Builder::targetInstances)).constructor(TargetInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstances").build()}).build();
    private static final SdkField<Boolean> INSTANCE_TERMINATION_WAIT_TIME_STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("instanceTerminationWaitTimeStarted").getter(DeploymentInfo.getter(DeploymentInfo::instanceTerminationWaitTimeStarted)).setter(DeploymentInfo.setter(Builder::instanceTerminationWaitTimeStarted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTerminationWaitTimeStarted").build()}).build();
    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blueGreenDeploymentConfiguration").getter(DeploymentInfo.getter(DeploymentInfo::blueGreenDeploymentConfiguration)).setter(DeploymentInfo.setter(Builder::blueGreenDeploymentConfiguration)).constructor(BlueGreenDeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration").build()}).build();
    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loadBalancerInfo").getter(DeploymentInfo.getter(DeploymentInfo::loadBalancerInfo)).setter(DeploymentInfo.setter(Builder::loadBalancerInfo)).constructor(LoadBalancerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()}).build();
    private static final SdkField<String> ADDITIONAL_DEPLOYMENT_STATUS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalDeploymentStatusInfo").getter(DeploymentInfo.getter(DeploymentInfo::additionalDeploymentStatusInfo)).setter(DeploymentInfo.setter(Builder::additionalDeploymentStatusInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalDeploymentStatusInfo").build()}).build();
    private static final SdkField<String> FILE_EXISTS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileExistsBehavior").getter(DeploymentInfo.getter(DeploymentInfo::fileExistsBehaviorAsString)).setter(DeploymentInfo.setter(Builder::fileExistsBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExistsBehavior").build()}).build();
    private static final SdkField<List<String>> DEPLOYMENT_STATUS_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentStatusMessages").getter(DeploymentInfo.getter(DeploymentInfo::deploymentStatusMessages)).setter(DeploymentInfo.setter(Builder::deploymentStatusMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computePlatform").getter(DeploymentInfo.getter(DeploymentInfo::computePlatformAsString)).setter(DeploymentInfo.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(DeploymentInfo.getter(DeploymentInfo::externalId)).setter(DeploymentInfo.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<RelatedDeployments> RELATED_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relatedDeployments").getter(DeploymentInfo.getter(DeploymentInfo::relatedDeployments)).setter(DeploymentInfo.setter(Builder::relatedDeployments)).constructor(RelatedDeployments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedDeployments").build()}).build();
    private static final SdkField<AlarmConfiguration> OVERRIDE_ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrideAlarmConfiguration").getter(DeploymentInfo.getter(DeploymentInfo::overrideAlarmConfiguration)).setter(DeploymentInfo.setter(Builder::overrideAlarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideAlarmConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, DEPLOYMENT_ID_FIELD, PREVIOUS_REVISION_FIELD, REVISION_FIELD, STATUS_FIELD, ERROR_INFORMATION_FIELD, CREATE_TIME_FIELD, START_TIME_FIELD, COMPLETE_TIME_FIELD, DEPLOYMENT_OVERVIEW_FIELD, DESCRIPTION_FIELD, CREATOR_FIELD, IGNORE_APPLICATION_STOP_FAILURES_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, UPDATE_OUTDATED_INSTANCES_ONLY_FIELD, ROLLBACK_INFO_FIELD, DEPLOYMENT_STYLE_FIELD, TARGET_INSTANCES_FIELD, INSTANCE_TERMINATION_WAIT_TIME_STARTED_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD, ADDITIONAL_DEPLOYMENT_STATUS_INFO_FIELD, FILE_EXISTS_BEHAVIOR_FIELD, DEPLOYMENT_STATUS_MESSAGES_FIELD, COMPUTE_PLATFORM_FIELD, EXTERNAL_ID_FIELD, RELATED_DEPLOYMENTS_FIELD, OVERRIDE_ALARM_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final String deploymentId;
    private final RevisionLocation previousRevision;
    private final RevisionLocation revision;
    private final String status;
    private final ErrorInformation errorInformation;
    private final Instant createTime;
    private final Instant startTime;
    private final Instant completeTime;
    private final DeploymentOverview deploymentOverview;
    private final String description;
    private final String creator;
    private final Boolean ignoreApplicationStopFailures;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final RollbackInfo rollbackInfo;
    private final DeploymentStyle deploymentStyle;
    private final TargetInstances targetInstances;
    private final Boolean instanceTerminationWaitTimeStarted;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final String additionalDeploymentStatusInfo;
    private final String fileExistsBehavior;
    private final List<String> deploymentStatusMessages;
    private final String computePlatform;
    private final String externalId;
    private final RelatedDeployments relatedDeployments;
    private final AlarmConfiguration overrideAlarmConfiguration;

    private DeploymentInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.deploymentId = builder.deploymentId;
        this.previousRevision = builder.previousRevision;
        this.revision = builder.revision;
        this.status = builder.status;
        this.errorInformation = builder.errorInformation;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.deploymentOverview = builder.deploymentOverview;
        this.description = builder.description;
        this.creator = builder.creator;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.rollbackInfo = builder.rollbackInfo;
        this.deploymentStyle = builder.deploymentStyle;
        this.targetInstances = builder.targetInstances;
        this.instanceTerminationWaitTimeStarted = builder.instanceTerminationWaitTimeStarted;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.additionalDeploymentStatusInfo = builder.additionalDeploymentStatusInfo;
        this.fileExistsBehavior = builder.fileExistsBehavior;
        this.deploymentStatusMessages = builder.deploymentStatusMessages;
        this.computePlatform = builder.computePlatform;
        this.externalId = builder.externalId;
        this.relatedDeployments = builder.relatedDeployments;
        this.overrideAlarmConfiguration = builder.overrideAlarmConfiguration;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public final String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final RevisionLocation previousRevision() {
        return this.previousRevision;
    }

    public final RevisionLocation revision() {
        return this.revision;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorInformation errorInformation() {
        return this.errorInformation;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant completeTime() {
        return this.completeTime;
    }

    public final DeploymentOverview deploymentOverview() {
        return this.deploymentOverview;
    }

    public final String description() {
        return this.description;
    }

    public final DeploymentCreator creator() {
        return DeploymentCreator.fromValue(this.creator);
    }

    public final String creatorAsString() {
        return this.creator;
    }

    public final Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public final Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public final RollbackInfo rollbackInfo() {
        return this.rollbackInfo;
    }

    public final DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public final TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public final Boolean instanceTerminationWaitTimeStarted() {
        return this.instanceTerminationWaitTimeStarted;
    }

    public final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public final LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public final String additionalDeploymentStatusInfo() {
        return this.additionalDeploymentStatusInfo;
    }

    public final FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(this.fileExistsBehavior);
    }

    public final String fileExistsBehaviorAsString() {
        return this.fileExistsBehavior;
    }

    public final boolean hasDeploymentStatusMessages() {
        return this.deploymentStatusMessages != null && !(this.deploymentStatusMessages instanceof SdkAutoConstructList);
    }

    public final List<String> deploymentStatusMessages() {
        return this.deploymentStatusMessages;
    }

    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public final String computePlatformAsString() {
        return this.computePlatform;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final RelatedDeployments relatedDeployments() {
        return this.relatedDeployments;
    }

    public final AlarmConfiguration overrideAlarmConfiguration() {
        return this.overrideAlarmConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOverview());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTerminationWaitTimeStarted());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDeploymentStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExistsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentStatusMessages() ? this.deploymentStatusMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedDeployments());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideAlarmConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.previousRevision(), other.previousRevision()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorInformation(), other.errorInformation()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completeTime(), other.completeTime()) && Objects.equals(this.deploymentOverview(), other.deploymentOverview()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creatorAsString(), other.creatorAsString()) && Objects.equals(this.ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly()) && Objects.equals(this.rollbackInfo(), other.rollbackInfo()) && Objects.equals(this.deploymentStyle(), other.deploymentStyle()) && Objects.equals(this.targetInstances(), other.targetInstances()) && Objects.equals(this.instanceTerminationWaitTimeStarted(), other.instanceTerminationWaitTimeStarted()) && Objects.equals(this.blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration()) && Objects.equals(this.loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(this.additionalDeploymentStatusInfo(), other.additionalDeploymentStatusInfo()) && Objects.equals(this.fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString()) && this.hasDeploymentStatusMessages() == other.hasDeploymentStatusMessages() && Objects.equals(this.deploymentStatusMessages(), other.deploymentStatusMessages()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.relatedDeployments(), other.relatedDeployments()) && Objects.equals(this.overrideAlarmConfiguration(), other.overrideAlarmConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentInfo").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("DeploymentId", (Object)this.deploymentId()).add("PreviousRevision", (Object)this.previousRevision()).add("Revision", (Object)this.revision()).add("Status", (Object)this.statusAsString()).add("ErrorInformation", (Object)this.errorInformation()).add("CreateTime", (Object)this.createTime()).add("StartTime", (Object)this.startTime()).add("CompleteTime", (Object)this.completeTime()).add("DeploymentOverview", (Object)this.deploymentOverview()).add("Description", (Object)this.description()).add("Creator", (Object)this.creatorAsString()).add("IgnoreApplicationStopFailures", (Object)this.ignoreApplicationStopFailures()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("UpdateOutdatedInstancesOnly", (Object)this.updateOutdatedInstancesOnly()).add("RollbackInfo", (Object)this.rollbackInfo()).add("DeploymentStyle", (Object)this.deploymentStyle()).add("TargetInstances", (Object)this.targetInstances()).add("InstanceTerminationWaitTimeStarted", (Object)this.instanceTerminationWaitTimeStarted()).add("BlueGreenDeploymentConfiguration", (Object)this.blueGreenDeploymentConfiguration()).add("LoadBalancerInfo", (Object)this.loadBalancerInfo()).add("AdditionalDeploymentStatusInfo", (Object)this.additionalDeploymentStatusInfo()).add("FileExistsBehavior", (Object)this.fileExistsBehaviorAsString()).add("DeploymentStatusMessages", this.hasDeploymentStatusMessages() ? this.deploymentStatusMessages() : null).add("ComputePlatform", (Object)this.computePlatformAsString()).add("ExternalId", (Object)this.externalId()).add("RelatedDeployments", (Object)this.relatedDeployments()).add("OverrideAlarmConfiguration", (Object)this.overrideAlarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "previousRevision": {
                return Optional.ofNullable(clazz.cast(this.previousRevision()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorInformation": {
                return Optional.ofNullable(clazz.cast(this.errorInformation()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "completeTime": {
                return Optional.ofNullable(clazz.cast(this.completeTime()));
            }
            case "deploymentOverview": {
                return Optional.ofNullable(clazz.cast(this.deploymentOverview()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creator": {
                return Optional.ofNullable(clazz.cast(this.creatorAsString()));
            }
            case "ignoreApplicationStopFailures": {
                return Optional.ofNullable(clazz.cast(this.ignoreApplicationStopFailures()));
            }
            case "autoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "updateOutdatedInstancesOnly": {
                return Optional.ofNullable(clazz.cast(this.updateOutdatedInstancesOnly()));
            }
            case "rollbackInfo": {
                return Optional.ofNullable(clazz.cast(this.rollbackInfo()));
            }
            case "deploymentStyle": {
                return Optional.ofNullable(clazz.cast(this.deploymentStyle()));
            }
            case "targetInstances": {
                return Optional.ofNullable(clazz.cast(this.targetInstances()));
            }
            case "instanceTerminationWaitTimeStarted": {
                return Optional.ofNullable(clazz.cast(this.instanceTerminationWaitTimeStarted()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerInfo()));
            }
            case "additionalDeploymentStatusInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalDeploymentStatusInfo()));
            }
            case "fileExistsBehavior": {
                return Optional.ofNullable(clazz.cast(this.fileExistsBehaviorAsString()));
            }
            case "deploymentStatusMessages": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessages()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "relatedDeployments": {
                return Optional.ofNullable(clazz.cast(this.relatedDeployments()));
            }
            case "overrideAlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.overrideAlarmConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentInfo, T> g) {
        return obj -> g.apply((DeploymentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private String deploymentId;
        private RevisionLocation previousRevision;
        private RevisionLocation revision;
        private String status;
        private ErrorInformation errorInformation;
        private Instant createTime;
        private Instant startTime;
        private Instant completeTime;
        private DeploymentOverview deploymentOverview;
        private String description;
        private String creator;
        private Boolean ignoreApplicationStopFailures;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private RollbackInfo rollbackInfo;
        private DeploymentStyle deploymentStyle;
        private TargetInstances targetInstances;
        private Boolean instanceTerminationWaitTimeStarted;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private String additionalDeploymentStatusInfo;
        private String fileExistsBehavior;
        private List<String> deploymentStatusMessages = DefaultSdkAutoConstructList.getInstance();
        private String computePlatform;
        private String externalId;
        private RelatedDeployments relatedDeployments;
        private AlarmConfiguration overrideAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentInfo model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.deploymentId(model.deploymentId);
            this.previousRevision(model.previousRevision);
            this.revision(model.revision);
            this.status(model.status);
            this.errorInformation(model.errorInformation);
            this.createTime(model.createTime);
            this.startTime(model.startTime);
            this.completeTime(model.completeTime);
            this.deploymentOverview(model.deploymentOverview);
            this.description(model.description);
            this.creator(model.creator);
            this.ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.rollbackInfo(model.rollbackInfo);
            this.deploymentStyle(model.deploymentStyle);
            this.targetInstances(model.targetInstances);
            this.instanceTerminationWaitTimeStarted(model.instanceTerminationWaitTimeStarted);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
            this.additionalDeploymentStatusInfo(model.additionalDeploymentStatusInfo);
            this.fileExistsBehavior(model.fileExistsBehavior);
            this.deploymentStatusMessages(model.deploymentStatusMessages);
            this.computePlatform(model.computePlatform);
            this.externalId(model.externalId);
            this.relatedDeployments(model.relatedDeployments);
            this.overrideAlarmConfiguration(model.overrideAlarmConfiguration);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final RevisionLocation.Builder getPreviousRevision() {
            return this.previousRevision != null ? this.previousRevision.toBuilder() : null;
        }

        public final void setPreviousRevision(RevisionLocation.BuilderImpl previousRevision) {
            this.previousRevision = previousRevision != null ? previousRevision.build() : null;
        }

        @Override
        public final Builder previousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorInformation.Builder getErrorInformation() {
            return this.errorInformation != null ? this.errorInformation.toBuilder() : null;
        }

        public final void setErrorInformation(ErrorInformation.BuilderImpl errorInformation) {
            this.errorInformation = errorInformation != null ? errorInformation.build() : null;
        }

        @Override
        public final Builder errorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompleteTime() {
            return this.completeTime;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final DeploymentOverview.Builder getDeploymentOverview() {
            return this.deploymentOverview != null ? this.deploymentOverview.toBuilder() : null;
        }

        public final void setDeploymentOverview(DeploymentOverview.BuilderImpl deploymentOverview) {
            this.deploymentOverview = deploymentOverview != null ? deploymentOverview.build() : null;
        }

        @Override
        public final Builder deploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreator() {
            return this.creator;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public final Builder creator(DeploymentCreator creator) {
            this.creator(creator == null ? null : creator.toString());
            return this;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final RollbackInfo.Builder getRollbackInfo() {
            return this.rollbackInfo != null ? this.rollbackInfo.toBuilder() : null;
        }

        public final void setRollbackInfo(RollbackInfo.BuilderImpl rollbackInfo) {
            this.rollbackInfo = rollbackInfo != null ? rollbackInfo.build() : null;
        }

        @Override
        public final Builder rollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
            return this;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return this.targetInstances != null ? this.targetInstances.toBuilder() : null;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final Boolean getInstanceTerminationWaitTimeStarted() {
            return this.instanceTerminationWaitTimeStarted;
        }

        public final void setInstanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
        }

        @Override
        public final Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
            return this;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final String getAdditionalDeploymentStatusInfo() {
            return this.additionalDeploymentStatusInfo;
        }

        public final void setAdditionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
        }

        @Override
        public final Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
            return this;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior == null ? null : fileExistsBehavior.toString());
            return this;
        }

        public final Collection<String> getDeploymentStatusMessages() {
            if (this.deploymentStatusMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deploymentStatusMessages;
        }

        public final void setDeploymentStatusMessages(Collection<String> deploymentStatusMessages) {
            this.deploymentStatusMessages = DeploymentStatusMessageListCopier.copy(deploymentStatusMessages);
        }

        @Override
        public final Builder deploymentStatusMessages(Collection<String> deploymentStatusMessages) {
            this.deploymentStatusMessages = DeploymentStatusMessageListCopier.copy(deploymentStatusMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentStatusMessages(String ... deploymentStatusMessages) {
            this.deploymentStatusMessages(Arrays.asList(deploymentStatusMessages));
            return this;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final RelatedDeployments.Builder getRelatedDeployments() {
            return this.relatedDeployments != null ? this.relatedDeployments.toBuilder() : null;
        }

        public final void setRelatedDeployments(RelatedDeployments.BuilderImpl relatedDeployments) {
            this.relatedDeployments = relatedDeployments != null ? relatedDeployments.build() : null;
        }

        @Override
        public final Builder relatedDeployments(RelatedDeployments relatedDeployments) {
            this.relatedDeployments = relatedDeployments;
            return this;
        }

        public final AlarmConfiguration.Builder getOverrideAlarmConfiguration() {
            return this.overrideAlarmConfiguration != null ? this.overrideAlarmConfiguration.toBuilder() : null;
        }

        public final void setOverrideAlarmConfiguration(AlarmConfiguration.BuilderImpl overrideAlarmConfiguration) {
            this.overrideAlarmConfiguration = overrideAlarmConfiguration != null ? overrideAlarmConfiguration.build() : null;
        }

        @Override
        public final Builder overrideAlarmConfiguration(AlarmConfiguration overrideAlarmConfiguration) {
            this.overrideAlarmConfiguration = overrideAlarmConfiguration;
            return this;
        }

        public DeploymentInfo build() {
            return new DeploymentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentInfo> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder deploymentId(String var1);

        public Builder previousRevision(RevisionLocation var1);

        default public Builder previousRevision(Consumer<RevisionLocation.Builder> previousRevision) {
            return this.previousRevision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(previousRevision)).build());
        }

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(revision)).build());
        }

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder errorInformation(ErrorInformation var1);

        default public Builder errorInformation(Consumer<ErrorInformation.Builder> errorInformation) {
            return this.errorInformation((ErrorInformation)((ErrorInformation.Builder)ErrorInformation.builder().applyMutation(errorInformation)).build());
        }

        public Builder createTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completeTime(Instant var1);

        public Builder deploymentOverview(DeploymentOverview var1);

        default public Builder deploymentOverview(Consumer<DeploymentOverview.Builder> deploymentOverview) {
            return this.deploymentOverview((DeploymentOverview)((DeploymentOverview.Builder)DeploymentOverview.builder().applyMutation(deploymentOverview)).build());
        }

        public Builder description(String var1);

        public Builder creator(String var1);

        public Builder creator(DeploymentCreator var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration)).build());
        }

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder rollbackInfo(RollbackInfo var1);

        default public Builder rollbackInfo(Consumer<RollbackInfo.Builder> rollbackInfo) {
            return this.rollbackInfo((RollbackInfo)((RollbackInfo.Builder)RollbackInfo.builder().applyMutation(rollbackInfo)).build());
        }

        public Builder deploymentStyle(DeploymentStyle var1);

        default public Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return this.deploymentStyle((DeploymentStyle)((DeploymentStyle.Builder)DeploymentStyle.builder().applyMutation(deploymentStyle)).build());
        }

        public Builder targetInstances(TargetInstances var1);

        default public Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return this.targetInstances((TargetInstances)((TargetInstances.Builder)TargetInstances.builder().applyMutation(targetInstances)).build());
        }

        public Builder instanceTerminationWaitTimeStarted(Boolean var1);

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        default public Builder blueGreenDeploymentConfiguration(Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return this.blueGreenDeploymentConfiguration((BlueGreenDeploymentConfiguration)((BlueGreenDeploymentConfiguration.Builder)BlueGreenDeploymentConfiguration.builder().applyMutation(blueGreenDeploymentConfiguration)).build());
        }

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        default public Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return this.loadBalancerInfo((LoadBalancerInfo)((LoadBalancerInfo.Builder)LoadBalancerInfo.builder().applyMutation(loadBalancerInfo)).build());
        }

        public Builder additionalDeploymentStatusInfo(String var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);

        public Builder deploymentStatusMessages(Collection<String> var1);

        public Builder deploymentStatusMessages(String ... var1);

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder externalId(String var1);

        public Builder relatedDeployments(RelatedDeployments var1);

        default public Builder relatedDeployments(Consumer<RelatedDeployments.Builder> relatedDeployments) {
            return this.relatedDeployments((RelatedDeployments)((RelatedDeployments.Builder)RelatedDeployments.builder().applyMutation(relatedDeployments)).build());
        }

        public Builder overrideAlarmConfiguration(AlarmConfiguration var1);

        default public Builder overrideAlarmConfiguration(Consumer<AlarmConfiguration.Builder> overrideAlarmConfiguration) {
            return this.overrideAlarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(overrideAlarmConfiguration)).build());
        }
    }
}

