/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that specifies the result, such as rollback, to occur upon stage failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureConditions implements SdkPojo, Serializable,
        ToCopyableBuilder<FailureConditions.Builder, FailureConditions> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(FailureConditions::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String result;

    private FailureConditions(BuilderImpl builder) {
        this.result = builder.result;
    }

    /**
     * <p>
     * The specified result for when the failure conditions are met, such as rolling back the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link Result#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The specified result for when the failure conditions are met, such as rolling back the stage.
     * @see Result
     */
    public final Result result() {
        return Result.fromValue(result);
    }

    /**
     * <p>
     * The specified result for when the failure conditions are met, such as rolling back the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link Result#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The specified result for when the failure conditions are met, such as rolling back the stage.
     * @see Result
     */
    public final String resultAsString() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureConditions)) {
            return false;
        }
        FailureConditions other = (FailureConditions) obj;
        return Objects.equals(resultAsString(), other.resultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailureConditions").add("Result", resultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureConditions, T> g) {
        return obj -> g.apply((FailureConditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureConditions> {
        /**
         * <p>
         * The specified result for when the failure conditions are met, such as rolling back the stage.
         * </p>
         * 
         * @param result
         *        The specified result for when the failure conditions are met, such as rolling back the stage.
         * @see Result
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Result
         */
        Builder result(String result);

        /**
         * <p>
         * The specified result for when the failure conditions are met, such as rolling back the stage.
         * </p>
         * 
         * @param result
         *        The specified result for when the failure conditions are met, such as rolling back the stage.
         * @see Result
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Result
         */
        Builder result(Result result);
    }

    static final class BuilderImpl implements Builder {
        private String result;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureConditions model) {
            result(model.result);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(Result result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        @Override
        public FailureConditions build() {
            return new FailureConditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
