/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of metric sources required to generate recommendations for commercial software licenses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSource implements SdkPojo, Serializable, ToCopyableBuilder<MetricSource.Builder, MetricSource> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(MetricSource::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerArn").getter(getter(MetricSource::providerArn)).setter(setter(Builder::providerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD,
            PROVIDER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String provider;

    private final String providerArn;

    private MetricSource(BuilderImpl builder) {
        this.provider = builder.provider;
        this.providerArn = builder.providerArn;
    }

    /**
     * <p>
     * The name of the metric source provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link MetricSourceProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The name of the metric source provider.
     * @see MetricSourceProvider
     */
    public final MetricSourceProvider provider() {
        return MetricSourceProvider.fromValue(provider);
    }

    /**
     * <p>
     * The name of the metric source provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link MetricSourceProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The name of the metric source provider.
     * @see MetricSourceProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * The ARN of the metric source provider.
     * </p>
     * 
     * @return The ARN of the metric source provider.
     */
    public final String providerArn() {
        return providerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(providerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSource)) {
            return false;
        }
        MetricSource other = (MetricSource) obj;
        return Objects.equals(providerAsString(), other.providerAsString()) && Objects.equals(providerArn(), other.providerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSource").add("Provider", providerAsString()).add("ProviderArn", providerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "providerArn":
            return Optional.ofNullable(clazz.cast(providerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricSource, T> g) {
        return obj -> g.apply((MetricSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSource> {
        /**
         * <p>
         * The name of the metric source provider.
         * </p>
         * 
         * @param provider
         *        The name of the metric source provider.
         * @see MetricSourceProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSourceProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The name of the metric source provider.
         * </p>
         * 
         * @param provider
         *        The name of the metric source provider.
         * @see MetricSourceProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSourceProvider
         */
        Builder provider(MetricSourceProvider provider);

        /**
         * <p>
         * The ARN of the metric source provider.
         * </p>
         * 
         * @param providerArn
         *        The ARN of the metric source provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerArn(String providerArn);
    }

    static final class BuilderImpl implements Builder {
        private String provider;

        private String providerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSource model) {
            provider(model.provider);
            providerArn(model.providerArn);
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(MetricSourceProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getProviderArn() {
            return providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        @Override
        public MetricSource build() {
            return new MetricSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
