/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the projected metrics of an Amazon RDS recommendation option.
 * </p>
 * <p>
 * To determine the performance difference between your current Amazon RDS and the recommended option, compare the
 * metric data of your service against its projected metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSDatabaseRecommendedOptionProjectedMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<RDSDatabaseRecommendedOptionProjectedMetric.Builder, RDSDatabaseRecommendedOptionProjectedMetric> {
    private static final SdkField<String> RECOMMENDED_DB_INSTANCE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("recommendedDBInstanceClass")
            .getter(getter(RDSDatabaseRecommendedOptionProjectedMetric::recommendedDBInstanceClass))
            .setter(setter(Builder::recommendedDBInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedDBInstanceClass").build())
            .build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(RDSDatabaseRecommendedOptionProjectedMetric::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<List<RDSDatabaseProjectedMetric>> PROJECTED_METRICS_FIELD = SdkField
            .<List<RDSDatabaseProjectedMetric>> builder(MarshallingType.LIST)
            .memberName("projectedMetrics")
            .getter(getter(RDSDatabaseRecommendedOptionProjectedMetric::projectedMetrics))
            .setter(setter(Builder::projectedMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RDSDatabaseProjectedMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(RDSDatabaseProjectedMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDED_DB_INSTANCE_CLASS_FIELD, RANK_FIELD, PROJECTED_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendedDBInstanceClass;

    private final Integer rank;

    private final List<RDSDatabaseProjectedMetric> projectedMetrics;

    private RDSDatabaseRecommendedOptionProjectedMetric(BuilderImpl builder) {
        this.recommendedDBInstanceClass = builder.recommendedDBInstanceClass;
        this.rank = builder.rank;
        this.projectedMetrics = builder.projectedMetrics;
    }

    /**
     * <p>
     * The recommended DB instance class for the Amazon RDS.
     * </p>
     * 
     * @return The recommended DB instance class for the Amazon RDS.
     */
    public final String recommendedDBInstanceClass() {
        return recommendedDBInstanceClass;
    }

    /**
     * <p>
     * The rank identifier of the RDS instance recommendation option.
     * </p>
     * 
     * @return The rank identifier of the RDS instance recommendation option.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectedMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectedMetrics() {
        return projectedMetrics != null && !(projectedMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the projected metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectedMetrics} method.
     * </p>
     * 
     * @return An array of objects that describe the projected metric.
     */
    public final List<RDSDatabaseProjectedMetric> projectedMetrics() {
        return projectedMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendedDBInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedMetrics() ? projectedMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabaseRecommendedOptionProjectedMetric)) {
            return false;
        }
        RDSDatabaseRecommendedOptionProjectedMetric other = (RDSDatabaseRecommendedOptionProjectedMetric) obj;
        return Objects.equals(recommendedDBInstanceClass(), other.recommendedDBInstanceClass())
                && Objects.equals(rank(), other.rank()) && hasProjectedMetrics() == other.hasProjectedMetrics()
                && Objects.equals(projectedMetrics(), other.projectedMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSDatabaseRecommendedOptionProjectedMetric")
                .add("RecommendedDBInstanceClass", recommendedDBInstanceClass()).add("Rank", rank())
                .add("ProjectedMetrics", hasProjectedMetrics() ? projectedMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendedDBInstanceClass":
            return Optional.ofNullable(clazz.cast(recommendedDBInstanceClass()));
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "projectedMetrics":
            return Optional.ofNullable(clazz.cast(projectedMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSDatabaseRecommendedOptionProjectedMetric, T> g) {
        return obj -> g.apply((RDSDatabaseRecommendedOptionProjectedMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSDatabaseRecommendedOptionProjectedMetric> {
        /**
         * <p>
         * The recommended DB instance class for the Amazon RDS.
         * </p>
         * 
         * @param recommendedDBInstanceClass
         *        The recommended DB instance class for the Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedDBInstanceClass(String recommendedDBInstanceClass);

        /**
         * <p>
         * The rank identifier of the RDS instance recommendation option.
         * </p>
         * 
         * @param rank
         *        The rank identifier of the RDS instance recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * 
         * @param projectedMetrics
         *        An array of objects that describe the projected metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedMetrics(Collection<RDSDatabaseProjectedMetric> projectedMetrics);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * 
         * @param projectedMetrics
         *        An array of objects that describe the projected metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedMetrics(RDSDatabaseProjectedMetric... projectedMetrics);

        /**
         * <p>
         * An array of objects that describe the projected metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetric.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetric.Builder#build()} is
         * called immediately and its result is passed to {@link #projectedMetrics(List<RDSDatabaseProjectedMetric>)}.
         * 
         * @param projectedMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectedMetrics(java.util.Collection<RDSDatabaseProjectedMetric>)
         */
        Builder projectedMetrics(Consumer<RDSDatabaseProjectedMetric.Builder>... projectedMetrics);
    }

    static final class BuilderImpl implements Builder {
        private String recommendedDBInstanceClass;

        private Integer rank;

        private List<RDSDatabaseProjectedMetric> projectedMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabaseRecommendedOptionProjectedMetric model) {
            recommendedDBInstanceClass(model.recommendedDBInstanceClass);
            rank(model.rank);
            projectedMetrics(model.projectedMetrics);
        }

        public final String getRecommendedDBInstanceClass() {
            return recommendedDBInstanceClass;
        }

        public final void setRecommendedDBInstanceClass(String recommendedDBInstanceClass) {
            this.recommendedDBInstanceClass = recommendedDBInstanceClass;
        }

        @Override
        public final Builder recommendedDBInstanceClass(String recommendedDBInstanceClass) {
            this.recommendedDBInstanceClass = recommendedDBInstanceClass;
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final List<RDSDatabaseProjectedMetric.Builder> getProjectedMetrics() {
            List<RDSDatabaseProjectedMetric.Builder> result = RDSDatabaseProjectedMetricsCopier
                    .copyToBuilder(this.projectedMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedMetrics(Collection<RDSDatabaseProjectedMetric.BuilderImpl> projectedMetrics) {
            this.projectedMetrics = RDSDatabaseProjectedMetricsCopier.copyFromBuilder(projectedMetrics);
        }

        @Override
        public final Builder projectedMetrics(Collection<RDSDatabaseProjectedMetric> projectedMetrics) {
            this.projectedMetrics = RDSDatabaseProjectedMetricsCopier.copy(projectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(RDSDatabaseProjectedMetric... projectedMetrics) {
            projectedMetrics(Arrays.asList(projectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(Consumer<RDSDatabaseProjectedMetric.Builder>... projectedMetrics) {
            projectedMetrics(Stream.of(projectedMetrics).map(c -> RDSDatabaseProjectedMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RDSDatabaseRecommendedOptionProjectedMetric build() {
            return new RDSDatabaseRecommendedOptionProjectedMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
