/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the effective recommendation preferences for Amazon RDS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSEffectiveRecommendationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<RDSEffectiveRecommendationPreferences.Builder, RDSEffectiveRecommendationPreferences> {
    private static final SdkField<List<String>> CPU_VENDOR_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cpuVendorArchitectures")
            .getter(getter(RDSEffectiveRecommendationPreferences::cpuVendorArchitecturesAsStrings))
            .setter(setter(Builder::cpuVendorArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuVendorArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enhancedInfrastructureMetrics")
            .getter(getter(RDSEffectiveRecommendationPreferences::enhancedInfrastructureMetricsAsString))
            .setter(setter(Builder::enhancedInfrastructureMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics")
                    .build()).build();

    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lookBackPeriod").getter(getter(RDSEffectiveRecommendationPreferences::lookBackPeriodAsString))
            .setter(setter(Builder::lookBackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()).build();

    private static final SdkField<RDSSavingsEstimationMode> SAVINGS_ESTIMATION_MODE_FIELD = SdkField
            .<RDSSavingsEstimationMode> builder(MarshallingType.SDK_POJO).memberName("savingsEstimationMode")
            .getter(getter(RDSEffectiveRecommendationPreferences::savingsEstimationMode))
            .setter(setter(Builder::savingsEstimationMode)).constructor(RDSSavingsEstimationMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CPU_VENDOR_ARCHITECTURES_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, LOOK_BACK_PERIOD_FIELD,
            SAVINGS_ESTIMATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cpuVendorArchitectures;

    private final String enhancedInfrastructureMetrics;

    private final String lookBackPeriod;

    private final RDSSavingsEstimationMode savingsEstimationMode;

    private RDSEffectiveRecommendationPreferences(BuilderImpl builder) {
        this.cpuVendorArchitectures = builder.cpuVendorArchitectures;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    /**
     * <p>
     * Describes the CPU vendor and architecture for Amazon RDS recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Describes the CPU vendor and architecture for Amazon RDS recommendations.
     */
    public final List<CpuVendorArchitecture> cpuVendorArchitectures() {
        return CpuVendorArchitecturesCopier.copyStringToEnum(cpuVendorArchitectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the CpuVendorArchitectures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCpuVendorArchitectures() {
        return cpuVendorArchitectures != null && !(cpuVendorArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the CPU vendor and architecture for Amazon RDS recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Describes the CPU vendor and architecture for Amazon RDS recommendations.
     */
    public final List<String> cpuVendorArchitecturesAsStrings() {
        return cpuVendorArchitectures;
    }

    /**
     * <p>
     * Describes the activation status of the enhanced infrastructure metrics preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return Describes the activation status of the enhanced infrastructure metrics preference. </p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(enhancedInfrastructureMetrics);
    }

    /**
     * <p>
     * Describes the activation status of the enhanced infrastructure metrics preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return Describes the activation status of the enhanced infrastructure metrics preference. </p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final String enhancedInfrastructureMetricsAsString() {
        return enhancedInfrastructureMetrics;
    }

    /**
     * <p>
     * The number of days the utilization metrics of the Amazon RDS are analyzed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The number of days the utilization metrics of the Amazon RDS are analyzed.
     * @see LookBackPeriodPreference
     */
    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(lookBackPeriod);
    }

    /**
     * <p>
     * The number of days the utilization metrics of the Amazon RDS are analyzed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The number of days the utilization metrics of the Amazon RDS are analyzed.
     * @see LookBackPeriodPreference
     */
    public final String lookBackPeriodAsString() {
        return lookBackPeriod;
    }

    /**
     * <p>
     * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon RDS.
     * </p>
     * 
     * @return Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon
     *         RDS.
     */
    public final RDSSavingsEstimationMode savingsEstimationMode() {
        return savingsEstimationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsEstimationMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSEffectiveRecommendationPreferences)) {
            return false;
        }
        RDSEffectiveRecommendationPreferences other = (RDSEffectiveRecommendationPreferences) obj;
        return hasCpuVendorArchitectures() == other.hasCpuVendorArchitectures()
                && Objects.equals(cpuVendorArchitecturesAsStrings(), other.cpuVendorArchitecturesAsStrings())
                && Objects.equals(enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString())
                && Objects.equals(lookBackPeriodAsString(), other.lookBackPeriodAsString())
                && Objects.equals(savingsEstimationMode(), other.savingsEstimationMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSEffectiveRecommendationPreferences")
                .add("CpuVendorArchitectures", hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null)
                .add("EnhancedInfrastructureMetrics", enhancedInfrastructureMetricsAsString())
                .add("LookBackPeriod", lookBackPeriodAsString()).add("SavingsEstimationMode", savingsEstimationMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuVendorArchitectures":
            return Optional.ofNullable(clazz.cast(cpuVendorArchitecturesAsStrings()));
        case "enhancedInfrastructureMetrics":
            return Optional.ofNullable(clazz.cast(enhancedInfrastructureMetricsAsString()));
        case "lookBackPeriod":
            return Optional.ofNullable(clazz.cast(lookBackPeriodAsString()));
        case "savingsEstimationMode":
            return Optional.ofNullable(clazz.cast(savingsEstimationMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSEffectiveRecommendationPreferences, T> g) {
        return obj -> g.apply((RDSEffectiveRecommendationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSEffectiveRecommendationPreferences> {
        /**
         * <p>
         * Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * </p>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * </p>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * </p>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * </p>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for Amazon RDS recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures);

        /**
         * <p>
         * Describes the activation status of the enhanced infrastructure metrics preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        Describes the activation status of the enhanced infrastructure metrics preference. </p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics);

        /**
         * <p>
         * Describes the activation status of the enhanced infrastructure metrics preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        Describes the activation status of the enhanced infrastructure metrics preference. </p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics);

        /**
         * <p>
         * The number of days the utilization metrics of the Amazon RDS are analyzed.
         * </p>
         * 
         * @param lookBackPeriod
         *        The number of days the utilization metrics of the Amazon RDS are analyzed.
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(String lookBackPeriod);

        /**
         * <p>
         * The number of days the utilization metrics of the Amazon RDS are analyzed.
         * </p>
         * 
         * @param lookBackPeriod
         *        The number of days the utilization metrics of the Amazon RDS are analyzed.
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod);

        /**
         * <p>
         * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon RDS.
         * </p>
         * 
         * @param savingsEstimationMode
         *        Describes the savings estimation mode preference applied for calculating savings opportunity for
         *        Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsEstimationMode(RDSSavingsEstimationMode savingsEstimationMode);

        /**
         * <p>
         * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon RDS.
         * </p>
         * This is a convenience method that creates an instance of the {@link RDSSavingsEstimationMode.Builder}
         * avoiding the need to create one manually via {@link RDSSavingsEstimationMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSSavingsEstimationMode.Builder#build()} is called immediately
         * and its result is passed to {@link #savingsEstimationMode(RDSSavingsEstimationMode)}.
         * 
         * @param savingsEstimationMode
         *        a consumer that will call methods on {@link RDSSavingsEstimationMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsEstimationMode(RDSSavingsEstimationMode)
         */
        default Builder savingsEstimationMode(Consumer<RDSSavingsEstimationMode.Builder> savingsEstimationMode) {
            return savingsEstimationMode(RDSSavingsEstimationMode.builder().applyMutation(savingsEstimationMode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> cpuVendorArchitectures = DefaultSdkAutoConstructList.getInstance();

        private String enhancedInfrastructureMetrics;

        private String lookBackPeriod;

        private RDSSavingsEstimationMode savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSEffectiveRecommendationPreferences model) {
            cpuVendorArchitecturesWithStrings(model.cpuVendorArchitectures);
            enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            lookBackPeriod(model.lookBackPeriod);
            savingsEstimationMode(model.savingsEstimationMode);
        }

        public final Collection<String> getCpuVendorArchitectures() {
            if (cpuVendorArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return cpuVendorArchitectures;
        }

        public final void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
        }

        @Override
        public final Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures) {
            cpuVendorArchitecturesWithStrings(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        public final Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copyEnumToString(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures) {
            cpuVendorArchitectures(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics
                    .toString());
            return this;
        }

        public final String getLookBackPeriod() {
            return lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final RDSSavingsEstimationMode.Builder getSavingsEstimationMode() {
            return savingsEstimationMode != null ? savingsEstimationMode.toBuilder() : null;
        }

        public final void setSavingsEstimationMode(RDSSavingsEstimationMode.BuilderImpl savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode != null ? savingsEstimationMode.build() : null;
        }

        @Override
        public final Builder savingsEstimationMode(RDSSavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public RDSEffectiveRecommendationPreferences build() {
            return new RDSEffectiveRecommendationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
