/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recommendation preferences to return in the response of a <a>GetAutoScalingGroupRecommendations</a>,
 * <a>GetEC2InstanceRecommendations</a>, <a>GetEC2RecommendationProjectedMetrics</a>,
 * <a>GetRDSDatabaseRecommendations</a>, and <a>GetRDSDatabaseRecommendationProjectedMetrics</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationPreferences.Builder, RecommendationPreferences> {
    private static final SdkField<List<String>> CPU_VENDOR_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cpuVendorArchitectures")
            .getter(getter(RecommendationPreferences::cpuVendorArchitecturesAsStrings))
            .setter(setter(Builder::cpuVendorArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuVendorArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CPU_VENDOR_ARCHITECTURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cpuVendorArchitectures;

    private RecommendationPreferences(BuilderImpl builder) {
        this.cpuVendorArchitectures = builder.cpuVendorArchitectures;
    }

    /**
     * <p>
     * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
     * </p>
     * <p>
     * For example, when you specify <code>AWS_ARM64</code> with:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
     * returns recommendations that consist of Graviton instance types only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics
     * for Graviton instance type recommendations only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
     * Optimizer exports recommendations that consist of Graviton instance types only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
     *         recommendations.</p>
     *         <p>
     *         For example, when you specify <code>AWS_ARM64</code> with:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
     *         Optimizer returns recommendations that consist of Graviton instance types only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
     *         metrics for Graviton instance type recommendations only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
     *         Compute Optimizer exports recommendations that consist of Graviton instance types only.
     *         </p>
     *         </li>
     */
    public final List<CpuVendorArchitecture> cpuVendorArchitectures() {
        return CpuVendorArchitecturesCopier.copyStringToEnum(cpuVendorArchitectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the CpuVendorArchitectures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCpuVendorArchitectures() {
        return cpuVendorArchitectures != null && !(cpuVendorArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
     * </p>
     * <p>
     * For example, when you specify <code>AWS_ARM64</code> with:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
     * returns recommendations that consist of Graviton instance types only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics
     * for Graviton instance type recommendations only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
     * Optimizer exports recommendations that consist of Graviton instance types only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
     *         recommendations.</p>
     *         <p>
     *         For example, when you specify <code>AWS_ARM64</code> with:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
     *         Optimizer returns recommendations that consist of Graviton instance types only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
     *         metrics for Graviton instance type recommendations only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
     *         Compute Optimizer exports recommendations that consist of Graviton instance types only.
     *         </p>
     *         </li>
     */
    public final List<String> cpuVendorArchitecturesAsStrings() {
        return cpuVendorArchitectures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationPreferences)) {
            return false;
        }
        RecommendationPreferences other = (RecommendationPreferences) obj;
        return hasCpuVendorArchitectures() == other.hasCpuVendorArchitectures()
                && Objects.equals(cpuVendorArchitecturesAsStrings(), other.cpuVendorArchitecturesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationPreferences")
                .add("CpuVendorArchitectures", hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuVendorArchitectures":
            return Optional.ofNullable(clazz.cast(cpuVendorArchitecturesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationPreferences, T> g) {
        return obj -> g.apply((RecommendationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationPreferences> {
        /**
         * <p>
         * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures);

        /**
         * <p>
         * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures);

        /**
         * <p>
         * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures);

        /**
         * <p>
         * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cpuVendorArchitectures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationPreferences model) {
            cpuVendorArchitecturesWithStrings(model.cpuVendorArchitectures);
        }

        public final Collection<String> getCpuVendorArchitectures() {
            if (cpuVendorArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return cpuVendorArchitectures;
        }

        public final void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
        }

        @Override
        public final Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures) {
            cpuVendorArchitecturesWithStrings(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        public final Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copyEnumToString(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures) {
            cpuVendorArchitectures(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        public RecommendationPreferences build() {
            return new RecommendationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
