/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnrollmentStatusRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<UpdateEnrollmentStatusRequest.Builder, UpdateEnrollmentStatusRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateEnrollmentStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeMemberAccounts").getter(getter(UpdateEnrollmentStatusRequest::includeMemberAccounts))
            .setter(setter(Builder::includeMemberAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            INCLUDE_MEMBER_ACCOUNTS_FIELD));

    private final String status;

    private final Boolean includeMemberAccounts;

    private UpdateEnrollmentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.includeMemberAccounts = builder.includeMemberAccounts;
    }

    /**
     * <p>
     * The new enrollment status of the account.
     * </p>
     * <p>
     * The following status options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins analyzing
     * the configuration and utilization metrics of your Amazon Web Services resources after you opt in. For more
     * information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed
     * by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's recommendations
     * and related metrics data will be deleted from Compute Optimizer after you opt out.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an
     * account. They are returned in the response of a request to update the enrollment status of an account.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new enrollment status of the account.</p>
     *         <p>
     *         The following status options are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
     *         analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt
     *         in. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute
     *         Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
     *         recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status
     *         of an account. They are returned in the response of a request to update the enrollment status of an
     *         account.
     *         </p>
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The new enrollment status of the account.
     * </p>
     * <p>
     * The following status options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins analyzing
     * the configuration and utilization metrics of your Amazon Web Services resources after you opt in. For more
     * information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed
     * by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's recommendations
     * and related metrics data will be deleted from Compute Optimizer after you opt out.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an
     * account. They are returned in the response of a request to update the enrollment status of an account.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new enrollment status of the account.</p>
     *         <p>
     *         The following status options are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
     *         analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt
     *         in. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute
     *         Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
     *         recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status
     *         of an account. They are returned in the response of a request to update the enrollment status of an
     *         account.
     *         </p>
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates whether to enroll member accounts of the organization if the account is the management account of an
     * organization.
     * </p>
     * 
     * @return Indicates whether to enroll member accounts of the organization if the account is the management account
     *         of an organization.
     */
    public final Boolean includeMemberAccounts() {
        return includeMemberAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeMemberAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnrollmentStatusRequest)) {
            return false;
        }
        UpdateEnrollmentStatusRequest other = (UpdateEnrollmentStatusRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(includeMemberAccounts(), other.includeMemberAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnrollmentStatusRequest").add("Status", statusAsString())
                .add("IncludeMemberAccounts", includeMemberAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "includeMemberAccounts":
            return Optional.ofNullable(clazz.cast(includeMemberAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnrollmentStatusRequest, T> g) {
        return obj -> g.apply((UpdateEnrollmentStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnrollmentStatusRequest> {
        /**
         * <p>
         * The new enrollment status of the account.
         * </p>
         * <p>
         * The following status options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
         * analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt in.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute
         * Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
         * recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an
         * account. They are returned in the response of a request to update the enrollment status of an account.
         * </p>
         * </note>
         * 
         * @param status
         *        The new enrollment status of the account.</p>
         *        <p>
         *        The following status options are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
         *        analyzing the configuration and utilization metrics of your Amazon Web Services resources after you
         *        opt in. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by
         *        Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
         *        recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment
         *        status of an account. They are returned in the response of a request to update the enrollment status
         *        of an account.
         *        </p>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The new enrollment status of the account.
         * </p>
         * <p>
         * The following status options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
         * analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt in.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute
         * Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
         * recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an
         * account. They are returned in the response of a request to update the enrollment status of an account.
         * </p>
         * </note>
         * 
         * @param status
         *        The new enrollment status of the account.</p>
         *        <p>
         *        The following status options are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins
         *        analyzing the configuration and utilization metrics of your Amazon Web Services resources after you
         *        opt in. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by
         *        Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account's
         *        recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment
         *        status of an account. They are returned in the response of a request to update the enrollment status
         *        of an account.
         *        </p>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Indicates whether to enroll member accounts of the organization if the account is the management account of
         * an organization.
         * </p>
         * 
         * @param includeMemberAccounts
         *        Indicates whether to enroll member accounts of the organization if the account is the management
         *        account of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMemberAccounts(Boolean includeMemberAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private String status;

        private Boolean includeMemberAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnrollmentStatusRequest model) {
            super(model);
            status(model.status);
            includeMemberAccounts(model.includeMemberAccounts);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIncludeMemberAccounts() {
            return includeMemberAccounts;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnrollmentStatusRequest build() {
            return new UpdateEnrollmentStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
