/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for column evaluations for a profile job. ColumnStatisticsConfiguration can be used to select
 * evaluations and override parameters of evaluations for particular columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatisticsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatisticsConfiguration.Builder, ColumnStatisticsConfiguration> {
    private static final SdkField<List<ColumnSelector>> SELECTORS_FIELD = SdkField
            .<List<ColumnSelector>> builder(MarshallingType.LIST)
            .memberName("Selectors")
            .getter(getter(ColumnStatisticsConfiguration::selectors))
            .setter(setter(Builder::selectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StatisticsConfiguration> STATISTICS_FIELD = SdkField
            .<StatisticsConfiguration> builder(MarshallingType.SDK_POJO).memberName("Statistics")
            .getter(getter(ColumnStatisticsConfiguration::statistics)).setter(setter(Builder::statistics))
            .constructor(StatisticsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTORS_FIELD,
            STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ColumnSelector> selectors;

    private final StatisticsConfiguration statistics;

    private ColumnStatisticsConfiguration(BuilderImpl builder) {
        this.selectors = builder.selectors;
        this.statistics = builder.statistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Selectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSelectors() {
        return selectors != null && !(selectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of column selectors. Selectors can be used to select columns from the dataset. When selectors are undefined,
     * configuration will be applied to all supported columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectors} method.
     * </p>
     * 
     * @return List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
     *         undefined, configuration will be applied to all supported columns.
     */
    public final List<ColumnSelector> selectors() {
        return selectors;
    }

    /**
     * <p>
     * Configuration for evaluations. Statistics can be used to select evaluations and override parameters of
     * evaluations.
     * </p>
     * 
     * @return Configuration for evaluations. Statistics can be used to select evaluations and override parameters of
     *         evaluations.
     */
    public final StatisticsConfiguration statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectors() ? selectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsConfiguration)) {
            return false;
        }
        ColumnStatisticsConfiguration other = (ColumnStatisticsConfiguration) obj;
        return hasSelectors() == other.hasSelectors() && Objects.equals(selectors(), other.selectors())
                && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatisticsConfiguration").add("Selectors", hasSelectors() ? selectors() : null)
                .add("Statistics", statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Selectors":
            return Optional.ofNullable(clazz.cast(selectors()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsConfiguration, T> g) {
        return obj -> g.apply((ColumnStatisticsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatisticsConfiguration> {
        /**
         * <p>
         * List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
         * undefined, configuration will be applied to all supported columns.
         * </p>
         * 
         * @param selectors
         *        List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
         *        undefined, configuration will be applied to all supported columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Collection<ColumnSelector> selectors);

        /**
         * <p>
         * List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
         * undefined, configuration will be applied to all supported columns.
         * </p>
         * 
         * @param selectors
         *        List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
         *        undefined, configuration will be applied to all supported columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(ColumnSelector... selectors);

        /**
         * <p>
         * List of column selectors. Selectors can be used to select columns from the dataset. When selectors are
         * undefined, configuration will be applied to all supported columns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databrew.model.ColumnSelector.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databrew.model.ColumnSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databrew.model.ColumnSelector.Builder#build()} is called immediately
         * and its result is passed to {@link #selectors(List<ColumnSelector>)}.
         * 
         * @param selectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databrew.model.ColumnSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectors(java.util.Collection<ColumnSelector>)
         */
        Builder selectors(Consumer<ColumnSelector.Builder>... selectors);

        /**
         * <p>
         * Configuration for evaluations. Statistics can be used to select evaluations and override parameters of
         * evaluations.
         * </p>
         * 
         * @param statistics
         *        Configuration for evaluations. Statistics can be used to select evaluations and override parameters of
         *        evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(StatisticsConfiguration statistics);

        /**
         * <p>
         * Configuration for evaluations. Statistics can be used to select evaluations and override parameters of
         * evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatisticsConfiguration.Builder} avoiding
         * the need to create one manually via {@link StatisticsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatisticsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #statistics(StatisticsConfiguration)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link StatisticsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(StatisticsConfiguration)
         */
        default Builder statistics(Consumer<StatisticsConfiguration.Builder> statistics) {
            return statistics(StatisticsConfiguration.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ColumnSelector> selectors = DefaultSdkAutoConstructList.getInstance();

        private StatisticsConfiguration statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsConfiguration model) {
            selectors(model.selectors);
            statistics(model.statistics);
        }

        public final List<ColumnSelector.Builder> getSelectors() {
            List<ColumnSelector.Builder> result = ColumnSelectorListCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<ColumnSelector.BuilderImpl> selectors) {
            this.selectors = ColumnSelectorListCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<ColumnSelector> selectors) {
            this.selectors = ColumnSelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(ColumnSelector... selectors) {
            selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<ColumnSelector.Builder>... selectors) {
            selectors(Stream.of(selectors).map(c -> ColumnSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StatisticsConfiguration.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(StatisticsConfiguration.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(StatisticsConfiguration statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public ColumnStatisticsConfiguration build() {
            return new ColumnStatisticsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
