/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityProviderConfigResponse extends EksResponse implements
        ToCopyableBuilder<DescribeIdentityProviderConfigResponse.Builder, DescribeIdentityProviderConfigResponse> {
    private static final SdkField<IdentityProviderConfigResponse> IDENTITY_PROVIDER_CONFIG_FIELD = SdkField
            .<IdentityProviderConfigResponse> builder(MarshallingType.SDK_POJO).memberName("identityProviderConfig")
            .getter(getter(DescribeIdentityProviderConfigResponse::identityProviderConfig))
            .setter(setter(Builder::identityProviderConfig)).constructor(IdentityProviderConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTITY_PROVIDER_CONFIG_FIELD));

    private final IdentityProviderConfigResponse identityProviderConfig;

    private DescribeIdentityProviderConfigResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderConfig = builder.identityProviderConfig;
    }

    /**
     * <p>
     * The object that represents an OpenID Connect (OIDC) identity provider configuration.
     * </p>
     * 
     * @return The object that represents an OpenID Connect (OIDC) identity provider configuration.
     */
    public final IdentityProviderConfigResponse identityProviderConfig() {
        return identityProviderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigResponse)) {
            return false;
        }
        DescribeIdentityProviderConfigResponse other = (DescribeIdentityProviderConfigResponse) obj;
        return Objects.equals(identityProviderConfig(), other.identityProviderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityProviderConfigResponse").add("IdentityProviderConfig", identityProviderConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityProviderConfig":
            return Optional.ofNullable(clazz.cast(identityProviderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIdentityProviderConfigResponse> {
        /**
         * <p>
         * The object that represents an OpenID Connect (OIDC) identity provider configuration.
         * </p>
         * 
         * @param identityProviderConfig
         *        The object that represents an OpenID Connect (OIDC) identity provider configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfig(IdentityProviderConfigResponse identityProviderConfig);

        /**
         * <p>
         * The object that represents an OpenID Connect (OIDC) identity provider configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfigResponse.Builder}
         * avoiding the need to create one manually via {@link IdentityProviderConfigResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderConfigResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfig(IdentityProviderConfigResponse)}.
         * 
         * @param identityProviderConfig
         *        a consumer that will call methods on {@link IdentityProviderConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfig(IdentityProviderConfigResponse)
         */
        default Builder identityProviderConfig(Consumer<IdentityProviderConfigResponse.Builder> identityProviderConfig) {
            return identityProviderConfig(IdentityProviderConfigResponse.builder().applyMutation(identityProviderConfig).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private IdentityProviderConfigResponse identityProviderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigResponse model) {
            super(model);
            identityProviderConfig(model.identityProviderConfig);
        }

        public final IdentityProviderConfigResponse.Builder getIdentityProviderConfig() {
            return identityProviderConfig != null ? identityProviderConfig.toBuilder() : null;
        }

        public final void setIdentityProviderConfig(IdentityProviderConfigResponse.BuilderImpl identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig != null ? identityProviderConfig.build() : null;
        }

        @Override
        public final Builder identityProviderConfig(IdentityProviderConfigResponse identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return this;
        }

        @Override
        public DescribeIdentityProviderConfigResponse build() {
            return new DescribeIdentityProviderConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
