/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessEntryRequest extends EksRequest implements
        ToCopyableBuilder<UpdateAccessEntryRequest.Builder, UpdateAccessEntryRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateAccessEntryRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(UpdateAccessEntryRequest::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalArn").build()).build();

    private static final SdkField<List<String>> KUBERNETES_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("kubernetesGroups")
            .getter(getter(UpdateAccessEntryRequest::kubernetesGroups))
            .setter(setter(Builder::kubernetesGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateAccessEntryRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(UpdateAccessEntryRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            PRINCIPAL_ARN_FIELD, KUBERNETES_GROUPS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, USERNAME_FIELD));

    private final String clusterName;

    private final String principalArn;

    private final List<String> kubernetesGroups;

    private final String clientRequestToken;

    private final String username;

    private UpdateAccessEntryRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.kubernetesGroups = builder.kubernetesGroups;
        this.clientRequestToken = builder.clientRequestToken;
        this.username = builder.username;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The ARN of the IAM principal for the <code>AccessEntry</code>.
     * </p>
     * 
     * @return The ARN of the IAM principal for the <code>AccessEntry</code>.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the KubernetesGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKubernetesGroups() {
        return kubernetesGroups != null && !(kubernetesGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value for <code>name</code> that you've specified for <code>kind: Group</code> as a <code>subject</code> in a
     * Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object. Amazon EKS doesn't confirm that
     * the value for <code>name</code> exists in any bindings on your cluster. You can specify one or more names.
     * </p>
     * <p>
     * Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects that you've
     * specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also specified in a
     * binding's <code>roleRef</code>. For more information about creating Kubernetes <code>RoleBinding</code>,
     * <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code> objects, see <a
     * href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the Kubernetes
     * documentation</a>.
     * </p>
     * <p>
     * If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to Kubernetes
     * authorizing the <code>principalArn</code>), you can associate one or more access policies to the access entry
     * using <code>AssociateAccessPolicy</code>. If you associate any access policies, the <code>principalARN</code> has
     * all permissions assigned in the associated access policies and all permissions in any Kubernetes
     * <code>Role</code> or <code>ClusterRole</code> objects that the group names are bound to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKubernetesGroups} method.
     * </p>
     * 
     * @return The value for <code>name</code> that you've specified for <code>kind: Group</code> as a
     *         <code>subject</code> in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object.
     *         Amazon EKS doesn't confirm that the value for <code>name</code> exists in any bindings on your cluster.
     *         You can specify one or more names.</p>
     *         <p>
     *         Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects
     *         that you've specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also
     *         specified in a binding's <code>roleRef</code>. For more information about creating Kubernetes
     *         <code>RoleBinding</code>, <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code>
     *         objects, see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC
     *         Authorization in the Kubernetes documentation</a>.
     *         </p>
     *         <p>
     *         If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to
     *         Kubernetes authorizing the <code>principalArn</code>), you can associate one or more access policies to
     *         the access entry using <code>AssociateAccessPolicy</code>. If you associate any access policies, the
     *         <code>principalARN</code> has all permissions assigned in the associated access policies and all
     *         permissions in any Kubernetes <code>Role</code> or <code>ClusterRole</code> objects that the group names
     *         are bound to.
     */
    public final List<String> kubernetesGroups() {
        return kubernetesGroups;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The username to authenticate to Kubernetes with. We recommend not specifying a username and letting Amazon EKS
     * specify it for you. For more information about the value Amazon EKS specifies for you, or constraints before
     * specifying your own username, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries">Creating
     * access entries</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The username to authenticate to Kubernetes with. We recommend not specifying a username and letting
     *         Amazon EKS specify it for you. For more information about the value Amazon EKS specifies for you, or
     *         constraints before specifying your own username, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries"
     *         >Creating access entries</a> in the <i>Amazon EKS User Guide</i>.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasKubernetesGroups() ? kubernetesGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessEntryRequest)) {
            return false;
        }
        UpdateAccessEntryRequest other = (UpdateAccessEntryRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(principalArn(), other.principalArn())
                && hasKubernetesGroups() == other.hasKubernetesGroups()
                && Objects.equals(kubernetesGroups(), other.kubernetesGroups())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessEntryRequest").add("ClusterName", clusterName()).add("PrincipalArn", principalArn())
                .add("KubernetesGroups", hasKubernetesGroups() ? kubernetesGroups() : null)
                .add("ClientRequestToken", clientRequestToken()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "kubernetesGroups":
            return Optional.ofNullable(clazz.cast(kubernetesGroups()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessEntryRequest, T> g) {
        return obj -> g.apply((UpdateAccessEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccessEntryRequest> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The ARN of the IAM principal for the <code>AccessEntry</code>.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM principal for the <code>AccessEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The value for <code>name</code> that you've specified for <code>kind: Group</code> as a <code>subject</code>
         * in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object. Amazon EKS doesn't
         * confirm that the value for <code>name</code> exists in any bindings on your cluster. You can specify one or
         * more names.
         * </p>
         * <p>
         * Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects that
         * you've specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also specified
         * in a binding's <code>roleRef</code>. For more information about creating Kubernetes <code>RoleBinding</code>,
         * <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code> objects, see <a
         * href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the
         * Kubernetes documentation</a>.
         * </p>
         * <p>
         * If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to Kubernetes
         * authorizing the <code>principalArn</code>), you can associate one or more access policies to the access entry
         * using <code>AssociateAccessPolicy</code>. If you associate any access policies, the <code>principalARN</code>
         * has all permissions assigned in the associated access policies and all permissions in any Kubernetes
         * <code>Role</code> or <code>ClusterRole</code> objects that the group names are bound to.
         * </p>
         * 
         * @param kubernetesGroups
         *        The value for <code>name</code> that you've specified for <code>kind: Group</code> as a
         *        <code>subject</code> in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code>
         *        object. Amazon EKS doesn't confirm that the value for <code>name</code> exists in any bindings on your
         *        cluster. You can specify one or more names.</p>
         *        <p>
         *        Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects
         *        that you've specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is
         *        also specified in a binding's <code>roleRef</code>. For more information about creating Kubernetes
         *        <code>RoleBinding</code>, <code>ClusterRoleBinding</code>, <code>Role</code>, or
         *        <code>ClusterRole</code> objects, see <a
         *        href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the
         *        Kubernetes documentation</a>.
         *        </p>
         *        <p>
         *        If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to
         *        Kubernetes authorizing the <code>principalArn</code>), you can associate one or more access policies
         *        to the access entry using <code>AssociateAccessPolicy</code>. If you associate any access policies,
         *        the <code>principalARN</code> has all permissions assigned in the associated access policies and all
         *        permissions in any Kubernetes <code>Role</code> or <code>ClusterRole</code> objects that the group
         *        names are bound to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesGroups(Collection<String> kubernetesGroups);

        /**
         * <p>
         * The value for <code>name</code> that you've specified for <code>kind: Group</code> as a <code>subject</code>
         * in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object. Amazon EKS doesn't
         * confirm that the value for <code>name</code> exists in any bindings on your cluster. You can specify one or
         * more names.
         * </p>
         * <p>
         * Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects that
         * you've specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also specified
         * in a binding's <code>roleRef</code>. For more information about creating Kubernetes <code>RoleBinding</code>,
         * <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code> objects, see <a
         * href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the
         * Kubernetes documentation</a>.
         * </p>
         * <p>
         * If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to Kubernetes
         * authorizing the <code>principalArn</code>), you can associate one or more access policies to the access entry
         * using <code>AssociateAccessPolicy</code>. If you associate any access policies, the <code>principalARN</code>
         * has all permissions assigned in the associated access policies and all permissions in any Kubernetes
         * <code>Role</code> or <code>ClusterRole</code> objects that the group names are bound to.
         * </p>
         * 
         * @param kubernetesGroups
         *        The value for <code>name</code> that you've specified for <code>kind: Group</code> as a
         *        <code>subject</code> in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code>
         *        object. Amazon EKS doesn't confirm that the value for <code>name</code> exists in any bindings on your
         *        cluster. You can specify one or more names.</p>
         *        <p>
         *        Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects
         *        that you've specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is
         *        also specified in a binding's <code>roleRef</code>. For more information about creating Kubernetes
         *        <code>RoleBinding</code>, <code>ClusterRoleBinding</code>, <code>Role</code>, or
         *        <code>ClusterRole</code> objects, see <a
         *        href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the
         *        Kubernetes documentation</a>.
         *        </p>
         *        <p>
         *        If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to
         *        Kubernetes authorizing the <code>principalArn</code>), you can associate one or more access policies
         *        to the access entry using <code>AssociateAccessPolicy</code>. If you associate any access policies,
         *        the <code>principalARN</code> has all permissions assigned in the associated access policies and all
         *        permissions in any Kubernetes <code>Role</code> or <code>ClusterRole</code> objects that the group
         *        names are bound to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesGroups(String... kubernetesGroups);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The username to authenticate to Kubernetes with. We recommend not specifying a username and letting Amazon
         * EKS specify it for you. For more information about the value Amazon EKS specifies for you, or constraints
         * before specifying your own username, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries">Creating
         * access entries</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param username
         *        The username to authenticate to Kubernetes with. We recommend not specifying a username and letting
         *        Amazon EKS specify it for you. For more information about the value Amazon EKS specifies for you, or
         *        constraints before specifying your own username, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries"
         *        >Creating access entries</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String principalArn;

        private List<String> kubernetesGroups = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessEntryRequest model) {
            super(model);
            clusterName(model.clusterName);
            principalArn(model.principalArn);
            kubernetesGroups(model.kubernetesGroups);
            clientRequestToken(model.clientRequestToken);
            username(model.username);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Collection<String> getKubernetesGroups() {
            if (kubernetesGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return kubernetesGroups;
        }

        public final void setKubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
        }

        @Override
        public final Builder kubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesGroups(String... kubernetesGroups) {
            kubernetesGroups(Arrays.asList(kubernetesGroups));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessEntryRequest build() {
            return new UpdateAccessEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
