/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The offering for an Elastic Inference Accelerator type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceleratorTypeOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<AcceleratorTypeOffering.Builder, AcceleratorTypeOffering> {
    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceleratorType").getter(getter(AcceleratorTypeOffering::acceleratorType))
            .setter(setter(Builder::acceleratorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorType").build()).build();

    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationType").getter(getter(AcceleratorTypeOffering::locationTypeAsString))
            .setter(setter(Builder::locationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(AcceleratorTypeOffering::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPE_FIELD,
            LOCATION_TYPE_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acceleratorType;

    private final String locationType;

    private final String location;

    private AcceleratorTypeOffering(BuilderImpl builder) {
        this.acceleratorType = builder.acceleratorType;
        this.locationType = builder.locationType;
        this.location = builder.location;
    }

    /**
     * <p>
     * The name of the Elastic Inference Accelerator type.
     * </p>
     * 
     * @return The name of the Elastic Inference Accelerator type.
     */
    public final String acceleratorType() {
        return acceleratorType;
    }

    /**
     * <p>
     * The location type for the offering. It can assume the following values: region: defines that the offering is at
     * the regional level. availability-zone: defines that the offering is at the availability zone level.
     * availability-zone-id: defines that the offering is at the availability zone level, defined by the availability
     * zone id.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type for the offering. It can assume the following values: region: defines that the offering
     *         is at the regional level. availability-zone: defines that the offering is at the availability zone level.
     *         availability-zone-id: defines that the offering is at the availability zone level, defined by the
     *         availability zone id.
     * @see LocationType
     */
    public final LocationType locationType() {
        return LocationType.fromValue(locationType);
    }

    /**
     * <p>
     * The location type for the offering. It can assume the following values: region: defines that the offering is at
     * the regional level. availability-zone: defines that the offering is at the availability zone level.
     * availability-zone-id: defines that the offering is at the availability zone level, defined by the availability
     * zone id.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type for the offering. It can assume the following values: region: defines that the offering
     *         is at the regional level. availability-zone: defines that the offering is at the availability zone level.
     *         availability-zone-id: defines that the offering is at the availability zone level, defined by the
     *         availability zone id.
     * @see LocationType
     */
    public final String locationTypeAsString() {
        return locationType;
    }

    /**
     * <p>
     * The location for the offering. It will return either the region, availability zone or availability zone id for
     * the offering depending on the locationType value.
     * </p>
     * 
     * @return The location for the offering. It will return either the region, availability zone or availability zone
     *         id for the offering depending on the locationType value.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorType());
        hashCode = 31 * hashCode + Objects.hashCode(locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorTypeOffering)) {
            return false;
        }
        AcceleratorTypeOffering other = (AcceleratorTypeOffering) obj;
        return Objects.equals(acceleratorType(), other.acceleratorType())
                && Objects.equals(locationTypeAsString(), other.locationTypeAsString())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceleratorTypeOffering").add("AcceleratorType", acceleratorType())
                .add("LocationType", locationTypeAsString()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorType":
            return Optional.ofNullable(clazz.cast(acceleratorType()));
        case "locationType":
            return Optional.ofNullable(clazz.cast(locationTypeAsString()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorTypeOffering, T> g) {
        return obj -> g.apply((AcceleratorTypeOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceleratorTypeOffering> {
        /**
         * <p>
         * The name of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param acceleratorType
         *        The name of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorType(String acceleratorType);

        /**
         * <p>
         * The location type for the offering. It can assume the following values: region: defines that the offering is
         * at the regional level. availability-zone: defines that the offering is at the availability zone level.
         * availability-zone-id: defines that the offering is at the availability zone level, defined by the
         * availability zone id.
         * </p>
         * 
         * @param locationType
         *        The location type for the offering. It can assume the following values: region: defines that the
         *        offering is at the regional level. availability-zone: defines that the offering is at the availability
         *        zone level. availability-zone-id: defines that the offering is at the availability zone level, defined
         *        by the availability zone id.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(String locationType);

        /**
         * <p>
         * The location type for the offering. It can assume the following values: region: defines that the offering is
         * at the regional level. availability-zone: defines that the offering is at the availability zone level.
         * availability-zone-id: defines that the offering is at the availability zone level, defined by the
         * availability zone id.
         * </p>
         * 
         * @param locationType
         *        The location type for the offering. It can assume the following values: region: defines that the
         *        offering is at the regional level. availability-zone: defines that the offering is at the availability
         *        zone level. availability-zone-id: defines that the offering is at the availability zone level, defined
         *        by the availability zone id.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(LocationType locationType);

        /**
         * <p>
         * The location for the offering. It will return either the region, availability zone or availability zone id
         * for the offering depending on the locationType value.
         * </p>
         * 
         * @param location
         *        The location for the offering. It will return either the region, availability zone or availability
         *        zone id for the offering depending on the locationType value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String acceleratorType;

        private String locationType;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorTypeOffering model) {
            acceleratorType(model.acceleratorType);
            locationType(model.locationType);
            location(model.location);
        }

        public final String getAcceleratorType() {
            return acceleratorType;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public final String getLocationType() {
            return locationType;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public AcceleratorTypeOffering build() {
            return new AcceleratorTypeOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
