/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLifecyclePolicyResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<CreateLifecyclePolicyResponse.Builder, CreateLifecyclePolicyResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateLifecyclePolicyResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> LIFECYCLE_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyArn").getter(getter(CreateLifecyclePolicyResponse::lifecyclePolicyArn))
            .setter(setter(Builder::lifecyclePolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            LIFECYCLE_POLICY_ARN_FIELD));

    private final String clientToken;

    private final String lifecyclePolicyArn;

    private CreateLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.lifecyclePolicyArn = builder.lifecyclePolicyArn;
    }

    /**
     * <p>
     * The client token that uniquely identifies the request.
     * </p>
     * 
     * @return The client token that uniquely identifies the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle policy that the request created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle policy that the request created.
     */
    public final String lifecyclePolicyArn() {
        return lifecyclePolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyResponse)) {
            return false;
        }
        CreateLifecyclePolicyResponse other = (CreateLifecyclePolicyResponse) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(lifecyclePolicyArn(), other.lifecyclePolicyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLifecyclePolicyResponse").add("ClientToken", clientToken())
                .add("LifecyclePolicyArn", lifecyclePolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "lifecyclePolicyArn":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLifecyclePolicyResponse> {
        /**
         * <p>
         * The client token that uniquely identifies the request.
         * </p>
         * 
         * @param clientToken
         *        The client token that uniquely identifies the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle policy that the request created.
         * </p>
         * 
         * @param lifecyclePolicyArn
         *        The Amazon Resource Name (ARN) of the lifecycle policy that the request created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyArn(String lifecyclePolicyArn);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String clientToken;

        private String lifecyclePolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyResponse model) {
            super(model);
            clientToken(model.clientToken);
            lifecyclePolicyArn(model.lifecyclePolicyArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLifecyclePolicyArn() {
            return lifecyclePolicyArn;
        }

        public final void setLifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
        }

        @Override
        public final Builder lifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
            return this;
        }

        @Override
        public CreateLifecyclePolicyResponse build() {
            return new CreateLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
