/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The lifecycle policy action that was identified for the impacted resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleExecutionResourceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleExecutionResourceAction.Builder, LifecycleExecutionResourceAction> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LifecycleExecutionResourceAction::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(LifecycleExecutionResourceAction::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String reason;

    private LifecycleExecutionResourceAction(BuilderImpl builder) {
        this.name = builder.name;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of the resource that was identified for a lifecycle policy action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link LifecycleExecutionResourceActionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the resource that was identified for a lifecycle policy action.
     * @see LifecycleExecutionResourceActionName
     */
    public final LifecycleExecutionResourceActionName name() {
        return LifecycleExecutionResourceActionName.fromValue(name);
    }

    /**
     * <p>
     * The name of the resource that was identified for a lifecycle policy action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link LifecycleExecutionResourceActionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the resource that was identified for a lifecycle policy action.
     * @see LifecycleExecutionResourceActionName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The reason why the lifecycle policy action is taken.
     * </p>
     * 
     * @return The reason why the lifecycle policy action is taken.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecutionResourceAction)) {
            return false;
        }
        LifecycleExecutionResourceAction other = (LifecycleExecutionResourceAction) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecycleExecutionResourceAction").add("Name", nameAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecutionResourceAction, T> g) {
        return obj -> g.apply((LifecycleExecutionResourceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleExecutionResourceAction> {
        /**
         * <p>
         * The name of the resource that was identified for a lifecycle policy action.
         * </p>
         * 
         * @param name
         *        The name of the resource that was identified for a lifecycle policy action.
         * @see LifecycleExecutionResourceActionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleExecutionResourceActionName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the resource that was identified for a lifecycle policy action.
         * </p>
         * 
         * @param name
         *        The name of the resource that was identified for a lifecycle policy action.
         * @see LifecycleExecutionResourceActionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleExecutionResourceActionName
         */
        Builder name(LifecycleExecutionResourceActionName name);

        /**
         * <p>
         * The reason why the lifecycle policy action is taken.
         * </p>
         * 
         * @param reason
         *        The reason why the lifecycle policy action is taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecutionResourceAction model) {
            name(model.name);
            reason(model.reason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(LifecycleExecutionResourceActionName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public LifecycleExecutionResourceAction build() {
            return new LifecycleExecutionResourceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
