/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsExportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsExportConfig> {
    private static final SdkField<String> MQTT_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mqttTopic").getter(MetricsExportConfig.getter(MetricsExportConfig::mqttTopic)).setter(MetricsExportConfig.setter(Builder::mqttTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopic").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(MetricsExportConfig.getter(MetricsExportConfig::roleArn)).setter(MetricsExportConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQTT_TOPIC_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mqttTopic;
    private final String roleArn;

    private MetricsExportConfig(BuilderImpl builder) {
        this.mqttTopic = builder.mqttTopic;
        this.roleArn = builder.roleArn;
    }

    public final String mqttTopic() {
        return this.mqttTopic;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mqttTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsExportConfig)) {
            return false;
        }
        MetricsExportConfig other = (MetricsExportConfig)obj;
        return Objects.equals(this.mqttTopic(), other.mqttTopic()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"MetricsExportConfig").add("MqttTopic", (Object)this.mqttTopic()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mqttTopic": {
                return Optional.ofNullable(clazz.cast(this.mqttTopic()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsExportConfig, T> g) {
        return obj -> g.apply((MetricsExportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mqttTopic;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsExportConfig model) {
            this.mqttTopic(model.mqttTopic);
            this.roleArn(model.roleArn);
        }

        public final String getMqttTopic() {
            return this.mqttTopic;
        }

        public final void setMqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
        }

        @Override
        public final Builder mqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public MetricsExportConfig build() {
            return new MetricsExportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsExportConfig> {
        public Builder mqttTopic(String var1);

        public Builder roleArn(String var1);
    }
}

