/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventConfigurationByResourceTypesResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetEventConfigurationByResourceTypesResponse.Builder, GetEventConfigurationByResourceTypesResponse> {
    private static final SdkField<DeviceRegistrationStateResourceTypeEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField
            .<DeviceRegistrationStateResourceTypeEventConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceRegistrationState")
            .getter(getter(GetEventConfigurationByResourceTypesResponse::deviceRegistrationState))
            .setter(setter(Builder::deviceRegistrationState))
            .constructor(DeviceRegistrationStateResourceTypeEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build())
            .build();

    private static final SdkField<ProximityResourceTypeEventConfiguration> PROXIMITY_FIELD = SdkField
            .<ProximityResourceTypeEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("Proximity")
            .getter(getter(GetEventConfigurationByResourceTypesResponse::proximity)).setter(setter(Builder::proximity))
            .constructor(ProximityResourceTypeEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()).build();

    private static final SdkField<JoinResourceTypeEventConfiguration> JOIN_FIELD = SdkField
            .<JoinResourceTypeEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("Join")
            .getter(getter(GetEventConfigurationByResourceTypesResponse::join)).setter(setter(Builder::join))
            .constructor(JoinResourceTypeEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Join").build()).build();

    private static final SdkField<ConnectionStatusResourceTypeEventConfiguration> CONNECTION_STATUS_FIELD = SdkField
            .<ConnectionStatusResourceTypeEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConnectionStatus")
            .getter(getter(GetEventConfigurationByResourceTypesResponse::connectionStatus))
            .setter(setter(Builder::connectionStatus)).constructor(ConnectionStatusResourceTypeEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<MessageDeliveryStatusResourceTypeEventConfiguration> MESSAGE_DELIVERY_STATUS_FIELD = SdkField
            .<MessageDeliveryStatusResourceTypeEventConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("MessageDeliveryStatus")
            .getter(getter(GetEventConfigurationByResourceTypesResponse::messageDeliveryStatus))
            .setter(setter(Builder::messageDeliveryStatus))
            .constructor(MessageDeliveryStatusResourceTypeEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeliveryStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD, JOIN_FIELD,
                    CONNECTION_STATUS_FIELD, MESSAGE_DELIVERY_STATUS_FIELD));

    private final DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState;

    private final ProximityResourceTypeEventConfiguration proximity;

    private final JoinResourceTypeEventConfiguration join;

    private final ConnectionStatusResourceTypeEventConfiguration connectionStatus;

    private final MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus;

    private GetEventConfigurationByResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
        this.join = builder.join;
        this.connectionStatus = builder.connectionStatus;
        this.messageDeliveryStatus = builder.messageDeliveryStatus;
    }

    /**
     * <p>
     * Resource type event configuration for the device registration state event.
     * </p>
     * 
     * @return Resource type event configuration for the device registration state event.
     */
    public final DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState() {
        return deviceRegistrationState;
    }

    /**
     * <p>
     * Resource type event configuration for the proximity event.
     * </p>
     * 
     * @return Resource type event configuration for the proximity event.
     */
    public final ProximityResourceTypeEventConfiguration proximity() {
        return proximity;
    }

    /**
     * <p>
     * Resource type event configuration for the join event.
     * </p>
     * 
     * @return Resource type event configuration for the join event.
     */
    public final JoinResourceTypeEventConfiguration join() {
        return join;
    }

    /**
     * <p>
     * Resource type event configuration for the connection status event.
     * </p>
     * 
     * @return Resource type event configuration for the connection status event.
     */
    public final ConnectionStatusResourceTypeEventConfiguration connectionStatus() {
        return connectionStatus;
    }

    /**
     * <p>
     * Resource type event configuration object for the message delivery status event.
     * </p>
     * 
     * @return Resource type event configuration object for the message delivery status event.
     */
    public final MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus() {
        return messageDeliveryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(proximity());
        hashCode = 31 * hashCode + Objects.hashCode(join());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(messageDeliveryStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventConfigurationByResourceTypesResponse)) {
            return false;
        }
        GetEventConfigurationByResourceTypesResponse other = (GetEventConfigurationByResourceTypesResponse) obj;
        return Objects.equals(deviceRegistrationState(), other.deviceRegistrationState())
                && Objects.equals(proximity(), other.proximity()) && Objects.equals(join(), other.join())
                && Objects.equals(connectionStatus(), other.connectionStatus())
                && Objects.equals(messageDeliveryStatus(), other.messageDeliveryStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventConfigurationByResourceTypesResponse")
                .add("DeviceRegistrationState", deviceRegistrationState()).add("Proximity", proximity()).add("Join", join())
                .add("ConnectionStatus", connectionStatus()).add("MessageDeliveryStatus", messageDeliveryStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceRegistrationState":
            return Optional.ofNullable(clazz.cast(deviceRegistrationState()));
        case "Proximity":
            return Optional.ofNullable(clazz.cast(proximity()));
        case "Join":
            return Optional.ofNullable(clazz.cast(join()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatus()));
        case "MessageDeliveryStatus":
            return Optional.ofNullable(clazz.cast(messageDeliveryStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventConfigurationByResourceTypesResponse, T> g) {
        return obj -> g.apply((GetEventConfigurationByResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEventConfigurationByResourceTypesResponse> {
        /**
         * <p>
         * Resource type event configuration for the device registration state event.
         * </p>
         * 
         * @param deviceRegistrationState
         *        Resource type event configuration for the device registration state event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState);

        /**
         * <p>
         * Resource type event configuration for the device registration state event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeviceRegistrationStateResourceTypeEventConfiguration.Builder} avoiding the need to create one
         * manually via {@link DeviceRegistrationStateResourceTypeEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link DeviceRegistrationStateResourceTypeEventConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration)}.
         * 
         * @param deviceRegistrationState
         *        a consumer that will call methods on
         *        {@link DeviceRegistrationStateResourceTypeEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration)
         */
        default Builder deviceRegistrationState(
                Consumer<DeviceRegistrationStateResourceTypeEventConfiguration.Builder> deviceRegistrationState) {
            return deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration.builder()
                    .applyMutation(deviceRegistrationState).build());
        }

        /**
         * <p>
         * Resource type event configuration for the proximity event.
         * </p>
         * 
         * @param proximity
         *        Resource type event configuration for the proximity event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proximity(ProximityResourceTypeEventConfiguration proximity);

        /**
         * <p>
         * Resource type event configuration for the proximity event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProximityResourceTypeEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProximityResourceTypeEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProximityResourceTypeEventConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #proximity(ProximityResourceTypeEventConfiguration)}.
         * 
         * @param proximity
         *        a consumer that will call methods on {@link ProximityResourceTypeEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proximity(ProximityResourceTypeEventConfiguration)
         */
        default Builder proximity(Consumer<ProximityResourceTypeEventConfiguration.Builder> proximity) {
            return proximity(ProximityResourceTypeEventConfiguration.builder().applyMutation(proximity).build());
        }

        /**
         * <p>
         * Resource type event configuration for the join event.
         * </p>
         * 
         * @param join
         *        Resource type event configuration for the join event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder join(JoinResourceTypeEventConfiguration join);

        /**
         * <p>
         * Resource type event configuration for the join event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link JoinResourceTypeEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link JoinResourceTypeEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JoinResourceTypeEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #join(JoinResourceTypeEventConfiguration)}.
         * 
         * @param join
         *        a consumer that will call methods on {@link JoinResourceTypeEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #join(JoinResourceTypeEventConfiguration)
         */
        default Builder join(Consumer<JoinResourceTypeEventConfiguration.Builder> join) {
            return join(JoinResourceTypeEventConfiguration.builder().applyMutation(join).build());
        }

        /**
         * <p>
         * Resource type event configuration for the connection status event.
         * </p>
         * 
         * @param connectionStatus
         *        Resource type event configuration for the connection status event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatus(ConnectionStatusResourceTypeEventConfiguration connectionStatus);

        /**
         * <p>
         * Resource type event configuration for the connection status event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionStatusResourceTypeEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link ConnectionStatusResourceTypeEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionStatusResourceTypeEventConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #connectionStatus(ConnectionStatusResourceTypeEventConfiguration)}.
         * 
         * @param connectionStatus
         *        a consumer that will call methods on {@link ConnectionStatusResourceTypeEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatus(ConnectionStatusResourceTypeEventConfiguration)
         */
        default Builder connectionStatus(Consumer<ConnectionStatusResourceTypeEventConfiguration.Builder> connectionStatus) {
            return connectionStatus(ConnectionStatusResourceTypeEventConfiguration.builder().applyMutation(connectionStatus)
                    .build());
        }

        /**
         * <p>
         * Resource type event configuration object for the message delivery status event.
         * </p>
         * 
         * @param messageDeliveryStatus
         *        Resource type event configuration object for the message delivery status event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus);

        /**
         * <p>
         * Resource type event configuration object for the message delivery status event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageDeliveryStatusResourceTypeEventConfiguration.Builder} avoiding the need to create one manually
         * via {@link MessageDeliveryStatusResourceTypeEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link MessageDeliveryStatusResourceTypeEventConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration)}.
         * 
         * @param messageDeliveryStatus
         *        a consumer that will call methods on
         *        {@link MessageDeliveryStatusResourceTypeEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration)
         */
        default Builder messageDeliveryStatus(
                Consumer<MessageDeliveryStatusResourceTypeEventConfiguration.Builder> messageDeliveryStatus) {
            return messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration.builder()
                    .applyMutation(messageDeliveryStatus).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState;

        private ProximityResourceTypeEventConfiguration proximity;

        private JoinResourceTypeEventConfiguration join;

        private ConnectionStatusResourceTypeEventConfiguration connectionStatus;

        private MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventConfigurationByResourceTypesResponse model) {
            super(model);
            deviceRegistrationState(model.deviceRegistrationState);
            proximity(model.proximity);
            join(model.join);
            connectionStatus(model.connectionStatus);
            messageDeliveryStatus(model.messageDeliveryStatus);
        }

        public final DeviceRegistrationStateResourceTypeEventConfiguration.Builder getDeviceRegistrationState() {
            return deviceRegistrationState != null ? deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(
                DeviceRegistrationStateResourceTypeEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        public final Builder deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityResourceTypeEventConfiguration.Builder getProximity() {
            return proximity != null ? proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityResourceTypeEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        public final Builder proximity(ProximityResourceTypeEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        public final JoinResourceTypeEventConfiguration.Builder getJoin() {
            return join != null ? join.toBuilder() : null;
        }

        public final void setJoin(JoinResourceTypeEventConfiguration.BuilderImpl join) {
            this.join = join != null ? join.build() : null;
        }

        @Override
        public final Builder join(JoinResourceTypeEventConfiguration join) {
            this.join = join;
            return this;
        }

        public final ConnectionStatusResourceTypeEventConfiguration.Builder getConnectionStatus() {
            return connectionStatus != null ? connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(ConnectionStatusResourceTypeEventConfiguration.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatusResourceTypeEventConfiguration connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final MessageDeliveryStatusResourceTypeEventConfiguration.Builder getMessageDeliveryStatus() {
            return messageDeliveryStatus != null ? messageDeliveryStatus.toBuilder() : null;
        }

        public final void setMessageDeliveryStatus(
                MessageDeliveryStatusResourceTypeEventConfiguration.BuilderImpl messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus != null ? messageDeliveryStatus.build() : null;
        }

        @Override
        public final Builder messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus;
            return this;
        }

        @Override
        public GetEventConfigurationByResourceTypesResponse build() {
            return new GetEventConfigurationByResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
