/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetMetricsResponse.Builder, GetMetricsResponse> {
    private static final SdkField<List<SummaryMetricQueryResult>> SUMMARY_METRIC_QUERY_RESULTS_FIELD = SdkField
            .<List<SummaryMetricQueryResult>> builder(MarshallingType.LIST)
            .memberName("SummaryMetricQueryResults")
            .getter(getter(GetMetricsResponse::summaryMetricQueryResults))
            .setter(setter(Builder::summaryMetricQueryResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryMetricQueryResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummaryMetricQueryResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummaryMetricQueryResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUMMARY_METRIC_QUERY_RESULTS_FIELD));

    private final List<SummaryMetricQueryResult> summaryMetricQueryResults;

    private GetMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.summaryMetricQueryResults = builder.summaryMetricQueryResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SummaryMetricQueryResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSummaryMetricQueryResults() {
        return summaryMetricQueryResults != null && !(summaryMetricQueryResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of summary metrics that were retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaryMetricQueryResults} method.
     * </p>
     * 
     * @return The list of summary metrics that were retrieved.
     */
    public final List<SummaryMetricQueryResult> summaryMetricQueryResults() {
        return summaryMetricQueryResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaryMetricQueryResults() ? summaryMetricQueryResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricsResponse)) {
            return false;
        }
        GetMetricsResponse other = (GetMetricsResponse) obj;
        return hasSummaryMetricQueryResults() == other.hasSummaryMetricQueryResults()
                && Objects.equals(summaryMetricQueryResults(), other.summaryMetricQueryResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricsResponse")
                .add("SummaryMetricQueryResults", hasSummaryMetricQueryResults() ? summaryMetricQueryResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SummaryMetricQueryResults":
            return Optional.ofNullable(clazz.cast(summaryMetricQueryResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricsResponse, T> g) {
        return obj -> g.apply((GetMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricsResponse> {
        /**
         * <p>
         * The list of summary metrics that were retrieved.
         * </p>
         * 
         * @param summaryMetricQueryResults
         *        The list of summary metrics that were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMetricQueryResults(Collection<SummaryMetricQueryResult> summaryMetricQueryResults);

        /**
         * <p>
         * The list of summary metrics that were retrieved.
         * </p>
         * 
         * @param summaryMetricQueryResults
         *        The list of summary metrics that were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMetricQueryResults(SummaryMetricQueryResult... summaryMetricQueryResults);

        /**
         * <p>
         * The list of summary metrics that were retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.SummaryMetricQueryResult.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.SummaryMetricQueryResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.SummaryMetricQueryResult.Builder#build()} is called
         * immediately and its result is passed to {@link #summaryMetricQueryResults(List<SummaryMetricQueryResult>)}.
         * 
         * @param summaryMetricQueryResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.SummaryMetricQueryResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryMetricQueryResults(java.util.Collection<SummaryMetricQueryResult>)
         */
        Builder summaryMetricQueryResults(Consumer<SummaryMetricQueryResult.Builder>... summaryMetricQueryResults);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private List<SummaryMetricQueryResult> summaryMetricQueryResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricsResponse model) {
            super(model);
            summaryMetricQueryResults(model.summaryMetricQueryResults);
        }

        public final List<SummaryMetricQueryResult.Builder> getSummaryMetricQueryResults() {
            List<SummaryMetricQueryResult.Builder> result = SummaryMetricQueryResultsCopier
                    .copyToBuilder(this.summaryMetricQueryResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryMetricQueryResults(Collection<SummaryMetricQueryResult.BuilderImpl> summaryMetricQueryResults) {
            this.summaryMetricQueryResults = SummaryMetricQueryResultsCopier.copyFromBuilder(summaryMetricQueryResults);
        }

        @Override
        public final Builder summaryMetricQueryResults(Collection<SummaryMetricQueryResult> summaryMetricQueryResults) {
            this.summaryMetricQueryResults = SummaryMetricQueryResultsCopier.copy(summaryMetricQueryResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryMetricQueryResults(SummaryMetricQueryResult... summaryMetricQueryResults) {
            summaryMetricQueryResults(Arrays.asList(summaryMetricQueryResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryMetricQueryResults(Consumer<SummaryMetricQueryResult.Builder>... summaryMetricQueryResults) {
            summaryMetricQueryResults(Stream.of(summaryMetricQueryResults)
                    .map(c -> SummaryMetricQueryResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMetricsResponse build() {
            return new GetMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
