/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Global identity information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalIdentity implements SdkPojo, Serializable, ToCopyableBuilder<GlobalIdentity.Builder, GlobalIdentity> {
    private static final SdkField<Integer> LAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lac")
            .getter(getter(GlobalIdentity::lac)).setter(setter(Builder::lac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()).build();

    private static final SdkField<Integer> GERAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeranCid").getter(getter(GlobalIdentity::geranCid)).setter(setter(Builder::geranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeranCid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAC_FIELD, GERAN_CID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer lac;

    private final Integer geranCid;

    private GlobalIdentity(BuilderImpl builder) {
        this.lac = builder.lac;
        this.geranCid = builder.geranCid;
    }

    /**
     * <p>
     * Location area code of the global identity.
     * </p>
     * 
     * @return Location area code of the global identity.
     */
    public final Integer lac() {
        return lac;
    }

    /**
     * <p>
     * GERAN (GSM EDGE Radio Access Network) cell global identifier.
     * </p>
     * 
     * @return GERAN (GSM EDGE Radio Access Network) cell global identifier.
     */
    public final Integer geranCid() {
        return geranCid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lac());
        hashCode = 31 * hashCode + Objects.hashCode(geranCid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalIdentity)) {
            return false;
        }
        GlobalIdentity other = (GlobalIdentity) obj;
        return Objects.equals(lac(), other.lac()) && Objects.equals(geranCid(), other.geranCid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalIdentity").add("Lac", lac()).add("GeranCid", geranCid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lac":
            return Optional.ofNullable(clazz.cast(lac()));
        case "GeranCid":
            return Optional.ofNullable(clazz.cast(geranCid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalIdentity, T> g) {
        return obj -> g.apply((GlobalIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalIdentity> {
        /**
         * <p>
         * Location area code of the global identity.
         * </p>
         * 
         * @param lac
         *        Location area code of the global identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lac(Integer lac);

        /**
         * <p>
         * GERAN (GSM EDGE Radio Access Network) cell global identifier.
         * </p>
         * 
         * @param geranCid
         *        GERAN (GSM EDGE Radio Access Network) cell global identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geranCid(Integer geranCid);
    }

    static final class BuilderImpl implements Builder {
        private Integer lac;

        private Integer geranCid;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalIdentity model) {
            lac(model.lac);
            geranCid(model.geranCid);
        }

        public final Integer getLac() {
            return lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getGeranCid() {
            return geranCid;
        }

        public final void setGeranCid(Integer geranCid) {
            this.geranCid = geranCid;
        }

        @Override
        public final Builder geranCid(Integer geranCid) {
            this.geranCid = geranCid;
            return this;
        }

        @Override
        public GlobalIdentity build() {
            return new GlobalIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
