/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN object for create functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANDevice implements SdkPojo, Serializable, ToCopyableBuilder<LoRaWANDevice.Builder, LoRaWANDevice> {
    private static final SdkField<String> DEV_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DevEui")
            .getter(getter(LoRaWANDevice::devEui)).setter(setter(Builder::devEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEui").build()).build();

    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(LoRaWANDevice::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()).build();

    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProfileId").getter(getter(LoRaWANDevice::serviceProfileId))
            .setter(setter(Builder::serviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()).build();

    private static final SdkField<OtaaV1_1> OTAA_V1_1_FIELD = SdkField.<OtaaV1_1> builder(MarshallingType.SDK_POJO)
            .memberName("OtaaV1_1").getter(getter(LoRaWANDevice::otaaV1_1)).setter(setter(Builder::otaaV1_1))
            .constructor(OtaaV1_1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaaV1_1").build()).build();

    private static final SdkField<OtaaV1_0_x> OTAA_V1_0_X_FIELD = SdkField.<OtaaV1_0_x> builder(MarshallingType.SDK_POJO)
            .memberName("OtaaV1_0_x").getter(getter(LoRaWANDevice::otaaV1_0_x)).setter(setter(Builder::otaaV1_0_x))
            .constructor(OtaaV1_0_x::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaaV1_0_x").build()).build();

    private static final SdkField<AbpV1_1> ABP_V1_1_FIELD = SdkField.<AbpV1_1> builder(MarshallingType.SDK_POJO)
            .memberName("AbpV1_1").getter(getter(LoRaWANDevice::abpV1_1)).setter(setter(Builder::abpV1_1))
            .constructor(AbpV1_1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_1").build()).build();

    private static final SdkField<AbpV1_0_x> ABP_V1_0_X_FIELD = SdkField.<AbpV1_0_x> builder(MarshallingType.SDK_POJO)
            .memberName("AbpV1_0_x").getter(getter(LoRaWANDevice::abpV1_0_x)).setter(setter(Builder::abpV1_0_x))
            .constructor(AbpV1_0_x::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_0_x").build()).build();

    private static final SdkField<FPorts> F_PORTS_FIELD = SdkField.<FPorts> builder(MarshallingType.SDK_POJO)
            .memberName("FPorts").getter(getter(LoRaWANDevice::fPorts)).setter(setter(Builder::fPorts))
            .constructor(FPorts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPorts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_EUI_FIELD,
            DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD, OTAA_V1_1_FIELD, OTAA_V1_0_X_FIELD, ABP_V1_1_FIELD,
            ABP_V1_0_X_FIELD, F_PORTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String devEui;

    private final String deviceProfileId;

    private final String serviceProfileId;

    private final OtaaV1_1 otaaV1_1;

    private final OtaaV1_0_x otaaV1_0_x;

    private final AbpV1_1 abpV1_1;

    private final AbpV1_0_x abpV1_0_x;

    private final FPorts fPorts;

    private LoRaWANDevice(BuilderImpl builder) {
        this.devEui = builder.devEui;
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.otaaV1_1 = builder.otaaV1_1;
        this.otaaV1_0_x = builder.otaaV1_0_x;
        this.abpV1_1 = builder.abpV1_1;
        this.abpV1_0_x = builder.abpV1_0_x;
        this.fPorts = builder.fPorts;
    }

    /**
     * <p>
     * The DevEUI value.
     * </p>
     * 
     * @return The DevEUI value.
     */
    public final String devEui() {
        return devEui;
    }

    /**
     * <p>
     * The ID of the device profile for the new wireless device.
     * </p>
     * 
     * @return The ID of the device profile for the new wireless device.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * The ID of the service profile.
     * </p>
     * 
     * @return The ID of the service profile.
     */
    public final String serviceProfileId() {
        return serviceProfileId;
    }

    /**
     * <p>
     * OTAA device object for v1.1 for create APIs
     * </p>
     * 
     * @return OTAA device object for v1.1 for create APIs
     */
    public final OtaaV1_1 otaaV1_1() {
        return otaaV1_1;
    }

    /**
     * <p>
     * OTAA device object for create APIs for v1.0.x
     * </p>
     * 
     * @return OTAA device object for create APIs for v1.0.x
     */
    public final OtaaV1_0_x otaaV1_0_x() {
        return otaaV1_0_x;
    }

    /**
     * <p>
     * ABP device object for create APIs for v1.1
     * </p>
     * 
     * @return ABP device object for create APIs for v1.1
     */
    public final AbpV1_1 abpV1_1() {
        return abpV1_1;
    }

    /**
     * <p>
     * LoRaWAN object for create APIs
     * </p>
     * 
     * @return LoRaWAN object for create APIs
     */
    public final AbpV1_0_x abpV1_0_x() {
        return abpV1_0_x;
    }

    /**
     * Returns the value of the FPorts property for this object.
     * 
     * @return The value of the FPorts property for this object.
     */
    public final FPorts fPorts() {
        return fPorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devEui());
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(otaaV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(otaaV1_0_x());
        hashCode = 31 * hashCode + Objects.hashCode(abpV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(abpV1_0_x());
        hashCode = 31 * hashCode + Objects.hashCode(fPorts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDevice)) {
            return false;
        }
        LoRaWANDevice other = (LoRaWANDevice) obj;
        return Objects.equals(devEui(), other.devEui()) && Objects.equals(deviceProfileId(), other.deviceProfileId())
                && Objects.equals(serviceProfileId(), other.serviceProfileId()) && Objects.equals(otaaV1_1(), other.otaaV1_1())
                && Objects.equals(otaaV1_0_x(), other.otaaV1_0_x()) && Objects.equals(abpV1_1(), other.abpV1_1())
                && Objects.equals(abpV1_0_x(), other.abpV1_0_x()) && Objects.equals(fPorts(), other.fPorts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANDevice").add("DevEui", devEui()).add("DeviceProfileId", deviceProfileId())
                .add("ServiceProfileId", serviceProfileId()).add("OtaaV1_1", otaaV1_1()).add("OtaaV1_0_x", otaaV1_0_x())
                .add("AbpV1_1", abpV1_1()).add("AbpV1_0_x", abpV1_0_x()).add("FPorts", fPorts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEui":
            return Optional.ofNullable(clazz.cast(devEui()));
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "ServiceProfileId":
            return Optional.ofNullable(clazz.cast(serviceProfileId()));
        case "OtaaV1_1":
            return Optional.ofNullable(clazz.cast(otaaV1_1()));
        case "OtaaV1_0_x":
            return Optional.ofNullable(clazz.cast(otaaV1_0_x()));
        case "AbpV1_1":
            return Optional.ofNullable(clazz.cast(abpV1_1()));
        case "AbpV1_0_x":
            return Optional.ofNullable(clazz.cast(abpV1_0_x()));
        case "FPorts":
            return Optional.ofNullable(clazz.cast(fPorts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDevice, T> g) {
        return obj -> g.apply((LoRaWANDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANDevice> {
        /**
         * <p>
         * The DevEUI value.
         * </p>
         * 
         * @param devEui
         *        The DevEUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEui(String devEui);

        /**
         * <p>
         * The ID of the device profile for the new wireless device.
         * </p>
         * 
         * @param deviceProfileId
         *        The ID of the device profile for the new wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * The ID of the service profile.
         * </p>
         * 
         * @param serviceProfileId
         *        The ID of the service profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProfileId(String serviceProfileId);

        /**
         * <p>
         * OTAA device object for v1.1 for create APIs
         * </p>
         * 
         * @param otaaV1_1
         *        OTAA device object for v1.1 for create APIs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaaV1_1(OtaaV1_1 otaaV1_1);

        /**
         * <p>
         * OTAA device object for v1.1 for create APIs
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaaV1_1.Builder} avoiding the need to
         * create one manually via {@link OtaaV1_1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaaV1_1.Builder#build()} is called immediately and its result is
         * passed to {@link #otaaV1_1(OtaaV1_1)}.
         * 
         * @param otaaV1_1
         *        a consumer that will call methods on {@link OtaaV1_1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaaV1_1(OtaaV1_1)
         */
        default Builder otaaV1_1(Consumer<OtaaV1_1.Builder> otaaV1_1) {
            return otaaV1_1(OtaaV1_1.builder().applyMutation(otaaV1_1).build());
        }

        /**
         * <p>
         * OTAA device object for create APIs for v1.0.x
         * </p>
         * 
         * @param otaaV1_0_x
         *        OTAA device object for create APIs for v1.0.x
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaaV1_0_x(OtaaV1_0_x otaaV1_0_x);

        /**
         * <p>
         * OTAA device object for create APIs for v1.0.x
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaaV1_0_x.Builder} avoiding the need to
         * create one manually via {@link OtaaV1_0_x#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaaV1_0_x.Builder#build()} is called immediately and its result
         * is passed to {@link #otaaV1_0_x(OtaaV1_0_x)}.
         * 
         * @param otaaV1_0_x
         *        a consumer that will call methods on {@link OtaaV1_0_x.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaaV1_0_x(OtaaV1_0_x)
         */
        default Builder otaaV1_0_x(Consumer<OtaaV1_0_x.Builder> otaaV1_0_x) {
            return otaaV1_0_x(OtaaV1_0_x.builder().applyMutation(otaaV1_0_x).build());
        }

        /**
         * <p>
         * ABP device object for create APIs for v1.1
         * </p>
         * 
         * @param abpV1_1
         *        ABP device object for create APIs for v1.1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abpV1_1(AbpV1_1 abpV1_1);

        /**
         * <p>
         * ABP device object for create APIs for v1.1
         * </p>
         * This is a convenience method that creates an instance of the {@link AbpV1_1.Builder} avoiding the need to
         * create one manually via {@link AbpV1_1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbpV1_1.Builder#build()} is called immediately and its result is
         * passed to {@link #abpV1_1(AbpV1_1)}.
         * 
         * @param abpV1_1
         *        a consumer that will call methods on {@link AbpV1_1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abpV1_1(AbpV1_1)
         */
        default Builder abpV1_1(Consumer<AbpV1_1.Builder> abpV1_1) {
            return abpV1_1(AbpV1_1.builder().applyMutation(abpV1_1).build());
        }

        /**
         * <p>
         * LoRaWAN object for create APIs
         * </p>
         * 
         * @param abpV1_0_x
         *        LoRaWAN object for create APIs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abpV1_0_x(AbpV1_0_x abpV1_0_x);

        /**
         * <p>
         * LoRaWAN object for create APIs
         * </p>
         * This is a convenience method that creates an instance of the {@link AbpV1_0_x.Builder} avoiding the need to
         * create one manually via {@link AbpV1_0_x#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbpV1_0_x.Builder#build()} is called immediately and its result
         * is passed to {@link #abpV1_0_x(AbpV1_0_x)}.
         * 
         * @param abpV1_0_x
         *        a consumer that will call methods on {@link AbpV1_0_x.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abpV1_0_x(AbpV1_0_x)
         */
        default Builder abpV1_0_x(Consumer<AbpV1_0_x.Builder> abpV1_0_x) {
            return abpV1_0_x(AbpV1_0_x.builder().applyMutation(abpV1_0_x).build());
        }

        /**
         * Sets the value of the FPorts property for this object.
         *
         * @param fPorts
         *        The new value for the FPorts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPorts(FPorts fPorts);

        /**
         * Sets the value of the FPorts property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FPorts.Builder} avoiding the need to
         * create one manually via {@link FPorts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FPorts.Builder#build()} is called immediately and its result is
         * passed to {@link #fPorts(FPorts)}.
         * 
         * @param fPorts
         *        a consumer that will call methods on {@link FPorts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fPorts(FPorts)
         */
        default Builder fPorts(Consumer<FPorts.Builder> fPorts) {
            return fPorts(FPorts.builder().applyMutation(fPorts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String devEui;

        private String deviceProfileId;

        private String serviceProfileId;

        private OtaaV1_1 otaaV1_1;

        private OtaaV1_0_x otaaV1_0_x;

        private AbpV1_1 abpV1_1;

        private AbpV1_0_x abpV1_0_x;

        private FPorts fPorts;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDevice model) {
            devEui(model.devEui);
            deviceProfileId(model.deviceProfileId);
            serviceProfileId(model.serviceProfileId);
            otaaV1_1(model.otaaV1_1);
            otaaV1_0_x(model.otaaV1_0_x);
            abpV1_1(model.abpV1_1);
            abpV1_0_x(model.abpV1_0_x);
            fPorts(model.fPorts);
        }

        public final String getDevEui() {
            return devEui;
        }

        public final void setDevEui(String devEui) {
            this.devEui = devEui;
        }

        @Override
        public final Builder devEui(String devEui) {
            this.devEui = devEui;
            return this;
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final OtaaV1_1.Builder getOtaaV1_1() {
            return otaaV1_1 != null ? otaaV1_1.toBuilder() : null;
        }

        public final void setOtaaV1_1(OtaaV1_1.BuilderImpl otaaV1_1) {
            this.otaaV1_1 = otaaV1_1 != null ? otaaV1_1.build() : null;
        }

        @Override
        public final Builder otaaV1_1(OtaaV1_1 otaaV1_1) {
            this.otaaV1_1 = otaaV1_1;
            return this;
        }

        public final OtaaV1_0_x.Builder getOtaaV1_0_x() {
            return otaaV1_0_x != null ? otaaV1_0_x.toBuilder() : null;
        }

        public final void setOtaaV1_0_x(OtaaV1_0_x.BuilderImpl otaaV1_0_x) {
            this.otaaV1_0_x = otaaV1_0_x != null ? otaaV1_0_x.build() : null;
        }

        @Override
        public final Builder otaaV1_0_x(OtaaV1_0_x otaaV1_0_x) {
            this.otaaV1_0_x = otaaV1_0_x;
            return this;
        }

        public final AbpV1_1.Builder getAbpV1_1() {
            return abpV1_1 != null ? abpV1_1.toBuilder() : null;
        }

        public final void setAbpV1_1(AbpV1_1.BuilderImpl abpV1_1) {
            this.abpV1_1 = abpV1_1 != null ? abpV1_1.build() : null;
        }

        @Override
        public final Builder abpV1_1(AbpV1_1 abpV1_1) {
            this.abpV1_1 = abpV1_1;
            return this;
        }

        public final AbpV1_0_x.Builder getAbpV1_0_x() {
            return abpV1_0_x != null ? abpV1_0_x.toBuilder() : null;
        }

        public final void setAbpV1_0_x(AbpV1_0_x.BuilderImpl abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x != null ? abpV1_0_x.build() : null;
        }

        @Override
        public final Builder abpV1_0_x(AbpV1_0_x abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x;
            return this;
        }

        public final FPorts.Builder getFPorts() {
            return fPorts != null ? fPorts.toBuilder() : null;
        }

        public final void setFPorts(FPorts.BuilderImpl fPorts) {
            this.fPorts = fPorts != null ? fPorts.build() : null;
        }

        @Override
        public final Builder fPorts(FPorts fPorts) {
            this.fPorts = fPorts;
            return this;
        }

        @Override
        public LoRaWANDevice build() {
            return new LoRaWANDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
