/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The LoRaWAN information that is to be used with the multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANMulticast implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANMulticast.Builder, LoRaWANMulticast> {
    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANMulticast::rfRegionAsString)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final SdkField<String> DL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DlClass").getter(getter(LoRaWANMulticast::dlClassAsString)).setter(setter(Builder::dlClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RF_REGION_FIELD,
            DL_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rfRegion;

    private final String dlClass;

    private LoRaWANMulticast(BuilderImpl builder) {
        this.rfRegion = builder.rfRegion;
        this.dlClass = builder.dlClass;
    }

    /**
     * Returns the value of the RfRegion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rfRegion} will
     * return {@link SupportedRfRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rfRegionAsString}.
     * </p>
     * 
     * @return The value of the RfRegion property for this object.
     * @see SupportedRfRegion
     */
    public final SupportedRfRegion rfRegion() {
        return SupportedRfRegion.fromValue(rfRegion);
    }

    /**
     * Returns the value of the RfRegion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rfRegion} will
     * return {@link SupportedRfRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rfRegionAsString}.
     * </p>
     * 
     * @return The value of the RfRegion property for this object.
     * @see SupportedRfRegion
     */
    public final String rfRegionAsString() {
        return rfRegion;
    }

    /**
     * Returns the value of the DlClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dlClass} will
     * return {@link DlClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dlClassAsString}.
     * </p>
     * 
     * @return The value of the DlClass property for this object.
     * @see DlClass
     */
    public final DlClass dlClass() {
        return DlClass.fromValue(dlClass);
    }

    /**
     * Returns the value of the DlClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dlClass} will
     * return {@link DlClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dlClassAsString}.
     * </p>
     * 
     * @return The value of the DlClass property for this object.
     * @see DlClass
     */
    public final String dlClassAsString() {
        return dlClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rfRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dlClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticast)) {
            return false;
        }
        LoRaWANMulticast other = (LoRaWANMulticast) obj;
        return Objects.equals(rfRegionAsString(), other.rfRegionAsString())
                && Objects.equals(dlClassAsString(), other.dlClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANMulticast").add("RfRegion", rfRegionAsString()).add("DlClass", dlClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegionAsString()));
        case "DlClass":
            return Optional.ofNullable(clazz.cast(dlClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticast, T> g) {
        return obj -> g.apply((LoRaWANMulticast) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANMulticast> {
        /**
         * Sets the value of the RfRegion property for this object.
         *
         * @param rfRegion
         *        The new value for the RfRegion property for this object.
         * @see SupportedRfRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedRfRegion
         */
        Builder rfRegion(String rfRegion);

        /**
         * Sets the value of the RfRegion property for this object.
         *
         * @param rfRegion
         *        The new value for the RfRegion property for this object.
         * @see SupportedRfRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedRfRegion
         */
        Builder rfRegion(SupportedRfRegion rfRegion);

        /**
         * Sets the value of the DlClass property for this object.
         *
         * @param dlClass
         *        The new value for the DlClass property for this object.
         * @see DlClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DlClass
         */
        Builder dlClass(String dlClass);

        /**
         * Sets the value of the DlClass property for this object.
         *
         * @param dlClass
         *        The new value for the DlClass property for this object.
         * @see DlClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DlClass
         */
        Builder dlClass(DlClass dlClass);
    }

    static final class BuilderImpl implements Builder {
        private String rfRegion;

        private String dlClass;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticast model) {
            rfRegion(model.rfRegion);
            dlClass(model.dlClass);
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        @Override
        public final Builder rfRegion(SupportedRfRegion rfRegion) {
            this.rfRegion(rfRegion == null ? null : rfRegion.toString());
            return this;
        }

        public final String getDlClass() {
            return dlClass;
        }

        public final void setDlClass(String dlClass) {
            this.dlClass = dlClass;
        }

        @Override
        public final Builder dlClass(String dlClass) {
            this.dlClass = dlClass;
            return this;
        }

        @Override
        public final Builder dlClass(DlClass dlClass) {
            this.dlClass(dlClass == null ? null : dlClass.toString());
            return this;
        }

        @Override
        public LoRaWANMulticast build() {
            return new LoRaWANMulticast(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
