/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the Redis engine version
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineVersionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<EngineVersionInfo.Builder, EngineVersionInfo> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(EngineVersionInfo::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnginePatchVersion").getter(getter(EngineVersionInfo::enginePatchVersion))
            .setter(setter(Builder::enginePatchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnginePatchVersion").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupFamily").getter(getter(EngineVersionInfo::parameterGroupFamily))
            .setter(setter(Builder::parameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupFamily").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD,
            ENGINE_PATCH_VERSION_FIELD, PARAMETER_GROUP_FAMILY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineVersion;

    private final String enginePatchVersion;

    private final String parameterGroupFamily;

    private EngineVersionInfo(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.enginePatchVersion = builder.enginePatchVersion;
        this.parameterGroupFamily = builder.parameterGroupFamily;
    }

    /**
     * <p>
     * The engine version
     * </p>
     * 
     * @return The engine version
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The patched engine version
     * </p>
     * 
     * @return The patched engine version
     */
    public final String enginePatchVersion() {
        return enginePatchVersion;
    }

    /**
     * <p>
     * Specifies the name of the parameter group family to which the engine default parameters apply.
     * </p>
     * 
     * @return Specifies the name of the parameter group family to which the engine default parameters apply.
     */
    public final String parameterGroupFamily() {
        return parameterGroupFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(enginePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersionInfo)) {
            return false;
        }
        EngineVersionInfo other = (EngineVersionInfo) obj;
        return Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(enginePatchVersion(), other.enginePatchVersion())
                && Objects.equals(parameterGroupFamily(), other.parameterGroupFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineVersionInfo").add("EngineVersion", engineVersion())
                .add("EnginePatchVersion", enginePatchVersion()).add("ParameterGroupFamily", parameterGroupFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EnginePatchVersion":
            return Optional.ofNullable(clazz.cast(enginePatchVersion()));
        case "ParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(parameterGroupFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineVersionInfo, T> g) {
        return obj -> g.apply((EngineVersionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineVersionInfo> {
        /**
         * <p>
         * The engine version
         * </p>
         * 
         * @param engineVersion
         *        The engine version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The patched engine version
         * </p>
         * 
         * @param enginePatchVersion
         *        The patched engine version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enginePatchVersion(String enginePatchVersion);

        /**
         * <p>
         * Specifies the name of the parameter group family to which the engine default parameters apply.
         * </p>
         * 
         * @param parameterGroupFamily
         *        Specifies the name of the parameter group family to which the engine default parameters apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupFamily(String parameterGroupFamily);
    }

    static final class BuilderImpl implements Builder {
        private String engineVersion;

        private String enginePatchVersion;

        private String parameterGroupFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersionInfo model) {
            engineVersion(model.engineVersion);
            enginePatchVersion(model.enginePatchVersion);
            parameterGroupFamily(model.parameterGroupFamily);
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnginePatchVersion() {
            return enginePatchVersion;
        }

        public final void setEnginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
        }

        @Override
        public final Builder enginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
            return this;
        }

        public final String getParameterGroupFamily() {
            return parameterGroupFamily;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        @Override
        public EngineVersionInfo build() {
            return new EngineVersionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
