/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures one or more IP set references for a Suricata-compatible rule group. This is used in <a>CreateRuleGroup</a>
 * or <a>UpdateRuleGroup</a>. An IP set reference is a rule variable that references resources that you create and
 * manage in another Amazon Web Services service, such as an Amazon VPC prefix list. Network Firewall IP set references
 * enable you to dynamically update the contents of your rules. When you create, update, or delete the resource you are
 * referencing in your rule, Network Firewall automatically updates the rule's content with the changes. For more
 * information about IP set references in Network Firewall, see <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references">Using IP set
 * references</a> in the <i>Network Firewall Developer Guide</i>.
 * </p>
 * <p>
 * Network Firewall currently supports <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Amazon VPC prefix lists</a> and <a
 * href=
 * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-referencing-resource-groups"
 * >resource groups</a> in IP set references.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPSetReference implements SdkPojo, Serializable, ToCopyableBuilder<IPSetReference.Builder, IPSetReference> {
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceArn").getter(getter(IPSetReference::referenceArn)).setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String referenceArn;

    private IPSetReference(BuilderImpl builder) {
        this.referenceArn = builder.referenceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetReference)) {
            return false;
        }
        IPSetReference other = (IPSetReference) obj;
        return Objects.equals(referenceArn(), other.referenceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPSetReference").add("ReferenceArn", referenceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSetReference, T> g) {
        return obj -> g.apply((IPSetReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPSetReference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
         * </p>
         * 
         * @param referenceArn
         *        The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);
    }

    static final class BuilderImpl implements Builder {
        private String referenceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetReference model) {
            referenceArn(model.referenceArn);
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        @Override
        public IPSetReference build() {
            return new IPSetReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
