/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information about the managed rule group that your own rule group is copied from. You can use the the
 * metadata to track version updates made to the originating rule group. You can retrieve all objects for a rule group
 * by calling <a href="https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html">
 * DescribeRuleGroup</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceMetadata implements SdkPojo, Serializable, ToCopyableBuilder<SourceMetadata.Builder, SourceMetadata> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(SourceMetadata::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> SOURCE_UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUpdateToken").getter(getter(SourceMetadata::sourceUpdateToken))
            .setter(setter(Builder::sourceUpdateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            SOURCE_UPDATE_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final String sourceUpdateToken;

    private SourceMetadata(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.sourceUpdateToken = builder.sourceUpdateToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The update token of the Amazon Web Services managed rule group that your own rule group is copied from. To
     * determine the update token for the managed rule group, call <a href=
     * "https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken"
     * >DescribeRuleGroup</a>.
     * </p>
     * 
     * @return The update token of the Amazon Web Services managed rule group that your own rule group is copied from.
     *         To determine the update token for the managed rule group, call <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken"
     *         >DescribeRuleGroup</a>.
     */
    public final String sourceUpdateToken() {
        return sourceUpdateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUpdateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceMetadata)) {
            return false;
        }
        SourceMetadata other = (SourceMetadata) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(sourceUpdateToken(), other.sourceUpdateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceMetadata").add("SourceArn", sourceArn()).add("SourceUpdateToken", sourceUpdateToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SourceUpdateToken":
            return Optional.ofNullable(clazz.cast(sourceUpdateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceMetadata, T> g) {
        return obj -> g.apply((SourceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The update token of the Amazon Web Services managed rule group that your own rule group is copied from. To
         * determine the update token for the managed rule group, call <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken"
         * >DescribeRuleGroup</a>.
         * </p>
         * 
         * @param sourceUpdateToken
         *        The update token of the Amazon Web Services managed rule group that your own rule group is copied
         *        from. To determine the update token for the managed rule group, call <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken"
         *        >DescribeRuleGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUpdateToken(String sourceUpdateToken);
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private String sourceUpdateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceMetadata model) {
            sourceArn(model.sourceArn);
            sourceUpdateToken(model.sourceUpdateToken);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceUpdateToken() {
            return sourceUpdateToken;
        }

        public final void setSourceUpdateToken(String sourceUpdateToken) {
            this.sourceUpdateToken = sourceUpdateToken;
        }

        @Override
        public final Builder sourceUpdateToken(String sourceUpdateToken) {
            this.sourceUpdateToken = sourceUpdateToken;
            return this;
        }

        @Override
        public SourceMetadata build() {
            return new SourceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
