/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFirewallPolicyRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateFirewallPolicyRequest> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::updateToken)).setter(UpdateFirewallPolicyRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::firewallPolicyArn)).setter(UpdateFirewallPolicyRequest.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyName").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::firewallPolicyName)).setter(UpdateFirewallPolicyRequest.setter(Builder::firewallPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build()}).build();
    private static final SdkField<FirewallPolicy> FIREWALL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallPolicy").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::firewallPolicy)).setter(UpdateFirewallPolicyRequest.setter(Builder::firewallPolicy)).constructor(FirewallPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::description)).setter(UpdateFirewallPolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::dryRun)).setter(UpdateFirewallPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(UpdateFirewallPolicyRequest.getter(UpdateFirewallPolicyRequest::encryptionConfiguration)).setter(UpdateFirewallPolicyRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD, FIREWALL_POLICY_ARN_FIELD, FIREWALL_POLICY_NAME_FIELD, FIREWALL_POLICY_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private final String updateToken;
    private final String firewallPolicyArn;
    private final String firewallPolicyName;
    private final FirewallPolicy firewallPolicy;
    private final String description;
    private final Boolean dryRun;
    private final EncryptionConfiguration encryptionConfiguration;

    private UpdateFirewallPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicy = builder.firewallPolicy;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public final String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    public final String firewallPolicyName() {
        return this.firewallPolicyName;
    }

    public final FirewallPolicy firewallPolicy() {
        return this.firewallPolicy;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallPolicyRequest)) {
            return false;
        }
        UpdateFirewallPolicyRequest other = (UpdateFirewallPolicyRequest)((Object)obj);
        return Objects.equals(this.updateToken(), other.updateToken()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(this.firewallPolicyName(), other.firewallPolicyName()) && Objects.equals(this.firewallPolicy(), other.firewallPolicy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFirewallPolicyRequest").add("UpdateToken", (Object)this.updateToken()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).add("FirewallPolicyName", (Object)this.firewallPolicyName()).add("FirewallPolicy", (Object)this.firewallPolicy()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
            case "FirewallPolicyName": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyName()));
            }
            case "FirewallPolicy": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicy()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallPolicyRequest, T> g) {
        return obj -> g.apply((UpdateFirewallPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String updateToken;
        private String firewallPolicyArn;
        private String firewallPolicyName;
        private FirewallPolicy firewallPolicy;
        private String description;
        private Boolean dryRun;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallPolicyRequest model) {
            super(model);
            this.updateToken(model.updateToken);
            this.firewallPolicyArn(model.firewallPolicyArn);
            this.firewallPolicyName(model.firewallPolicyName);
            this.firewallPolicy(model.firewallPolicy);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getFirewallPolicyName() {
            return this.firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final FirewallPolicy.Builder getFirewallPolicy() {
            return this.firewallPolicy != null ? this.firewallPolicy.toBuilder() : null;
        }

        public final void setFirewallPolicy(FirewallPolicy.BuilderImpl firewallPolicy) {
            this.firewallPolicy = firewallPolicy != null ? firewallPolicy.build() : null;
        }

        @Override
        public final Builder firewallPolicy(FirewallPolicy firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallPolicyRequest build() {
            return new UpdateFirewallPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFirewallPolicyRequest> {
        public Builder updateToken(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder firewallPolicyName(String var1);

        public Builder firewallPolicy(FirewallPolicy var1);

        default public Builder firewallPolicy(Consumer<FirewallPolicy.Builder> firewallPolicy) {
            return this.firewallPolicy((FirewallPolicy)((FirewallPolicy.Builder)FirewallPolicy.builder().applyMutation(firewallPolicy)).build());
        }

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

