/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Directory Service for Microsoft Active Directory studio resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveDirectoryConfiguration.Builder, ActiveDirectoryConfiguration> {
    private static final SdkField<List<ActiveDirectoryComputerAttribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField
            .<List<ActiveDirectoryComputerAttribute>> builder(MarshallingType.LIST)
            .memberName("computerAttributes")
            .getter(getter(ActiveDirectoryConfiguration::computerAttributes))
            .setter(setter(Builder::computerAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computerAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveDirectoryComputerAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveDirectoryComputerAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directoryId").getter(getter(ActiveDirectoryConfiguration::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryId").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitDistinguishedName")
            .getter(getter(ActiveDirectoryConfiguration::organizationalUnitDistinguishedName))
            .setter(setter(Builder::organizationalUnitDistinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("organizationalUnitDistinguishedName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ATTRIBUTES_FIELD,
            DIRECTORY_ID_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ActiveDirectoryComputerAttribute> computerAttributes;

    private final String directoryId;

    private final String organizationalUnitDistinguishedName;

    private ActiveDirectoryConfiguration(BuilderImpl builder) {
        this.computerAttributes = builder.computerAttributes;
        this.directoryId = builder.directoryId;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputerAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputerAttributes() {
        return computerAttributes != null && !(computerAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of custom attributes for an Active Directory computer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputerAttributes} method.
     * </p>
     * 
     * @return A collection of custom attributes for an Active Directory computer.
     */
    public final List<ActiveDirectoryComputerAttribute> computerAttributes() {
        return computerAttributes;
    }

    /**
     * <p>
     * The directory ID of the Directory Service for Microsoft Active Directory to access using this studio component.
     * </p>
     * 
     * @return The directory ID of the Directory Service for Microsoft Active Directory to access using this studio
     *         component.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.
     * </p>
     * 
     * @return The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.
     */
    public final String organizationalUnitDistinguishedName() {
        return organizationalUnitDistinguishedName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComputerAttributes() ? computerAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryConfiguration)) {
            return false;
        }
        ActiveDirectoryConfiguration other = (ActiveDirectoryConfiguration) obj;
        return hasComputerAttributes() == other.hasComputerAttributes()
                && Objects.equals(computerAttributes(), other.computerAttributes())
                && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveDirectoryConfiguration")
                .add("ComputerAttributes", computerAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DirectoryId", directoryId())
                .add("OrganizationalUnitDistinguishedName", organizationalUnitDistinguishedName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computerAttributes":
            return Optional.ofNullable(clazz.cast(computerAttributes()));
        case "directoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "organizationalUnitDistinguishedName":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryConfiguration, T> g) {
        return obj -> g.apply((ActiveDirectoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectoryConfiguration> {
        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * 
         * @param computerAttributes
         *        A collection of custom attributes for an Active Directory computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes);

        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * 
         * @param computerAttributes
         *        A collection of custom attributes for an Active Directory computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(ActiveDirectoryComputerAttribute... computerAttributes);

        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #computerAttributes(List<ActiveDirectoryComputerAttribute>)}.
         * 
         * @param computerAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computerAttributes(java.util.Collection<ActiveDirectoryComputerAttribute>)
         */
        Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder>... computerAttributes);

        /**
         * <p>
         * The directory ID of the Directory Service for Microsoft Active Directory to access using this studio
         * component.
         * </p>
         * 
         * @param directoryId
         *        The directory ID of the Directory Service for Microsoft Active Directory to access using this studio
         *        component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.
         * </p>
         * 
         * @param organizationalUnitDistinguishedName
         *        The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName);
    }

    static final class BuilderImpl implements Builder {
        private List<ActiveDirectoryComputerAttribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private String directoryId;

        private String organizationalUnitDistinguishedName;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryConfiguration model) {
            computerAttributes(model.computerAttributes);
            directoryId(model.directoryId);
            organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
        }

        public final List<ActiveDirectoryComputerAttribute.Builder> getComputerAttributes() {
            List<ActiveDirectoryComputerAttribute.Builder> result = ActiveDirectoryComputerAttributeListCopier
                    .copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputerAttributes(Collection<ActiveDirectoryComputerAttribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copyFromBuilder(computerAttributes);
        }

        @Override
        public final Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(ActiveDirectoryComputerAttribute... computerAttributes) {
            computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder>... computerAttributes) {
            computerAttributes(Stream.of(computerAttributes)
                    .map(c -> ActiveDirectoryComputerAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return organizationalUnitDistinguishedName;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        @Override
        public ActiveDirectoryConfiguration build() {
            return new ActiveDirectoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
