/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory;
import software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript;
import software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScriptListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform;
import software.amazon.awssdk.services.nimble.model.LaunchProfileSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchProfileInitialization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchProfileInitialization> {
    private static final SdkField<LaunchProfileInitializationActiveDirectory> ACTIVE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("activeDirectory").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::activeDirectory)).setter(LaunchProfileInitialization.setter(Builder::activeDirectory)).constructor(LaunchProfileInitializationActiveDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectory").build()}).build();
    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2SecurityGroupIds").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::ec2SecurityGroupIds)).setter(LaunchProfileInitialization.setter(Builder::ec2SecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::launchProfileId)).setter(LaunchProfileInitialization.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()}).build();
    private static final SdkField<String> LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileProtocolVersion").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::launchProfileProtocolVersion)).setter(LaunchProfileInitialization.setter(Builder::launchProfileProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersion").build()}).build();
    private static final SdkField<String> LAUNCH_PURPOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchPurpose").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::launchPurpose)).setter(LaunchProfileInitialization.setter(Builder::launchPurpose)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchPurpose").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::name)).setter(LaunchProfileInitialization.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::platformAsString)).setter(LaunchProfileInitialization.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<LaunchProfileInitializationScript>> SYSTEM_INITIALIZATION_SCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("systemInitializationScripts").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::systemInitializationScripts)).setter(LaunchProfileInitialization.setter(Builder::systemInitializationScripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInitializationScripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchProfileInitializationScript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchProfileInitializationScript>> USER_INITIALIZATION_SCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userInitializationScripts").getter(LaunchProfileInitialization.getter(LaunchProfileInitialization::userInitializationScripts)).setter(LaunchProfileInitialization.setter(Builder::userInitializationScripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userInitializationScripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchProfileInitializationScript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_FIELD, EC2_SECURITY_GROUP_IDS_FIELD, LAUNCH_PROFILE_ID_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD, LAUNCH_PURPOSE_FIELD, NAME_FIELD, PLATFORM_FIELD, SYSTEM_INITIALIZATION_SCRIPTS_FIELD, USER_INITIALIZATION_SCRIPTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final LaunchProfileInitializationActiveDirectory activeDirectory;
    private final List<String> ec2SecurityGroupIds;
    private final String launchProfileId;
    private final String launchProfileProtocolVersion;
    private final String launchPurpose;
    private final String name;
    private final String platform;
    private final List<LaunchProfileInitializationScript> systemInitializationScripts;
    private final List<LaunchProfileInitializationScript> userInitializationScripts;

    private LaunchProfileInitialization(BuilderImpl builder) {
        this.activeDirectory = builder.activeDirectory;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersion = builder.launchProfileProtocolVersion;
        this.launchPurpose = builder.launchPurpose;
        this.name = builder.name;
        this.platform = builder.platform;
        this.systemInitializationScripts = builder.systemInitializationScripts;
        this.userInitializationScripts = builder.userInitializationScripts;
    }

    public final LaunchProfileInitializationActiveDirectory activeDirectory() {
        return this.activeDirectory;
    }

    public final boolean hasEc2SecurityGroupIds() {
        return this.ec2SecurityGroupIds != null && !(this.ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SecurityGroupIds() {
        return this.ec2SecurityGroupIds;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final String launchProfileProtocolVersion() {
        return this.launchProfileProtocolVersion;
    }

    public final String launchPurpose() {
        return this.launchPurpose;
    }

    public final String name() {
        return this.name;
    }

    public final LaunchProfilePlatform platform() {
        return LaunchProfilePlatform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final boolean hasSystemInitializationScripts() {
        return this.systemInitializationScripts != null && !(this.systemInitializationScripts instanceof SdkAutoConstructList);
    }

    public final List<LaunchProfileInitializationScript> systemInitializationScripts() {
        return this.systemInitializationScripts;
    }

    public final boolean hasUserInitializationScripts() {
        return this.userInitializationScripts != null && !(this.userInitializationScripts instanceof SdkAutoConstructList);
    }

    public final List<LaunchProfileInitializationScript> userInitializationScripts() {
        return this.userInitializationScripts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPurpose());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemInitializationScripts() ? this.systemInitializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserInitializationScripts() ? this.userInitializationScripts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitialization)) {
            return false;
        }
        LaunchProfileInitialization other = (LaunchProfileInitialization)obj;
        return Objects.equals(this.activeDirectory(), other.activeDirectory()) && this.hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds() && Objects.equals(this.ec2SecurityGroupIds(), other.ec2SecurityGroupIds()) && Objects.equals(this.launchProfileId(), other.launchProfileId()) && Objects.equals(this.launchProfileProtocolVersion(), other.launchProfileProtocolVersion()) && Objects.equals(this.launchPurpose(), other.launchPurpose()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.platformAsString(), other.platformAsString()) && this.hasSystemInitializationScripts() == other.hasSystemInitializationScripts() && Objects.equals(this.systemInitializationScripts(), other.systemInitializationScripts()) && this.hasUserInitializationScripts() == other.hasUserInitializationScripts() && Objects.equals(this.userInitializationScripts(), other.userInitializationScripts());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchProfileInitialization").add("ActiveDirectory", (Object)this.activeDirectory()).add("Ec2SecurityGroupIds", this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null).add("LaunchProfileId", (Object)this.launchProfileId()).add("LaunchProfileProtocolVersion", (Object)this.launchProfileProtocolVersion()).add("LaunchPurpose", (Object)this.launchPurpose()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Platform", (Object)this.platformAsString()).add("SystemInitializationScripts", this.hasSystemInitializationScripts() ? this.systemInitializationScripts() : null).add("UserInitializationScripts", this.hasUserInitializationScripts() ? this.userInitializationScripts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeDirectory": {
                return Optional.ofNullable(clazz.cast(this.activeDirectory()));
            }
            case "ec2SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupIds()));
            }
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "launchProfileProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersion()));
            }
            case "launchPurpose": {
                return Optional.ofNullable(clazz.cast(this.launchPurpose()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "systemInitializationScripts": {
                return Optional.ofNullable(clazz.cast(this.systemInitializationScripts()));
            }
            case "userInitializationScripts": {
                return Optional.ofNullable(clazz.cast(this.userInitializationScripts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitialization, T> g) {
        return obj -> g.apply((LaunchProfileInitialization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchProfileInitializationActiveDirectory activeDirectory;
        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String launchProfileId;
        private String launchProfileProtocolVersion;
        private String launchPurpose;
        private String name;
        private String platform;
        private List<LaunchProfileInitializationScript> systemInitializationScripts = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchProfileInitializationScript> userInitializationScripts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitialization model) {
            this.activeDirectory(model.activeDirectory);
            this.ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            this.launchProfileId(model.launchProfileId);
            this.launchProfileProtocolVersion(model.launchProfileProtocolVersion);
            this.launchPurpose(model.launchPurpose);
            this.name(model.name);
            this.platform(model.platform);
            this.systemInitializationScripts(model.systemInitializationScripts);
            this.userInitializationScripts(model.userInitializationScripts);
        }

        public final LaunchProfileInitializationActiveDirectory.Builder getActiveDirectory() {
            return this.activeDirectory != null ? this.activeDirectory.toBuilder() : null;
        }

        public final void setActiveDirectory(LaunchProfileInitializationActiveDirectory.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        @Override
        public final Builder activeDirectory(LaunchProfileInitializationActiveDirectory activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (this.ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = LaunchProfileSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = LaunchProfileSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String ... ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final String getLaunchProfileProtocolVersion() {
            return this.launchProfileProtocolVersion;
        }

        public final void setLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
        }

        @Override
        public final Builder launchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
            return this;
        }

        public final String getLaunchPurpose() {
            return this.launchPurpose;
        }

        public final void setLaunchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
        }

        @Override
        public final Builder launchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(LaunchProfilePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final List<LaunchProfileInitializationScript.Builder> getSystemInitializationScripts() {
            List<LaunchProfileInitializationScript.Builder> result = LaunchProfileInitializationScriptListCopier.copyToBuilder(this.systemInitializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemInitializationScripts(Collection<LaunchProfileInitializationScript.BuilderImpl> systemInitializationScripts) {
            this.systemInitializationScripts = LaunchProfileInitializationScriptListCopier.copyFromBuilder(systemInitializationScripts);
        }

        @Override
        public final Builder systemInitializationScripts(Collection<LaunchProfileInitializationScript> systemInitializationScripts) {
            this.systemInitializationScripts = LaunchProfileInitializationScriptListCopier.copy(systemInitializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInitializationScripts(LaunchProfileInitializationScript ... systemInitializationScripts) {
            this.systemInitializationScripts(Arrays.asList(systemInitializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder> ... systemInitializationScripts) {
            this.systemInitializationScripts(Stream.of(systemInitializationScripts).map(c -> (LaunchProfileInitializationScript)((LaunchProfileInitializationScript.Builder)LaunchProfileInitializationScript.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchProfileInitializationScript.Builder> getUserInitializationScripts() {
            List<LaunchProfileInitializationScript.Builder> result = LaunchProfileInitializationScriptListCopier.copyToBuilder(this.userInitializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserInitializationScripts(Collection<LaunchProfileInitializationScript.BuilderImpl> userInitializationScripts) {
            this.userInitializationScripts = LaunchProfileInitializationScriptListCopier.copyFromBuilder(userInitializationScripts);
        }

        @Override
        public final Builder userInitializationScripts(Collection<LaunchProfileInitializationScript> userInitializationScripts) {
            this.userInitializationScripts = LaunchProfileInitializationScriptListCopier.copy(userInitializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userInitializationScripts(LaunchProfileInitializationScript ... userInitializationScripts) {
            this.userInitializationScripts(Arrays.asList(userInitializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder> ... userInitializationScripts) {
            this.userInitializationScripts(Stream.of(userInitializationScripts).map(c -> (LaunchProfileInitializationScript)((LaunchProfileInitializationScript.Builder)LaunchProfileInitializationScript.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LaunchProfileInitialization build() {
            return new LaunchProfileInitialization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchProfileInitialization> {
        public Builder activeDirectory(LaunchProfileInitializationActiveDirectory var1);

        default public Builder activeDirectory(Consumer<LaunchProfileInitializationActiveDirectory.Builder> activeDirectory) {
            return this.activeDirectory((LaunchProfileInitializationActiveDirectory)((LaunchProfileInitializationActiveDirectory.Builder)LaunchProfileInitializationActiveDirectory.builder().applyMutation(activeDirectory)).build());
        }

        public Builder ec2SecurityGroupIds(Collection<String> var1);

        public Builder ec2SecurityGroupIds(String ... var1);

        public Builder launchProfileId(String var1);

        public Builder launchProfileProtocolVersion(String var1);

        public Builder launchPurpose(String var1);

        public Builder name(String var1);

        public Builder platform(String var1);

        public Builder platform(LaunchProfilePlatform var1);

        public Builder systemInitializationScripts(Collection<LaunchProfileInitializationScript> var1);

        public Builder systemInitializationScripts(LaunchProfileInitializationScript ... var1);

        public Builder systemInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder> ... var1);

        public Builder userInitializationScripts(Collection<LaunchProfileInitializationScript> var1);

        public Builder userInitializationScripts(LaunchProfileInitializationScript ... var1);

        public Builder userInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder> ... var1);
    }
}

