/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the capacity task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityTaskSummary.Builder, CapacityTaskSummary> {
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskId").getter(getter(CapacityTaskSummary::capacityTaskId))
            .setter(setter(Builder::capacityTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskId").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(CapacityTaskSummary::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderId").getter(getter(CapacityTaskSummary::orderId)).setter(setter(Builder::orderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()).build();

    private static final SdkField<String> CAPACITY_TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskStatus").getter(getter(CapacityTaskSummary::capacityTaskStatusAsString))
            .setter(setter(Builder::capacityTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskStatus").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(CapacityTaskSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDate").getter(getter(CapacityTaskSummary::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(CapacityTaskSummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASK_ID_FIELD,
            OUTPOST_ID_FIELD, ORDER_ID_FIELD, CAPACITY_TASK_STATUS_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD,
            LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityTaskId;

    private final String outpostId;

    private final String orderId;

    private final String capacityTaskStatus;

    private final Instant creationDate;

    private final Instant completionDate;

    private final Instant lastModifiedDate;

    private CapacityTaskSummary(BuilderImpl builder) {
        this.capacityTaskId = builder.capacityTaskId;
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.capacityTaskStatus = builder.capacityTaskStatus;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The ID of the specified capacity task.
     * </p>
     * 
     * @return The ID of the specified capacity task.
     */
    public final String capacityTaskId() {
        return capacityTaskId;
    }

    /**
     * <p>
     * The ID of the Outpost associated with the specified capacity task.
     * </p>
     * 
     * @return The ID of the Outpost associated with the specified capacity task.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Outposts order of the host associated with the capacity task.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Outposts order of the host associated with the capacity task.
     */
    public final String orderId() {
        return orderId;
    }

    /**
     * <p>
     * The status of the capacity task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityTaskStatus} will return {@link CapacityTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #capacityTaskStatusAsString}.
     * </p>
     * 
     * @return The status of the capacity task.
     * @see CapacityTaskStatus
     */
    public final CapacityTaskStatus capacityTaskStatus() {
        return CapacityTaskStatus.fromValue(capacityTaskStatus);
    }

    /**
     * <p>
     * The status of the capacity task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityTaskStatus} will return {@link CapacityTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #capacityTaskStatusAsString}.
     * </p>
     * 
     * @return The status of the capacity task.
     * @see CapacityTaskStatus
     */
    public final String capacityTaskStatusAsString() {
        return capacityTaskStatus;
    }

    /**
     * <p>
     * The date that the specified capacity task was created.
     * </p>
     * 
     * @return The date that the specified capacity task was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date that the specified capacity task successfully ran.
     * </p>
     * 
     * @return The date that the specified capacity task successfully ran.
     */
    public final Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The date that the specified capacity was last modified.
     * </p>
     * 
     * @return The date that the specified capacity was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(orderId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityTaskSummary)) {
            return false;
        }
        CapacityTaskSummary other = (CapacityTaskSummary) obj;
        return Objects.equals(capacityTaskId(), other.capacityTaskId()) && Objects.equals(outpostId(), other.outpostId())
                && Objects.equals(orderId(), other.orderId())
                && Objects.equals(capacityTaskStatusAsString(), other.capacityTaskStatusAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityTaskSummary").add("CapacityTaskId", capacityTaskId()).add("OutpostId", outpostId())
                .add("OrderId", orderId()).add("CapacityTaskStatus", capacityTaskStatusAsString())
                .add("CreationDate", creationDate()).add("CompletionDate", completionDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityTaskId":
            return Optional.ofNullable(clazz.cast(capacityTaskId()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OrderId":
            return Optional.ofNullable(clazz.cast(orderId()));
        case "CapacityTaskStatus":
            return Optional.ofNullable(clazz.cast(capacityTaskStatusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityTaskSummary, T> g) {
        return obj -> g.apply((CapacityTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityTaskSummary> {
        /**
         * <p>
         * The ID of the specified capacity task.
         * </p>
         * 
         * @param capacityTaskId
         *        The ID of the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskId(String capacityTaskId);

        /**
         * <p>
         * The ID of the Outpost associated with the specified capacity task.
         * </p>
         * 
         * @param outpostId
         *        The ID of the Outpost associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * The ID of the Amazon Web Services Outposts order of the host associated with the capacity task.
         * </p>
         * 
         * @param orderId
         *        The ID of the Amazon Web Services Outposts order of the host associated with the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderId(String orderId);

        /**
         * <p>
         * The status of the capacity task.
         * </p>
         * 
         * @param capacityTaskStatus
         *        The status of the capacity task.
         * @see CapacityTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTaskStatus
         */
        Builder capacityTaskStatus(String capacityTaskStatus);

        /**
         * <p>
         * The status of the capacity task.
         * </p>
         * 
         * @param capacityTaskStatus
         *        The status of the capacity task.
         * @see CapacityTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTaskStatus
         */
        Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus);

        /**
         * <p>
         * The date that the specified capacity task was created.
         * </p>
         * 
         * @param creationDate
         *        The date that the specified capacity task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date that the specified capacity task successfully ran.
         * </p>
         * 
         * @param completionDate
         *        The date that the specified capacity task successfully ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The date that the specified capacity was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date that the specified capacity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String capacityTaskId;

        private String outpostId;

        private String orderId;

        private String capacityTaskStatus;

        private Instant creationDate;

        private Instant completionDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityTaskSummary model) {
            capacityTaskId(model.capacityTaskId);
            outpostId(model.outpostId);
            orderId(model.orderId);
            capacityTaskStatus(model.capacityTaskStatus);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCapacityTaskId() {
            return capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final String getCapacityTaskStatus() {
            return capacityTaskStatus;
        }

        public final void setCapacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
        }

        @Override
        public final Builder capacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
            return this;
        }

        @Override
        public final Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus) {
            this.capacityTaskStatus(capacityTaskStatus == null ? null : capacityTaskStatus.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public CapacityTaskSummary build() {
            return new CapacityTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
