/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityTaskResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetCapacityTaskResponse.Builder, GetCapacityTaskResponse> {
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskId").getter(getter(GetCapacityTaskResponse::capacityTaskId))
            .setter(setter(Builder::capacityTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskId").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(GetCapacityTaskResponse::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderId").getter(getter(GetCapacityTaskResponse::orderId)).setter(setter(Builder::orderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()).build();

    private static final SdkField<List<InstanceTypeCapacity>> REQUESTED_INSTANCE_POOLS_FIELD = SdkField
            .<List<InstanceTypeCapacity>> builder(MarshallingType.LIST)
            .memberName("RequestedInstancePools")
            .getter(getter(GetCapacityTaskResponse::requestedInstancePools))
            .setter(setter(Builder::requestedInstancePools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedInstancePools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(GetCapacityTaskResponse::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> CAPACITY_TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskStatus").getter(getter(GetCapacityTaskResponse::capacityTaskStatusAsString))
            .setter(setter(Builder::capacityTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskStatus").build())
            .build();

    private static final SdkField<CapacityTaskFailure> FAILED_FIELD = SdkField
            .<CapacityTaskFailure> builder(MarshallingType.SDK_POJO).memberName("Failed")
            .getter(getter(GetCapacityTaskResponse::failed)).setter(setter(Builder::failed))
            .constructor(CapacityTaskFailure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetCapacityTaskResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDate").getter(getter(GetCapacityTaskResponse::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(GetCapacityTaskResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASK_ID_FIELD,
            OUTPOST_ID_FIELD, ORDER_ID_FIELD, REQUESTED_INSTANCE_POOLS_FIELD, DRY_RUN_FIELD, CAPACITY_TASK_STATUS_FIELD,
            FAILED_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private final String capacityTaskId;

    private final String outpostId;

    private final String orderId;

    private final List<InstanceTypeCapacity> requestedInstancePools;

    private final Boolean dryRun;

    private final String capacityTaskStatus;

    private final CapacityTaskFailure failed;

    private final Instant creationDate;

    private final Instant completionDate;

    private final Instant lastModifiedDate;

    private GetCapacityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.capacityTaskId = builder.capacityTaskId;
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.requestedInstancePools = builder.requestedInstancePools;
        this.dryRun = builder.dryRun;
        this.capacityTaskStatus = builder.capacityTaskStatus;
        this.failed = builder.failed;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * ID of the capacity task.
     * </p>
     * 
     * @return ID of the capacity task.
     */
    public final String capacityTaskId() {
        return capacityTaskId;
    }

    /**
     * <p>
     * ID of the Outpost associated with the specified capacity task.
     * </p>
     * 
     * @return ID of the Outpost associated with the specified capacity task.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * ID of the Amazon Web Services Outposts order associated with the specified capacity task.
     * </p>
     * 
     * @return ID of the Amazon Web Services Outposts order associated with the specified capacity task.
     */
    public final String orderId() {
        return orderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestedInstancePools property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequestedInstancePools() {
        return requestedInstancePools != null && !(requestedInstancePools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of instance pools requested in the capacity task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestedInstancePools} method.
     * </p>
     * 
     * @return List of instance pools requested in the capacity task.
     */
    public final List<InstanceTypeCapacity> requestedInstancePools() {
        return requestedInstancePools;
    }

    /**
     * <p>
     * Performs a dry run to determine if you are above or below instance capacity.
     * </p>
     * 
     * @return Performs a dry run to determine if you are above or below instance capacity.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Status of the capacity task.
     * </p>
     * <p>
     * A capacity task can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web Services
     * Outposts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the recommended
     * EC2 running instances to free up capacity for the task to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityTaskStatus} will return {@link CapacityTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #capacityTaskStatusAsString}.
     * </p>
     * 
     * @return Status of the capacity task.</p>
     *         <p>
     *         A capacity task can have one of the following statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web
     *         Services Outposts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
     *         recommended EC2 running instances to free up capacity for the task to run.
     *         </p>
     *         </li>
     * @see CapacityTaskStatus
     */
    public final CapacityTaskStatus capacityTaskStatus() {
        return CapacityTaskStatus.fromValue(capacityTaskStatus);
    }

    /**
     * <p>
     * Status of the capacity task.
     * </p>
     * <p>
     * A capacity task can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web Services
     * Outposts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the recommended
     * EC2 running instances to free up capacity for the task to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityTaskStatus} will return {@link CapacityTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #capacityTaskStatusAsString}.
     * </p>
     * 
     * @return Status of the capacity task.</p>
     *         <p>
     *         A capacity task can have one of the following statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web
     *         Services Outposts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
     *         recommended EC2 running instances to free up capacity for the task to run.
     *         </p>
     *         </li>
     * @see CapacityTaskStatus
     */
    public final String capacityTaskStatusAsString() {
        return capacityTaskStatus;
    }

    /**
     * <p>
     * Reason why the capacity task failed.
     * </p>
     * 
     * @return Reason why the capacity task failed.
     */
    public final CapacityTaskFailure failed() {
        return failed;
    }

    /**
     * <p>
     * The date the capacity task was created.
     * </p>
     * 
     * @return The date the capacity task was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the capacity task ran successfully.
     * </p>
     * 
     * @return The date the capacity task ran successfully.
     */
    public final Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The date the capacity task was last modified.
     * </p>
     * 
     * @return The date the capacity task was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(orderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedInstancePools() ? requestedInstancePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityTaskResponse)) {
            return false;
        }
        GetCapacityTaskResponse other = (GetCapacityTaskResponse) obj;
        return Objects.equals(capacityTaskId(), other.capacityTaskId()) && Objects.equals(outpostId(), other.outpostId())
                && Objects.equals(orderId(), other.orderId()) && hasRequestedInstancePools() == other.hasRequestedInstancePools()
                && Objects.equals(requestedInstancePools(), other.requestedInstancePools())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(capacityTaskStatusAsString(), other.capacityTaskStatusAsString())
                && Objects.equals(failed(), other.failed()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityTaskResponse").add("CapacityTaskId", capacityTaskId()).add("OutpostId", outpostId())
                .add("OrderId", orderId())
                .add("RequestedInstancePools", hasRequestedInstancePools() ? requestedInstancePools() : null)
                .add("DryRun", dryRun()).add("CapacityTaskStatus", capacityTaskStatusAsString()).add("Failed", failed())
                .add("CreationDate", creationDate()).add("CompletionDate", completionDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityTaskId":
            return Optional.ofNullable(clazz.cast(capacityTaskId()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OrderId":
            return Optional.ofNullable(clazz.cast(orderId()));
        case "RequestedInstancePools":
            return Optional.ofNullable(clazz.cast(requestedInstancePools()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "CapacityTaskStatus":
            return Optional.ofNullable(clazz.cast(capacityTaskStatusAsString()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityTaskResponse, T> g) {
        return obj -> g.apply((GetCapacityTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCapacityTaskResponse> {
        /**
         * <p>
         * ID of the capacity task.
         * </p>
         * 
         * @param capacityTaskId
         *        ID of the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskId(String capacityTaskId);

        /**
         * <p>
         * ID of the Outpost associated with the specified capacity task.
         * </p>
         * 
         * @param outpostId
         *        ID of the Outpost associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * ID of the Amazon Web Services Outposts order associated with the specified capacity task.
         * </p>
         * 
         * @param orderId
         *        ID of the Amazon Web Services Outposts order associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderId(String orderId);

        /**
         * <p>
         * List of instance pools requested in the capacity task.
         * </p>
         * 
         * @param requestedInstancePools
         *        List of instance pools requested in the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedInstancePools(Collection<InstanceTypeCapacity> requestedInstancePools);

        /**
         * <p>
         * List of instance pools requested in the capacity task.
         * </p>
         * 
         * @param requestedInstancePools
         *        List of instance pools requested in the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedInstancePools(InstanceTypeCapacity... requestedInstancePools);

        /**
         * <p>
         * List of instance pools requested in the capacity task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder#build()} is called
         * immediately and its result is passed to {@link #requestedInstancePools(List<InstanceTypeCapacity>)}.
         * 
         * @param requestedInstancePools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedInstancePools(java.util.Collection<InstanceTypeCapacity>)
         */
        Builder requestedInstancePools(Consumer<InstanceTypeCapacity.Builder>... requestedInstancePools);

        /**
         * <p>
         * Performs a dry run to determine if you are above or below instance capacity.
         * </p>
         * 
         * @param dryRun
         *        Performs a dry run to determine if you are above or below instance capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Status of the capacity task.
         * </p>
         * <p>
         * A capacity task can have one of the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web Services
         * Outposts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
         * recommended EC2 running instances to free up capacity for the task to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityTaskStatus
         *        Status of the capacity task.</p>
         *        <p>
         *        A capacity task can have one of the following statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web
         *        Services Outposts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
         *        recommended EC2 running instances to free up capacity for the task to run.
         *        </p>
         *        </li>
         * @see CapacityTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTaskStatus
         */
        Builder capacityTaskStatus(String capacityTaskStatus);

        /**
         * <p>
         * Status of the capacity task.
         * </p>
         * <p>
         * A capacity task can have one of the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web Services
         * Outposts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
         * recommended EC2 running instances to free up capacity for the task to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityTaskStatus
         *        Status of the capacity task.</p>
         *        <p>
         *        A capacity task can have one of the following statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web
         *        Services Outposts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the
         *        recommended EC2 running instances to free up capacity for the task to run.
         *        </p>
         *        </li>
         * @see CapacityTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTaskStatus
         */
        Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus);

        /**
         * <p>
         * Reason why the capacity task failed.
         * </p>
         * 
         * @param failed
         *        Reason why the capacity task failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(CapacityTaskFailure failed);

        /**
         * <p>
         * Reason why the capacity task failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityTaskFailure.Builder} avoiding the
         * need to create one manually via {@link CapacityTaskFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityTaskFailure.Builder#build()} is called immediately and
         * its result is passed to {@link #failed(CapacityTaskFailure)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link CapacityTaskFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(CapacityTaskFailure)
         */
        default Builder failed(Consumer<CapacityTaskFailure.Builder> failed) {
            return failed(CapacityTaskFailure.builder().applyMutation(failed).build());
        }

        /**
         * <p>
         * The date the capacity task was created.
         * </p>
         * 
         * @param creationDate
         *        The date the capacity task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the capacity task ran successfully.
         * </p>
         * 
         * @param completionDate
         *        The date the capacity task ran successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The date the capacity task was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the capacity task was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private String capacityTaskId;

        private String outpostId;

        private String orderId;

        private List<InstanceTypeCapacity> requestedInstancePools = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private String capacityTaskStatus;

        private CapacityTaskFailure failed;

        private Instant creationDate;

        private Instant completionDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityTaskResponse model) {
            super(model);
            capacityTaskId(model.capacityTaskId);
            outpostId(model.outpostId);
            orderId(model.orderId);
            requestedInstancePools(model.requestedInstancePools);
            dryRun(model.dryRun);
            capacityTaskStatus(model.capacityTaskStatus);
            failed(model.failed);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCapacityTaskId() {
            return capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<InstanceTypeCapacity.Builder> getRequestedInstancePools() {
            List<InstanceTypeCapacity.Builder> result = RequestedInstancePoolsCopier.copyToBuilder(this.requestedInstancePools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestedInstancePools(Collection<InstanceTypeCapacity.BuilderImpl> requestedInstancePools) {
            this.requestedInstancePools = RequestedInstancePoolsCopier.copyFromBuilder(requestedInstancePools);
        }

        @Override
        public final Builder requestedInstancePools(Collection<InstanceTypeCapacity> requestedInstancePools) {
            this.requestedInstancePools = RequestedInstancePoolsCopier.copy(requestedInstancePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedInstancePools(InstanceTypeCapacity... requestedInstancePools) {
            requestedInstancePools(Arrays.asList(requestedInstancePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedInstancePools(Consumer<InstanceTypeCapacity.Builder>... requestedInstancePools) {
            requestedInstancePools(Stream.of(requestedInstancePools)
                    .map(c -> InstanceTypeCapacity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getCapacityTaskStatus() {
            return capacityTaskStatus;
        }

        public final void setCapacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
        }

        @Override
        public final Builder capacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
            return this;
        }

        @Override
        public final Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus) {
            this.capacityTaskStatus(capacityTaskStatus == null ? null : capacityTaskStatus.toString());
            return this;
        }

        public final CapacityTaskFailure.Builder getFailed() {
            return failed != null ? failed.toBuilder() : null;
        }

        public final void setFailed(CapacityTaskFailure.BuilderImpl failed) {
            this.failed = failed != null ? failed.build() : null;
        }

        @Override
        public final Builder failed(CapacityTaskFailure failed) {
            this.failed = failed;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public GetCapacityTaskResponse build() {
            return new GetCapacityTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
