/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCatalogItemResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetCatalogItemResponse.Builder, GetCatalogItemResponse> {
    private static final SdkField<CatalogItem> CATALOG_ITEM_FIELD = SdkField.<CatalogItem> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogItem").getter(getter(GetCatalogItemResponse::catalogItem)).setter(setter(Builder::catalogItem))
            .constructor(CatalogItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_FIELD));

    private final CatalogItem catalogItem;

    private GetCatalogItemResponse(BuilderImpl builder) {
        super(builder);
        this.catalogItem = builder.catalogItem;
    }

    /**
     * <p>
     * Information about this catalog item.
     * </p>
     * 
     * @return Information about this catalog item.
     */
    public final CatalogItem catalogItem() {
        return catalogItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCatalogItemResponse)) {
            return false;
        }
        GetCatalogItemResponse other = (GetCatalogItemResponse) obj;
        return Objects.equals(catalogItem(), other.catalogItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCatalogItemResponse").add("CatalogItem", catalogItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItem":
            return Optional.ofNullable(clazz.cast(catalogItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCatalogItemResponse, T> g) {
        return obj -> g.apply((GetCatalogItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCatalogItemResponse> {
        /**
         * <p>
         * Information about this catalog item.
         * </p>
         * 
         * @param catalogItem
         *        Information about this catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItem(CatalogItem catalogItem);

        /**
         * <p>
         * Information about this catalog item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogItem.Builder} avoiding the need to
         * create one manually via {@link CatalogItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogItem.Builder#build()} is called immediately and its result
         * is passed to {@link #catalogItem(CatalogItem)}.
         * 
         * @param catalogItem
         *        a consumer that will call methods on {@link CatalogItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogItem(CatalogItem)
         */
        default Builder catalogItem(Consumer<CatalogItem.Builder> catalogItem) {
            return catalogItem(CatalogItem.builder().applyMutation(catalogItem).build());
        }
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private CatalogItem catalogItem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCatalogItemResponse model) {
            super(model);
            catalogItem(model.catalogItem);
        }

        public final CatalogItem.Builder getCatalogItem() {
            return catalogItem != null ? catalogItem.toBuilder() : null;
        }

        public final void setCatalogItem(CatalogItem.BuilderImpl catalogItem) {
            this.catalogItem = catalogItem != null ? catalogItem.build() : null;
        }

        @Override
        public final Builder catalogItem(CatalogItem catalogItem) {
            this.catalogItem = catalogItem;
            return this;
        }

        @Override
        public GetCatalogItemResponse build() {
            return new GetCatalogItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
