/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the custom domain name association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Association implements SdkPojo, Serializable, ToCopyableBuilder<Association.Builder, Association> {
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainCertificateArn")
            .getter(getter(Association::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateArn").build())
            .build();

    private static final SdkField<Instant> CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CustomDomainCertificateExpiryDate")
            .getter(getter(Association::customDomainCertificateExpiryDate))
            .setter(setter(Builder::customDomainCertificateExpiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateExpiryDate")
                    .build()).build();

    private static final SdkField<List<CertificateAssociation>> CERTIFICATE_ASSOCIATIONS_FIELD = SdkField
            .<List<CertificateAssociation>> builder(MarshallingType.LIST)
            .memberName("CertificateAssociations")
            .getter(getter(Association::certificateAssociations))
            .setter(setter(Builder::certificateAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CertificateAssociation")
                            .memberFieldInfo(
                                    SdkField.<CertificateAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CertificateAssociation").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_DATE_FIELD, CERTIFICATE_ASSOCIATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customDomainCertificateArn;

    private final Instant customDomainCertificateExpiryDate;

    private final List<CertificateAssociation> certificateAssociations;

    private Association(BuilderImpl builder) {
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainCertificateExpiryDate = builder.customDomainCertificateExpiryDate;
        this.certificateAssociations = builder.certificateAssociations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the certificate associated with the custom domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the certificate associated with the custom domain.
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The expiration date for the certificate.
     * </p>
     * 
     * @return The expiration date for the certificate.
     */
    public final Instant customDomainCertificateExpiryDate() {
        return customDomainCertificateExpiryDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCertificateAssociations() {
        return certificateAssociations != null && !(certificateAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all associated clusters and domain names tied to a specific certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateAssociations} method.
     * </p>
     * 
     * @return A list of all associated clusters and domain names tied to a specific certificate.
     */
    public final List<CertificateAssociation> certificateAssociations() {
        return certificateAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateAssociations() ? certificateAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Association)) {
            return false;
        }
        Association other = (Association) obj;
        return Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(customDomainCertificateExpiryDate(), other.customDomainCertificateExpiryDate())
                && hasCertificateAssociations() == other.hasCertificateAssociations()
                && Objects.equals(certificateAssociations(), other.certificateAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Association").add("CustomDomainCertificateArn", customDomainCertificateArn())
                .add("CustomDomainCertificateExpiryDate", customDomainCertificateExpiryDate())
                .add("CertificateAssociations", hasCertificateAssociations() ? certificateAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "CustomDomainCertificateExpiryDate":
            return Optional.ofNullable(clazz.cast(customDomainCertificateExpiryDate()));
        case "CertificateAssociations":
            return Optional.ofNullable(clazz.cast(certificateAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Association, T> g) {
        return obj -> g.apply((Association) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Association> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the certificate associated with the custom domain.
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The Amazon Resource Name (ARN) for the certificate associated with the custom domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The expiration date for the certificate.
         * </p>
         * 
         * @param customDomainCertificateExpiryDate
         *        The expiration date for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateExpiryDate(Instant customDomainCertificateExpiryDate);

        /**
         * <p>
         * A list of all associated clusters and domain names tied to a specific certificate.
         * </p>
         * 
         * @param certificateAssociations
         *        A list of all associated clusters and domain names tied to a specific certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAssociations(Collection<CertificateAssociation> certificateAssociations);

        /**
         * <p>
         * A list of all associated clusters and domain names tied to a specific certificate.
         * </p>
         * 
         * @param certificateAssociations
         *        A list of all associated clusters and domain names tied to a specific certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAssociations(CertificateAssociation... certificateAssociations);

        /**
         * <p>
         * A list of all associated clusters and domain names tied to a specific certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.CertificateAssociation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.CertificateAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.CertificateAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #certificateAssociations(List<CertificateAssociation>)}.
         * 
         * @param certificateAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.CertificateAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAssociations(java.util.Collection<CertificateAssociation>)
         */
        Builder certificateAssociations(Consumer<CertificateAssociation.Builder>... certificateAssociations);
    }

    static final class BuilderImpl implements Builder {
        private String customDomainCertificateArn;

        private Instant customDomainCertificateExpiryDate;

        private List<CertificateAssociation> certificateAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Association model) {
            customDomainCertificateArn(model.customDomainCertificateArn);
            customDomainCertificateExpiryDate(model.customDomainCertificateExpiryDate);
            certificateAssociations(model.certificateAssociations);
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Instant getCustomDomainCertificateExpiryDate() {
            return customDomainCertificateExpiryDate;
        }

        public final void setCustomDomainCertificateExpiryDate(Instant customDomainCertificateExpiryDate) {
            this.customDomainCertificateExpiryDate = customDomainCertificateExpiryDate;
        }

        @Override
        public final Builder customDomainCertificateExpiryDate(Instant customDomainCertificateExpiryDate) {
            this.customDomainCertificateExpiryDate = customDomainCertificateExpiryDate;
            return this;
        }

        public final List<CertificateAssociation.Builder> getCertificateAssociations() {
            List<CertificateAssociation.Builder> result = CertificateAssociationListCopier
                    .copyToBuilder(this.certificateAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateAssociations(Collection<CertificateAssociation.BuilderImpl> certificateAssociations) {
            this.certificateAssociations = CertificateAssociationListCopier.copyFromBuilder(certificateAssociations);
        }

        @Override
        public final Builder certificateAssociations(Collection<CertificateAssociation> certificateAssociations) {
            this.certificateAssociations = CertificateAssociationListCopier.copy(certificateAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAssociations(CertificateAssociation... certificateAssociations) {
            certificateAssociations(Arrays.asList(certificateAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAssociations(Consumer<CertificateAssociation.Builder>... certificateAssociations) {
            certificateAssociations(Stream.of(certificateAssociations)
                    .map(c -> CertificateAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Association build() {
            return new Association(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
