/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotSchedulesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeSnapshotSchedulesResponse.Builder, DescribeSnapshotSchedulesResponse> {
    private static final SdkField<List<SnapshotSchedule>> SNAPSHOT_SCHEDULES_FIELD = SdkField
            .<List<SnapshotSchedule>> builder(MarshallingType.LIST)
            .memberName("SnapshotSchedules")
            .getter(getter(DescribeSnapshotSchedulesResponse::snapshotSchedules))
            .setter(setter(Builder::snapshotSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotSchedule")
                            .memberFieldInfo(
                                    SdkField.<SnapshotSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotSchedule").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeSnapshotSchedulesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_SCHEDULES_FIELD,
            MARKER_FIELD));

    private final List<SnapshotSchedule> snapshotSchedules;

    private final String marker;

    private DescribeSnapshotSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotSchedules = builder.snapshotSchedules;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotSchedules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotSchedules() {
        return snapshotSchedules != null && !(snapshotSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SnapshotSchedules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotSchedules} method.
     * </p>
     * 
     * @return A list of SnapshotSchedules.
     */
    public final List<SnapshotSchedule> snapshotSchedules() {
        return snapshotSchedules;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotSchedules() ? snapshotSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotSchedulesResponse)) {
            return false;
        }
        DescribeSnapshotSchedulesResponse other = (DescribeSnapshotSchedulesResponse) obj;
        return hasSnapshotSchedules() == other.hasSnapshotSchedules()
                && Objects.equals(snapshotSchedules(), other.snapshotSchedules()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotSchedulesResponse")
                .add("SnapshotSchedules", hasSnapshotSchedules() ? snapshotSchedules() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotSchedules":
            return Optional.ofNullable(clazz.cast(snapshotSchedules()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotSchedulesResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSnapshotSchedulesResponse> {
        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * 
         * @param snapshotSchedules
         *        A list of SnapshotSchedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSchedules(Collection<SnapshotSchedule> snapshotSchedules);

        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * 
         * @param snapshotSchedules
         *        A list of SnapshotSchedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSchedules(SnapshotSchedule... snapshotSchedules);

        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.SnapshotSchedule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.SnapshotSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.SnapshotSchedule.Builder#build()} is called immediately
         * and its result is passed to {@link #snapshotSchedules(List<SnapshotSchedule>)}.
         * 
         * @param snapshotSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.SnapshotSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotSchedules(java.util.Collection<SnapshotSchedule>)
         */
        Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder>... snapshotSchedules);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>marker</code> parameter and retrying the command. If the
         *        <code>marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<SnapshotSchedule> snapshotSchedules = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotSchedulesResponse model) {
            super(model);
            snapshotSchedules(model.snapshotSchedules);
            marker(model.marker);
        }

        public final List<SnapshotSchedule.Builder> getSnapshotSchedules() {
            List<SnapshotSchedule.Builder> result = SnapshotScheduleListCopier.copyToBuilder(this.snapshotSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotSchedules(Collection<SnapshotSchedule.BuilderImpl> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copyFromBuilder(snapshotSchedules);
        }

        @Override
        public final Builder snapshotSchedules(Collection<SnapshotSchedule> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copy(snapshotSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(SnapshotSchedule... snapshotSchedules) {
            snapshotSchedules(Arrays.asList(snapshotSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder>... snapshotSchedules) {
            snapshotSchedules(Stream.of(snapshotSchedules).map(c -> SnapshotSchedule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeSnapshotSchedulesResponse build() {
            return new DescribeSnapshotSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
