/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The currently active data capture configuration used by your Endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCaptureConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCaptureConfigSummary.Builder, DataCaptureConfigSummary> {
    private static final SdkField<Boolean> ENABLE_CAPTURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCapture").getter(getter(DataCaptureConfigSummary::enableCapture))
            .setter(setter(Builder::enableCapture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCapture").build()).build();

    private static final SdkField<String> CAPTURE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureStatus").getter(getter(DataCaptureConfigSummary::captureStatusAsString))
            .setter(setter(Builder::captureStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureStatus").build()).build();

    private static final SdkField<Integer> CURRENT_SAMPLING_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CurrentSamplingPercentage")
            .getter(getter(DataCaptureConfigSummary::currentSamplingPercentage))
            .setter(setter(Builder::currentSamplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSamplingPercentage").build())
            .build();

    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationS3Uri").getter(getter(DataCaptureConfigSummary::destinationS3Uri))
            .setter(setter(Builder::destinationS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DataCaptureConfigSummary::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_CAPTURE_FIELD,
            CAPTURE_STATUS_FIELD, CURRENT_SAMPLING_PERCENTAGE_FIELD, DESTINATION_S3_URI_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableCapture;

    private final String captureStatus;

    private final Integer currentSamplingPercentage;

    private final String destinationS3Uri;

    private final String kmsKeyId;

    private DataCaptureConfigSummary(BuilderImpl builder) {
        this.enableCapture = builder.enableCapture;
        this.captureStatus = builder.captureStatus;
        this.currentSamplingPercentage = builder.currentSamplingPercentage;
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * Whether data capture is enabled or disabled.
     * </p>
     * 
     * @return Whether data capture is enabled or disabled.
     */
    public final Boolean enableCapture() {
        return enableCapture;
    }

    /**
     * <p>
     * Whether data capture is currently functional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureStatus}
     * will return {@link CaptureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureStatusAsString}.
     * </p>
     * 
     * @return Whether data capture is currently functional.
     * @see CaptureStatus
     */
    public final CaptureStatus captureStatus() {
        return CaptureStatus.fromValue(captureStatus);
    }

    /**
     * <p>
     * Whether data capture is currently functional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureStatus}
     * will return {@link CaptureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureStatusAsString}.
     * </p>
     * 
     * @return Whether data capture is currently functional.
     * @see CaptureStatus
     */
    public final String captureStatusAsString() {
        return captureStatus;
    }

    /**
     * <p>
     * The percentage of requests being captured by your Endpoint.
     * </p>
     * 
     * @return The percentage of requests being captured by your Endpoint.
     */
    public final Integer currentSamplingPercentage() {
        return currentSamplingPercentage;
    }

    /**
     * <p>
     * The Amazon S3 location being used to capture the data.
     * </p>
     * 
     * @return The Amazon S3 location being used to capture the data.
     */
    public final String destinationS3Uri() {
        return destinationS3Uri;
    }

    /**
     * <p>
     * The KMS key being used to encrypt the data in Amazon S3.
     * </p>
     * 
     * @return The KMS key being used to encrypt the data in Amazon S3.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableCapture());
        hashCode = 31 * hashCode + Objects.hashCode(captureStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentSamplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCaptureConfigSummary)) {
            return false;
        }
        DataCaptureConfigSummary other = (DataCaptureConfigSummary) obj;
        return Objects.equals(enableCapture(), other.enableCapture())
                && Objects.equals(captureStatusAsString(), other.captureStatusAsString())
                && Objects.equals(currentSamplingPercentage(), other.currentSamplingPercentage())
                && Objects.equals(destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCaptureConfigSummary").add("EnableCapture", enableCapture())
                .add("CaptureStatus", captureStatusAsString()).add("CurrentSamplingPercentage", currentSamplingPercentage())
                .add("DestinationS3Uri", destinationS3Uri()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableCapture":
            return Optional.ofNullable(clazz.cast(enableCapture()));
        case "CaptureStatus":
            return Optional.ofNullable(clazz.cast(captureStatusAsString()));
        case "CurrentSamplingPercentage":
            return Optional.ofNullable(clazz.cast(currentSamplingPercentage()));
        case "DestinationS3Uri":
            return Optional.ofNullable(clazz.cast(destinationS3Uri()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCaptureConfigSummary, T> g) {
        return obj -> g.apply((DataCaptureConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCaptureConfigSummary> {
        /**
         * <p>
         * Whether data capture is enabled or disabled.
         * </p>
         * 
         * @param enableCapture
         *        Whether data capture is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCapture(Boolean enableCapture);

        /**
         * <p>
         * Whether data capture is currently functional.
         * </p>
         * 
         * @param captureStatus
         *        Whether data capture is currently functional.
         * @see CaptureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureStatus
         */
        Builder captureStatus(String captureStatus);

        /**
         * <p>
         * Whether data capture is currently functional.
         * </p>
         * 
         * @param captureStatus
         *        Whether data capture is currently functional.
         * @see CaptureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureStatus
         */
        Builder captureStatus(CaptureStatus captureStatus);

        /**
         * <p>
         * The percentage of requests being captured by your Endpoint.
         * </p>
         * 
         * @param currentSamplingPercentage
         *        The percentage of requests being captured by your Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSamplingPercentage(Integer currentSamplingPercentage);

        /**
         * <p>
         * The Amazon S3 location being used to capture the data.
         * </p>
         * 
         * @param destinationS3Uri
         *        The Amazon S3 location being used to capture the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Uri(String destinationS3Uri);

        /**
         * <p>
         * The KMS key being used to encrypt the data in Amazon S3.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key being used to encrypt the data in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableCapture;

        private String captureStatus;

        private Integer currentSamplingPercentage;

        private String destinationS3Uri;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCaptureConfigSummary model) {
            enableCapture(model.enableCapture);
            captureStatus(model.captureStatus);
            currentSamplingPercentage(model.currentSamplingPercentage);
            destinationS3Uri(model.destinationS3Uri);
            kmsKeyId(model.kmsKeyId);
        }

        public final Boolean getEnableCapture() {
            return enableCapture;
        }

        public final void setEnableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
        }

        @Override
        public final Builder enableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
            return this;
        }

        public final String getCaptureStatus() {
            return captureStatus;
        }

        public final void setCaptureStatus(String captureStatus) {
            this.captureStatus = captureStatus;
        }

        @Override
        public final Builder captureStatus(String captureStatus) {
            this.captureStatus = captureStatus;
            return this;
        }

        @Override
        public final Builder captureStatus(CaptureStatus captureStatus) {
            this.captureStatus(captureStatus == null ? null : captureStatus.toString());
            return this;
        }

        public final Integer getCurrentSamplingPercentage() {
            return currentSamplingPercentage;
        }

        public final void setCurrentSamplingPercentage(Integer currentSamplingPercentage) {
            this.currentSamplingPercentage = currentSamplingPercentage;
        }

        @Override
        public final Builder currentSamplingPercentage(Integer currentSamplingPercentage) {
            this.currentSamplingPercentage = currentSamplingPercentage;
            return this;
        }

        public final String getDestinationS3Uri() {
            return destinationS3Uri;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public DataCaptureConfigSummary build() {
            return new DataCaptureConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
