/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantRoutingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantRoutingConfig.Builder, ProductionVariantRoutingConfig> {
    private static final SdkField<String> ROUTING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingStrategy").getter(getter(ProductionVariantRoutingConfig::routingStrategyAsString))
            .setter(setter(Builder::routingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String routingStrategy;

    private ProductionVariantRoutingConfig(BuilderImpl builder) {
        this.routingStrategy = builder.routingStrategy;
    }

    /**
     * <p>
     * Sets how the endpoint routes incoming traffic:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have more
     * capacity to process them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingStrategy}
     * will return {@link RoutingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routingStrategyAsString}.
     * </p>
     * 
     * @return Sets how the endpoint routes incoming traffic:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have
     *         more capacity to process them.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
     *         </p>
     *         </li>
     * @see RoutingStrategy
     */
    public final RoutingStrategy routingStrategy() {
        return RoutingStrategy.fromValue(routingStrategy);
    }

    /**
     * <p>
     * Sets how the endpoint routes incoming traffic:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have more
     * capacity to process them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingStrategy}
     * will return {@link RoutingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routingStrategyAsString}.
     * </p>
     * 
     * @return Sets how the endpoint routes incoming traffic:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have
     *         more capacity to process them.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
     *         </p>
     *         </li>
     * @see RoutingStrategy
     */
    public final String routingStrategyAsString() {
        return routingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(routingStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantRoutingConfig)) {
            return false;
        }
        ProductionVariantRoutingConfig other = (ProductionVariantRoutingConfig) obj;
        return Objects.equals(routingStrategyAsString(), other.routingStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantRoutingConfig").add("RoutingStrategy", routingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingStrategy":
            return Optional.ofNullable(clazz.cast(routingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantRoutingConfig, T> g) {
        return obj -> g.apply((ProductionVariantRoutingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantRoutingConfig> {
        /**
         * <p>
         * Sets how the endpoint routes incoming traffic:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have
         * more capacity to process them.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routingStrategy
         *        Sets how the endpoint routes incoming traffic:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that
         *        have more capacity to process them.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
         *        </p>
         *        </li>
         * @see RoutingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategy
         */
        Builder routingStrategy(String routingStrategy);

        /**
         * <p>
         * Sets how the endpoint routes incoming traffic:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that have
         * more capacity to process them.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routingStrategy
         *        Sets how the endpoint routes incoming traffic:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LEAST_OUTSTANDING_REQUESTS</code>: The endpoint routes requests to the specific instances that
         *        have more capacity to process them.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANDOM</code>: The endpoint routes each request to a randomly chosen instance.
         *        </p>
         *        </li>
         * @see RoutingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategy
         */
        Builder routingStrategy(RoutingStrategy routingStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String routingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantRoutingConfig model) {
            routingStrategy(model.routingStrategy);
        }

        public final String getRoutingStrategy() {
            return routingStrategy;
        }

        public final void setRoutingStrategy(String routingStrategy) {
            this.routingStrategy = routingStrategy;
        }

        @Override
        public final Builder routingStrategy(String routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy(routingStrategy == null ? null : routingStrategy.toString());
            return this;
        }

        @Override
        public ProductionVariantRoutingConfig build() {
            return new ProductionVariantRoutingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
