/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferenceExperimentStatus {
    CREATING("Creating"),
    CREATED("Created"),
    UPDATING("Updating"),
    RUNNING("Running"),
    STARTING("Starting"),
    STOPPING("Stopping"),
    COMPLETED("Completed"),
    CANCELLED("Cancelled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferenceExperimentStatus> VALUE_MAP;
    private final String value;

    private InferenceExperimentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferenceExperimentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferenceExperimentStatus> knownValues() {
        EnumSet<InferenceExperimentStatus> knownValues = EnumSet.allOf(InferenceExperimentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferenceExperimentStatus.class, InferenceExperimentStatus::toString);
    }
}

