/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustedTokenIssuerResponse extends SsoAdminResponse implements
        ToCopyableBuilder<CreateTrustedTokenIssuerResponse.Builder, CreateTrustedTokenIssuerResponse> {
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(CreateTrustedTokenIssuerResponse::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRUSTED_TOKEN_ISSUER_ARN_FIELD));

    private final String trustedTokenIssuerArn;

    private CreateTrustedTokenIssuerResponse(BuilderImpl builder) {
        super(builder);
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
    }

    /**
     * <p>
     * The ARN of the new trusted token issuer configuration.
     * </p>
     * 
     * @return The ARN of the new trusted token issuer configuration.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustedTokenIssuerResponse)) {
            return false;
        }
        CreateTrustedTokenIssuerResponse other = (CreateTrustedTokenIssuerResponse) obj;
        return Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustedTokenIssuerResponse").add("TrustedTokenIssuerArn", trustedTokenIssuerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustedTokenIssuerResponse, T> g) {
        return obj -> g.apply((CreateTrustedTokenIssuerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrustedTokenIssuerResponse> {
        /**
         * <p>
         * The ARN of the new trusted token issuer configuration.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        The ARN of the new trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String trustedTokenIssuerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustedTokenIssuerResponse model) {
            super(model);
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        @Override
        public CreateTrustedTokenIssuerResponse build() {
            return new CreateTrustedTokenIssuerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
