/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationAssignmentsForPrincipalRequest extends SsoAdminRequest implements
        ToCopyableBuilder<ListApplicationAssignmentsForPrincipalRequest.Builder, ListApplicationAssignmentsForPrincipalRequest> {
    private static final SdkField<ListApplicationAssignmentsFilter> FILTER_FIELD = SdkField
            .<ListApplicationAssignmentsFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(ListApplicationAssignmentsForPrincipalRequest::filter)).setter(setter(Builder::filter))
            .constructor(ListApplicationAssignmentsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(ListApplicationAssignmentsForPrincipalRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListApplicationAssignmentsForPrincipalRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationAssignmentsForPrincipalRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(ListApplicationAssignmentsForPrincipalRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(ListApplicationAssignmentsForPrincipalRequest::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            INSTANCE_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD));

    private final ListApplicationAssignmentsFilter filter;

    private final String instanceArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String principalId;

    private final String principalType;

    private ListApplicationAssignmentsForPrincipalRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.instanceArn = builder.instanceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
    }

    /**
     * <p>
     * Filters the output to include only assignments associated with the application that has the specified ARN.
     * </p>
     * 
     * @return Filters the output to include only assignments associated with the application that has the specified
     *         ARN.
     */
    public final ListApplicationAssignmentsFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Specifies the instance of IAM Identity Center that contains principal and applications.
     * </p>
     * 
     * @return Specifies the instance of IAM Identity Center that contains principal and applications.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included in each response. If additional items exist beyond
     * the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include
     * the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the
     * next set of results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included in each response. If additional items exist
     *         beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
     *         null). Include the specified value as the <code>NextToken</code> request parameter in the next call to
     *         the operation to get the next set of results. Note that the service might return fewer results than the
     *         maximum even when there are more results available. You should check <code>NextToken</code> after every
     *         operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the unique identifier of the principal for which you want to retrieve its assignments.
     * </p>
     * 
     * @return Specifies the unique identifier of the principal for which you want to retrieve its assignments.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * Specifies the type of the principal for which you want to retrieve its assignments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the principal for which you want to retrieve its assignments.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * Specifies the type of the principal for which you want to retrieve its assignments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the principal for which you want to retrieve its assignments.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAssignmentsForPrincipalRequest)) {
            return false;
        }
        ListApplicationAssignmentsForPrincipalRequest other = (ListApplicationAssignmentsForPrincipalRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationAssignmentsForPrincipalRequest").add("Filter", filter())
                .add("InstanceArn", instanceArn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("PrincipalId", principalId()).add("PrincipalType", principalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAssignmentsForPrincipalRequest, T> g) {
        return obj -> g.apply((ListApplicationAssignmentsForPrincipalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationAssignmentsForPrincipalRequest> {
        /**
         * <p>
         * Filters the output to include only assignments associated with the application that has the specified ARN.
         * </p>
         * 
         * @param filter
         *        Filters the output to include only assignments associated with the application that has the specified
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListApplicationAssignmentsFilter filter);

        /**
         * <p>
         * Filters the output to include only assignments associated with the application that has the specified ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListApplicationAssignmentsFilter.Builder}
         * avoiding the need to create one manually via {@link ListApplicationAssignmentsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListApplicationAssignmentsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(ListApplicationAssignmentsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListApplicationAssignmentsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListApplicationAssignmentsFilter)
         */
        default Builder filter(Consumer<ListApplicationAssignmentsFilter.Builder> filter) {
            return filter(ListApplicationAssignmentsFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Specifies the instance of IAM Identity Center that contains principal and applications.
         * </p>
         * 
         * @param instanceArn
         *        Specifies the instance of IAM Identity Center that contains principal and applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Specifies the total number of results that you want included in each response. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next set of results. Note that the service might return fewer results than the maximum
         * even when there are more results available. You should check <code>NextToken</code> after every operation to
         * ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included in each response. If additional items
         *        exist beyond the number you specify, the <code>NextToken</code> response element is returned with a
         *        value (not null). Include the specified value as the <code>NextToken</code> request parameter in the
         *        next call to the operation to get the next set of results. Note that the service might return fewer
         *        results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the unique identifier of the principal for which you want to retrieve its assignments.
         * </p>
         * 
         * @param principalId
         *        Specifies the unique identifier of the principal for which you want to retrieve its assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * Specifies the type of the principal for which you want to retrieve its assignments.
         * </p>
         * 
         * @param principalType
         *        Specifies the type of the principal for which you want to retrieve its assignments.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * Specifies the type of the principal for which you want to retrieve its assignments.
         * </p>
         * 
         * @param principalType
         *        Specifies the type of the principal for which you want to retrieve its assignments.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private ListApplicationAssignmentsFilter filter;

        private String instanceArn;

        private Integer maxResults;

        private String nextToken;

        private String principalId;

        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAssignmentsForPrincipalRequest model) {
            super(model);
            filter(model.filter);
            instanceArn(model.instanceArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            principalId(model.principalId);
            principalType(model.principalType);
        }

        public final ListApplicationAssignmentsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListApplicationAssignmentsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListApplicationAssignmentsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationAssignmentsForPrincipalRequest build() {
            return new ListApplicationAssignmentsForPrincipalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
