/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationAuthenticationMethodsResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListApplicationAuthenticationMethodsResponse.Builder, ListApplicationAuthenticationMethodsResponse> {
    private static final SdkField<List<AuthenticationMethodItem>> AUTHENTICATION_METHODS_FIELD = SdkField
            .<List<AuthenticationMethodItem>> builder(MarshallingType.LIST)
            .memberName("AuthenticationMethods")
            .getter(getter(ListApplicationAuthenticationMethodsResponse::authenticationMethods))
            .setter(setter(Builder::authenticationMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthenticationMethodItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthenticationMethodItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationAuthenticationMethodsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_METHODS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuthenticationMethodItem> authenticationMethods;

    private final String nextToken;

    private ListApplicationAuthenticationMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationMethods = builder.authenticationMethods;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationMethods property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationMethods() {
        return authenticationMethods != null && !(authenticationMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array list of authentication methods for the specified application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationMethods} method.
     * </p>
     * 
     * @return An array list of authentication methods for the specified application.
     */
    public final List<AuthenticationMethodItem> authenticationMethods() {
        return authenticationMethods;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationMethods() ? authenticationMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAuthenticationMethodsResponse)) {
            return false;
        }
        ListApplicationAuthenticationMethodsResponse other = (ListApplicationAuthenticationMethodsResponse) obj;
        return hasAuthenticationMethods() == other.hasAuthenticationMethods()
                && Objects.equals(authenticationMethods(), other.authenticationMethods())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationAuthenticationMethodsResponse")
                .add("AuthenticationMethods", hasAuthenticationMethods() ? authenticationMethods() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationMethods":
            return Optional.ofNullable(clazz.cast(authenticationMethods()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAuthenticationMethodsResponse, T> g) {
        return obj -> g.apply((ListApplicationAuthenticationMethodsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationAuthenticationMethodsResponse> {
        /**
         * <p>
         * An array list of authentication methods for the specified application.
         * </p>
         * 
         * @param authenticationMethods
         *        An array list of authentication methods for the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMethods(Collection<AuthenticationMethodItem> authenticationMethods);

        /**
         * <p>
         * An array list of authentication methods for the specified application.
         * </p>
         * 
         * @param authenticationMethods
         *        An array list of authentication methods for the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMethods(AuthenticationMethodItem... authenticationMethods);

        /**
         * <p>
         * An array list of authentication methods for the specified application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationMethods(List<AuthenticationMethodItem>)}.
         * 
         * @param authenticationMethods
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMethods(java.util.Collection<AuthenticationMethodItem>)
         */
        Builder authenticationMethods(Consumer<AuthenticationMethodItem.Builder>... authenticationMethods);

        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AuthenticationMethodItem> authenticationMethods = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAuthenticationMethodsResponse model) {
            super(model);
            authenticationMethods(model.authenticationMethods);
            nextToken(model.nextToken);
        }

        public final List<AuthenticationMethodItem.Builder> getAuthenticationMethods() {
            List<AuthenticationMethodItem.Builder> result = AuthenticationMethodsCopier.copyToBuilder(this.authenticationMethods);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationMethods(Collection<AuthenticationMethodItem.BuilderImpl> authenticationMethods) {
            this.authenticationMethods = AuthenticationMethodsCopier.copyFromBuilder(authenticationMethods);
        }

        @Override
        public final Builder authenticationMethods(Collection<AuthenticationMethodItem> authenticationMethods) {
            this.authenticationMethods = AuthenticationMethodsCopier.copy(authenticationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationMethods(AuthenticationMethodItem... authenticationMethods) {
            authenticationMethods(Arrays.asList(authenticationMethods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationMethods(Consumer<AuthenticationMethodItem.Builder>... authenticationMethods) {
            authenticationMethods(Stream.of(authenticationMethods)
                    .map(c -> AuthenticationMethodItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationAuthenticationMethodsResponse build() {
            return new ListApplicationAuthenticationMethodsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
