/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The impersonation rule that matched the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImpersonationMatchedRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ImpersonationMatchedRule.Builder, ImpersonationMatchedRule> {
    private static final SdkField<String> IMPERSONATION_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRuleId").getter(getter(ImpersonationMatchedRule::impersonationRuleId))
            .setter(setter(Builder::impersonationRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRuleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImpersonationMatchedRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_RULE_ID_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String impersonationRuleId;

    private final String name;

    private ImpersonationMatchedRule(BuilderImpl builder) {
        this.impersonationRuleId = builder.impersonationRuleId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the rule that matched the input
     * </p>
     * 
     * @return The ID of the rule that matched the input
     */
    public final String impersonationRuleId() {
        return impersonationRuleId;
    }

    /**
     * <p>
     * The name of the rule that matched the input.
     * </p>
     * 
     * @return The name of the rule that matched the input.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationMatchedRule)) {
            return false;
        }
        ImpersonationMatchedRule other = (ImpersonationMatchedRule) obj;
        return Objects.equals(impersonationRuleId(), other.impersonationRuleId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImpersonationMatchedRule").add("ImpersonationRuleId", impersonationRuleId()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImpersonationRuleId":
            return Optional.ofNullable(clazz.cast(impersonationRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImpersonationMatchedRule, T> g) {
        return obj -> g.apply((ImpersonationMatchedRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImpersonationMatchedRule> {
        /**
         * <p>
         * The ID of the rule that matched the input
         * </p>
         * 
         * @param impersonationRuleId
         *        The ID of the rule that matched the input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRuleId(String impersonationRuleId);

        /**
         * <p>
         * The name of the rule that matched the input.
         * </p>
         * 
         * @param name
         *        The name of the rule that matched the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String impersonationRuleId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ImpersonationMatchedRule model) {
            impersonationRuleId(model.impersonationRuleId);
            name(model.name);
        }

        public final String getImpersonationRuleId() {
            return impersonationRuleId;
        }

        public final void setImpersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
        }

        @Override
        public final Builder impersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ImpersonationMatchedRule build() {
            return new ImpersonationMatchedRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
