/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MailDomainsCopier {
    static List<MailDomainSummary> copy(Collection<? extends MailDomainSummary> mailDomainsParam) {
        List<MailDomainSummary> list;
        if (mailDomainsParam == null || mailDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MailDomainSummary> modifiableList = new ArrayList<>();
            mailDomainsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MailDomainSummary> copyFromBuilder(Collection<? extends MailDomainSummary.Builder> mailDomainsParam) {
        List<MailDomainSummary> list;
        if (mailDomainsParam == null || mailDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MailDomainSummary> modifiableList = new ArrayList<>();
            mailDomainsParam.forEach(entry -> {
                MailDomainSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MailDomainSummary.Builder> copyToBuilder(Collection<? extends MailDomainSummary> mailDomainsParam) {
        List<MailDomainSummary.Builder> list;
        if (mailDomainsParam == null || mailDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MailDomainSummary.Builder> modifiableList = new ArrayList<>();
            mailDomainsParam.forEach(entry -> {
                MailDomainSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
