/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.mlsql.sources;

import java.io.DataOutputStream;
import java.net.Socket;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.mlsql.sources.MLSQLBinLogDataSource$$anonfun$org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$;
import org.apache.spark.sql.mlsql.sources.MLSQLBinLogSource;
import org.apache.spark.sql.mlsql.sources.TempSocketServerInDriver;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.BinLogSocketServerCommand$;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.BinLogSocketServerInExecutor;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.BinLogSocketServerInExecutor$;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.BinlogOffset;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.BinlogOffset$;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ExecutorBinlogServer;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.MySQLBinlogServer;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.MySQLConnectionInfo;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ReportBinlogSocketServerHostAndPort;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ShutdownBinlogServer;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.SocketServerInExecutor$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.TaskCompletionListener;
import org.apache.spark.util.TaskFailureListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import streaming.common.HDFSOperator$;
import tech.mlsql.common.PathFun$;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u001f\t)R\nT*R\u0019\nKg\u000eT8h\t\u0006$\u0018mU8ve\u000e,'BA\u0002\u0005\u0003\u001d\u0019x.\u001e:dKNT!!\u0002\u0004\u0002\u000b5d7/\u001d7\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bc\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]IR\"\u0001\r\u000b\u0005\r1\u0011B\u0001\u000e\u0019\u0005Q\u0019FO]3b[N{WO]2f!J|g/\u001b3feB\u0011q\u0003H\u0005\u0003;a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006I\u0001!\t%J\u0001\rg>,(oY3TG\",W.\u0019\u000b\u0006MYb\u0014i\u0011\t\u0005#\u001dJ\u0003'\u0003\u0002)%\t1A+\u001e9mKJ\u0002\"AK\u0017\u000f\u0005EY\u0013B\u0001\u0017\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u0012\u0002CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t)$G\u0001\u0006TiJ,8\r\u001e+za\u0016DQaN\u0012A\u0002a\n!b]9m\u0007>tG/\u001a=u!\tI$(D\u0001\u0007\u0013\tYdA\u0001\u0006T#2\u001buN\u001c;fqRDQ!P\u0012A\u0002y\naa]2iK6\f\u0007cA\t@a%\u0011\u0001I\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\t\u001b\u0003\u0019A\u0015\u0002\u0019A\u0014xN^5eKJt\u0015-\\3\t\u000b\u0011\u001b\u0003\u0019A#\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003+\r&J\u0013BA$0\u0005\ri\u0015\r\u001d\u0005\u0006\u0013\u0002!\tES\u0001\rGJ,\u0017\r^3T_V\u00148-\u001a\u000b\u0007\u0017N#fk\u0016-\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!C:ue\u0016\fW.\u001b8h\u0015\t\u0001f!A\u0005fq\u0016\u001cW\u000f^5p]&\u0011!+\u0014\u0002\u0007'>,(oY3\t\u000b]B\u0005\u0019\u0001\u001d\t\u000bUC\u0005\u0019A\u0015\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\t\u000buB\u0005\u0019\u0001 \t\u000b\tC\u0005\u0019A\u0015\t\u000b\u0011C\u0005\u0019A#\t\u000bi\u0003A\u0011I.\u0002\u0013MDwN\u001d;OC6,G#A\u0015")
public class MLSQLBinLogDataSource
implements StreamSourceProvider,
DataSourceRegister {
    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        Predef$.MODULE$.require(schema.isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka source has a fixed schema and cannot be set with a custom one";
            }
        });
        return new Tuple2((Object)this.shortName(), (Object)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        None$ none$;
        BoxedUnit boxedUnit;
        SparkSession spark = sqlContext.sparkSession();
        String logPrefix = (String)parameters.getOrElse((Object)"logPrefix", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String bingLogHost = (String)parameters.apply((Object)"host");
        int bingLogPort = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)"port"))).toInt();
        String bingLogUserName = (String)parameters.apply((Object)"userName");
        String bingLogPassword = (String)parameters.apply((Object)"password");
        Option bingLogNamePrefix = parameters.get((Object)"bingLogNamePrefix");
        Option databaseNamePattern = parameters.get((Object)"databaseNamePattern");
        Option tableNamePattern = parameters.get((Object)"tableNamePattern");
        Option startingOffsets = parameters.get((Object)"startingOffsets").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongOffset apply(String f) {
                return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(f)).toLong());
            }
        });
        Option option = startingOffsets;
        if (option instanceof Some) {
            Some some = (Some)option;
            LongOffset value = (LongOffset)some.x();
            Predef$.MODULE$.assert(((Object)BoxesRunTime.boxToLong((long)value.offset())).toString().length() >= 14, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The startingOffsets is combined at least 14 numbers. The first six numbers are fileId, the left thirteen numbers are file line number.";
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            boxedUnit = BoxedUnit.UNIT;
        }
        String checkPointDir = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(metadataPath)).stripSuffix("/").split("/")).dropRight(2)).mkString("/");
        try {
            none$ = Option$.MODULE$.apply((Object)new LongOffset(this.getOffsetFromCk$1(checkPointDir)));
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        None$ offsetFromCk = none$;
        None$ finalStartingOffsets = offsetFromCk.isDefined() ? offsetFromCk : startingOffsets;
        Predef$.MODULE$.assert(finalStartingOffsets.isDefined() == bingLogNamePrefix.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "startingOffsets(or Checkpoint have offset files) and bingLogNamePrefix should exists together ";
            }
        });
        Option startOffsetInFile = finalStartingOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BinlogOffset apply(LongOffset f) {
                return BinlogOffset$.MODULE$.fromOffset(f.offset());
            }
        });
        Option binlogFilename = startOffsetInFile.map((Function1)new Serializable(this, bingLogNamePrefix){
            public static final long serialVersionUID = 0L;
            private final Option bingLogNamePrefix$1;

            public final String apply(BinlogOffset f) {
                return BinlogOffset$.MODULE$.toFileName((String)this.bingLogNamePrefix$1.get(), f.fileId());
            }
            {
                this.bingLogNamePrefix$1 = bingLogNamePrefix$1;
            }
        });
        Option binlogPos = startOffsetInFile.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(BinlogOffset x$2) {
                return x$2.pos();
            }
        });
        AtomicReference<ReportBinlogSocketServerHostAndPort> executorBinlogServerInfoRef = new AtomicReference<ReportBinlogSocketServerHostAndPort>();
        TempSocketServerInDriver tempSocketServerInDriver = new TempSocketServerInDriver(executorBinlogServerInfoRef);
        String tempSocketServerHost = tempSocketServerInDriver.host();
        int tempSocketServerPort = tempSocketServerInDriver.port();
        long maxBinlogQueueSize = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"maxBinlogQueueSize", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "500000";
            }
        }))).toLong();
        String binlogServerId = UUID.randomUUID().toString();
        Configuration hadoopConfig = spark.sparkContext().hadoopConfiguration();
        SerializableConfiguration broadcastedHadoopConf = new SerializableConfiguration(hadoopConfig);
        new Thread(this, spark, bingLogHost, bingLogPort, bingLogUserName, bingLogPassword, databaseNamePattern, tableNamePattern, checkPointDir, binlogFilename, binlogPos, tempSocketServerHost, tempSocketServerPort, maxBinlogQueueSize, binlogServerId, broadcastedHadoopConf){
            private final /* synthetic */ MLSQLBinLogDataSource $outer;
            private final SparkSession spark$1;
            private final String bingLogHost$1;
            private final int bingLogPort$1;
            private final String bingLogUserName$1;
            private final String bingLogPassword$1;
            private final Option databaseNamePattern$1;
            private final Option tableNamePattern$1;
            private final String checkPointDir$1;
            private final Option binlogFilename$1;
            private final Option binlogPos$1;
            private final String tempSocketServerHost$1;
            private final int tempSocketServerPort$1;
            private final long maxBinlogQueueSize$1;
            private final String binlogServerId$1;
            private final SerializableConfiguration broadcastedHadoopConf$1;

            public void run() {
                this.$outer.org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$launchBinlogServer$1(this.spark$1, this.bingLogHost$1, this.bingLogPort$1, this.bingLogUserName$1, this.bingLogPassword$1, this.databaseNamePattern$1, this.tableNamePattern$1, this.checkPointDir$1, this.binlogFilename$1, this.binlogPos$1, this.tempSocketServerHost$1, this.tempSocketServerPort$1, this.maxBinlogQueueSize$1, this.binlogServerId$1, this.broadcastedHadoopConf$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.spark$1 = spark$1;
                this.bingLogHost$1 = bingLogHost$1;
                this.bingLogPort$1 = bingLogPort$1;
                this.bingLogUserName$1 = bingLogUserName$1;
                this.bingLogPassword$1 = bingLogPassword$1;
                this.databaseNamePattern$1 = databaseNamePattern$1;
                this.tableNamePattern$1 = tableNamePattern$1;
                this.checkPointDir$1 = checkPointDir$1;
                this.binlogFilename$1 = binlogFilename$1;
                this.binlogPos$1 = binlogPos$1;
                this.tempSocketServerHost$1 = tempSocketServerHost$1;
                this.tempSocketServerPort$1 = tempSocketServerPort$1;
                this.maxBinlogQueueSize$1 = maxBinlogQueueSize$1;
                this.binlogServerId$1 = binlogServerId$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                super("launch-binlog-socket-server-in-spark-job");
                this.setDaemon(true);
            }
        }.start();
        int count = 60;
        ExecutorBinlogServer executorBinlogServer = null;
        while (executorBinlogServerInfoRef.get() == null) {
            Thread.sleep(1000L);
            --count;
        }
        if (executorBinlogServerInfoRef.get() == null) {
            throw new RuntimeException("start BinLogSocketServerInExecutor fail");
        }
        ReportBinlogSocketServerHostAndPort report = executorBinlogServerInfoRef.get();
        executorBinlogServer = new ExecutorBinlogServer(report.host(), report.port());
        return new MLSQLBinLogSource(executorBinlogServer, sqlContext.sparkSession(), metadataPath, (Option<LongOffset>)finalStartingOffsets, (Map<String, String>)parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binlogServerId"), (Object)binlogServerId)}))));
    }

    public String shortName() {
        return "mysql-binglog";
    }

    private final long getOffsetFromCk$1(String checkPointDir$1) {
        String offsetPath = PathFun$.MODULE$.apply(checkPointDir$1).add("offsets").toPath();
        Path lastFile = (Path)((Tuple2)((TraversableLike)((SeqLike)((TraversableLike)HDFSOperator$.MODULE$.listFiles(offsetPath).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().endsWith(".tmp.crc");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Path> apply(FileStatus fileName) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])fileName.getPath().getName().split("/")).last())).toInt()), (Object)fileName.getPath());
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Path> f) {
                return f._1$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).last())._2();
        String content = HDFSOperator$.MODULE$.readFile(lastFile.toString());
        return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])content.split("\n")).last())).toLong();
    }

    public final ExecutorBinlogServer[] org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$launchBinlogServer$1(SparkSession spark$1, String bingLogHost$1, int bingLogPort$1, String bingLogUserName$1, String bingLogPassword$1, Option databaseNamePattern$1, Option tableNamePattern$1, String checkPointDir$1, Option binlogFilename$1, Option binlogPos$1, String tempSocketServerHost$1, int tempSocketServerPort$1, long maxBinlogQueueSize$1, String binlogServerId$1, SerializableConfiguration broadcastedHadoopConf$1) {
        spark$1.sparkContext().setJobGroup(binlogServerId$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binlog server (", ":", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bingLogHost$1, BoxesRunTime.boxToInteger((int)bingLogPort$1)})), true);
        return (ExecutorBinlogServer[])spark$1.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"launch-binlog-socket-server"})), 1, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, bingLogHost$1, bingLogPort$1, bingLogUserName$1, bingLogPassword$1, databaseNamePattern$1, tableNamePattern$1, checkPointDir$1, binlogFilename$1, binlogPos$1, tempSocketServerHost$1, tempSocketServerPort$1, maxBinlogQueueSize$1, broadcastedHadoopConf$1){
            public static final long serialVersionUID = 0L;
            private final String bingLogHost$1;
            private final int bingLogPort$1;
            private final String bingLogUserName$1;
            private final String bingLogPassword$1;
            private final Option databaseNamePattern$1;
            private final Option tableNamePattern$1;
            private final String checkPointDir$1;
            private final Option binlogFilename$1;
            private final Option binlogPos$1;
            private final String tempSocketServerHost$1;
            private final int tempSocketServerPort$1;
            private final long maxBinlogQueueSize$1;
            private final SerializableConfiguration broadcastedHadoopConf$1;

            public final ExecutorBinlogServer apply(String item) {
                AtomicReference<TaskContext> taskContextRef = new AtomicReference<TaskContext>();
                taskContextRef.set(TaskContext$.MODULE$.get());
                BinLogSocketServerInExecutor<V> executorBinlogServer = new BinLogSocketServerInExecutor<V>(taskContextRef, this.checkPointDir$1, this.broadcastedHadoopConf$1.value(), BinLogSocketServerInExecutor$.MODULE$.$lessinit$greater$default$4());
                executorBinlogServer.setMaxBinlogQueueSize(this.maxBinlogQueueSize$1);
                TaskContext$.MODULE$.get().addTaskFailureListener(new TaskFailureListener(this, taskContextRef, executorBinlogServer){
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$launchBinlogServer$1$1 $outer;
                    private final AtomicReference taskContextRef$1;
                    private final BinLogSocketServerInExecutor executorBinlogServer$1;

                    public void onTaskFailure(TaskContext context, Throwable error) {
                        this.taskContextRef$1.set(null);
                        this.$outer.org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$anonfun$$sendStopBinlogServerRequest$1(this.executorBinlogServer$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.taskContextRef$1 = taskContextRef$1;
                        this.executorBinlogServer$1 = executorBinlogServer$1;
                    }
                });
                TaskContext$.MODULE$.get().addTaskCompletionListener(new TaskCompletionListener(this, taskContextRef, executorBinlogServer){
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$launchBinlogServer$1$1 $outer;
                    private final AtomicReference taskContextRef$1;
                    private final BinLogSocketServerInExecutor executorBinlogServer$1;

                    public void onTaskCompletion(TaskContext context) {
                        this.taskContextRef$1.set(null);
                        this.$outer.org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$anonfun$$sendStopBinlogServerRequest$1(this.executorBinlogServer$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.taskContextRef$1 = taskContextRef$1;
                        this.executorBinlogServer$1 = executorBinlogServer$1;
                    }
                });
                Socket socket = new Socket(this.tempSocketServerHost$1, this.tempSocketServerPort$1);
                DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
                BinLogSocketServerCommand$.MODULE$.sendRequest(dout, new ReportBinlogSocketServerHostAndPort(executorBinlogServer.host(), executorBinlogServer.port()));
                socket.close();
                SocketServerInExecutor$.MODULE$.addNewBinlogServer(new MySQLBinlogServer(this.bingLogHost$1, this.bingLogPort$1), executorBinlogServer);
                executorBinlogServer.connectMySQL(new MySQLConnectionInfo(this.bingLogHost$1, this.bingLogPort$1, this.bingLogUserName$1, this.bingLogPassword$1, (Option<String>)this.binlogFilename$1, (Option<Object>)this.binlogPos$1, (Option<String>)this.databaseNamePattern$1, (Option<String>)this.tableNamePattern$1), true);
                while (!TaskContext$.MODULE$.get().isInterrupted() && !executorBinlogServer.isClosed()) {
                    Thread.sleep(1000L);
                }
                return new ExecutorBinlogServer(executorBinlogServer.host(), executorBinlogServer.port());
            }

            public final void org$apache$spark$sql$mlsql$sources$MLSQLBinLogDataSource$$anonfun$$sendStopBinlogServerRequest$1(BinLogSocketServerInExecutor executorBinlogServer$1) {
                Socket socket2 = new Socket(executorBinlogServer$1.host(), executorBinlogServer$1.port());
                DataOutputStream dout2 = new DataOutputStream(socket2.getOutputStream());
                BinLogSocketServerCommand$.MODULE$.sendRequest(dout2, new ShutdownBinlogServer());
                socket2.close();
            }
            {
                this.bingLogHost$1 = bingLogHost$1;
                this.bingLogPort$1 = bingLogPort$1;
                this.bingLogUserName$1 = bingLogUserName$1;
                this.bingLogPassword$1 = bingLogPassword$1;
                this.databaseNamePattern$1 = databaseNamePattern$1;
                this.tableNamePattern$1 = tableNamePattern$1;
                this.checkPointDir$1 = checkPointDir$1;
                this.binlogFilename$1 = binlogFilename$1;
                this.binlogPos$1 = binlogPos$1;
                this.tempSocketServerHost$1 = tempSocketServerHost$1;
                this.tempSocketServerPort$1 = tempSocketServerPort$1;
                this.maxBinlogQueueSize$1 = maxBinlogQueueSize$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutorBinlogServer.class)).collect();
    }
}

