/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.mlsql.sources.mysql.binlog;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.mlsql.sources.ExecutorInternalBinlogConsumer;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ExecutorBinlogServer;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ExecutorBinlogServerConsumerCache;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.ExecutorBinlogServerConsumerCache$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ExecutorBinlogServerConsumerCache$
implements Logging {
    public static final ExecutorBinlogServerConsumerCache$ MODULE$;
    private LinkedHashMap<ExecutorBinlogServerConsumerCache.CacheKey, ExecutorInternalBinlogConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ExecutorBinlogServerConsumerCache$();
    }

    private LinkedHashMap cache$lzycompute() {
        ExecutorBinlogServerConsumerCache$ executorBinlogServerConsumerCache$ = this;
        synchronized (executorBinlogServerConsumerCache$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.mlsql.binlog.capacity", 64);
                this.cache = new LinkedHashMap<ExecutorBinlogServerConsumerCache.CacheKey, ExecutorInternalBinlogConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<ExecutorBinlogServerConsumerCache.CacheKey, ExecutorInternalBinlogConsumer> entry) {
                        if (entry.getValue().inUse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        ExecutorBinlogServerConsumerCache$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            ExecutorBinlogServerConsumerCache$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest Kafka consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private LinkedHashMap<ExecutorBinlogServerConsumerCache.CacheKey, ExecutorInternalBinlogConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public synchronized ExecutorInternalBinlogConsumer acquire(ExecutorBinlogServer executorBinlogServer) {
        ExecutorInternalBinlogConsumer executorInternalBinlogConsumer;
        ObjectRef newInternalConsumer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        ExecutorBinlogServerConsumerCache.CacheKey key = new ExecutorBinlogServerConsumerCache.CacheKey(executorBinlogServer.host(), executorBinlogServer.port());
        ExecutorInternalBinlogConsumer existingInternalConsumer = this.cache().get(key);
        if (existingInternalConsumer == null) {
            this.cache().put(key, this.newInternalConsumer$1(executorBinlogServer, newInternalConsumer$lzy, bitmap$0));
            this.newInternalConsumer$1(executorBinlogServer, newInternalConsumer$lzy, bitmap$0).inUse_$eq(true);
            executorInternalBinlogConsumer = this.newInternalConsumer$1(executorBinlogServer, newInternalConsumer$lzy, bitmap$0);
        } else if (existingInternalConsumer.inUse()) {
            executorInternalBinlogConsumer = this.newInternalConsumer$1(executorBinlogServer, newInternalConsumer$lzy, bitmap$0);
        } else {
            existingInternalConsumer.inUse_$eq(true);
            executorInternalBinlogConsumer = existingInternalConsumer;
        }
        return executorInternalBinlogConsumer;
    }

    public void release(ExecutorInternalBinlogConsumer intConsumer) {
        ExecutorBinlogServerConsumerCache$ executorBinlogServerConsumerCache$ = this;
        synchronized (executorBinlogServerConsumerCache$) {
            Object object;
            ExecutorBinlogServerConsumerCache.CacheKey key = new ExecutorBinlogServerConsumerCache.CacheKey(intConsumer.executorBinlogServer().host(), intConsumer.executorBinlogServer().port());
            ExecutorInternalBinlogConsumer cachedIntConsumer = this.cache().get(key);
            if (intConsumer == cachedIntConsumer) {
                if (intConsumer.markedForClose()) {
                    intConsumer.close();
                    object = this.cache().remove(key);
                } else {
                    intConsumer.inUse_$eq(false);
                    object = BoxedUnit.UNIT;
                }
            } else {
                intConsumer.close();
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Released a supposedly cached consumer that was not found in the cache"})).s((Seq)Nil$.MODULE$);
                    }
                });
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final ExecutorInternalBinlogConsumer newInternalConsumer$lzycompute$1(ExecutorBinlogServer executorBinlogServer$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        ExecutorBinlogServerConsumerCache$ executorBinlogServerConsumerCache$ = this;
        synchronized (executorBinlogServerConsumerCache$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                newInternalConsumer$lzy$1.elem = new ExecutorInternalBinlogConsumer(executorBinlogServer$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ExecutorInternalBinlogConsumer)newInternalConsumer$lzy$1.elem;
        }
    }

    private final ExecutorInternalBinlogConsumer newInternalConsumer$1(ExecutorBinlogServer executorBinlogServer$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.newInternalConsumer$lzycompute$1(executorBinlogServer$1, newInternalConsumer$lzy$1, bitmap$0$1) : (ExecutorInternalBinlogConsumer)newInternalConsumer$lzy$1.elem;
    }

    private ExecutorBinlogServerConsumerCache$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

